/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UIConfirmForm.gtmpl")
public class UIConfirmForm
extends UIForm
implements UIPopupComponent {
    public static String CONFIRM_TRUE = "true";
    public static String CONFIRM_FALSE = "false";
    private String config_id = "";
    private String confirmMessage;
    private boolean isDelete;
    private boolean isDeleteMultiple;
    public static final String SAVE_CONFIRM = "confirm";
    private static final String SAVE_ALL = "save_all";
    private static final String SAVE_ONE = "save_one";
    private static final String SAVE_FOLLOW = "save_follow";
    private static final String CANCEL = "Cancel";
    private static final String SAVE = "Save";
    private static final String DELETE = "Delete";
    private static final Collection<String> DELETE_ACTIONS = Arrays.asList("ConfirmDeleteOnlyInstance", "ConfirmDeleteFollowingSeries", "ConfirmDeleteAllSeries");
    private static final Collection<String> UPDATE_ACTIONS = Arrays.asList("ConfirmUpdateOnlyInstance", "ConfirmUpdateFollowSeries", "ConfirmUpdateAllSeries");
    private Collection<CalendarEvent> events;

    public UIConfirmForm() {
        UIFormRadioBoxInput input = new UIFormRadioBoxInput(SAVE_CONFIRM, SAVE_CONFIRM, this.getValue());
        input.setValue((Object)SAVE_ONE);
        input.setAlign(UIFormRadioBoxInput.VERTICAL_ALIGN);
        this.addUIFormInput((UIFormInput)input);
    }

    public String getId() {
        if (this.isDeleteMultiple()) {
            if (this.isMutipleTask()) {
                return super.getId() + "Tasks";
            }
            if (this.isMutipleEvent()) {
                return super.getId() + "Events";
            }
            return super.getId() + "EventsAndTasks";
        }
        if (this.isDelete) {
            return super.getId() + DELETE;
        }
        return super.getId() + "Update";
    }

    private List<SelectItemOption<String>> getValue() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(SAVE_ONE, (Object)SAVE_ONE));
        options.add(new SelectItemOption(SAVE_FOLLOW, (Object)SAVE_FOLLOW));
        options.add(new SelectItemOption(SAVE_ALL, (Object)SAVE_ALL));
        return options;
    }

    public boolean isSaveOne() {
        try {
            return this.getUIInput(SAVE_CONFIRM).getValue() == SAVE_ONE;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isSaveAll() {
        try {
            return this.getUIInput(SAVE_CONFIRM).getValue() == SAVE_ALL;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isSaveFollow() {
        try {
            return this.getUIInput(SAVE_CONFIRM).getValue() == SAVE_FOLLOW;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setConfirmMessage(String confirmMessage) {
        this.confirmMessage = confirmMessage;
    }

    public String getConfirmMessage() {
        try {
            if (this.isMutipleEvent()) {
                return this.getLabel("confirm-delete-events");
            }
            if (this.isMutipleTask()) {
                return this.getLabel("confirm-delete-tasks");
            }
            if (this.isDeleteMultiple() || this.confirmMessage == null) {
                return this.getLabel("confirm-delete-multiple");
            }
            return this.getLabel(this.confirmMessage);
        }
        catch (Exception e) {
            return this.confirmMessage;
        }
    }

    boolean isMutipleTask() {
        boolean isAllTask;
        boolean bl = isAllTask = this.events != null;
        if (this.events != null) {
            for (CalendarEvent ce : this.events) {
                if (ce == null || !CalendarEvent.TYPE_EVENT.equals(ce.getEventType())) continue;
                isAllTask = false;
                break;
            }
        }
        return isAllTask;
    }

    boolean isMutipleEvent() {
        boolean isAllEvent;
        boolean bl = isAllEvent = this.events != null;
        if (this.events != null) {
            for (CalendarEvent ce : this.events) {
                if (ce == null || !CalendarEvent.TYPE_TASK.equals(ce.getEventType())) continue;
                isAllEvent = false;
                break;
            }
        }
        return isAllEvent;
    }

    public String event(String name) throws Exception {
        StringBuilder b = new StringBuilder();
        b.append("javascript:eXo.webui.UIForm.submitForm('").append(this.getConfig_id()).append("','");
        if (this.isDelete()) {
            if (DELETE.equals(name)) {
                if (this.isSaveOne()) {
                    name = "ConfirmDeleteOnlyInstance";
                } else if (this.isSaveAll()) {
                    name = "ConfirmDeleteAllSeries";
                } else if (this.isSaveFollow()) {
                    name = "ConfirmDeleteFollowingSeries";
                }
            } else if (CANCEL.equals(name)) {
                name = "ConfirmDeleteCancel";
            }
        } else if (SAVE.equals(name)) {
            if (this.isSaveOne()) {
                name = "ConfirmUpdateOnlyInstance";
            } else if (this.isSaveAll()) {
                name = "ConfirmUpdateAllSeries";
            } else if (this.isSaveFollow()) {
                name = "ConfirmUpdateFollowSeries";
            }
        } else if (CANCEL.equals(name)) {
            name = "ConfirmUpdateCancel";
        }
        b.append(name).append("',true)");
        return b.toString();
    }

    public void setConfig_id(String config_id) {
        this.config_id = config_id;
    }

    public String getConfig_id() {
        return this.config_id;
    }

    Collection<String> getAllActions() {
        Stack<String> s = new Stack<String>();
        if (this.isDelete()) {
            for (String name : DELETE_ACTIONS) {
                StringBuilder b = new StringBuilder();
                b.append("javascript:eXo.webui.UIForm.submitForm('").append(this.getConfig_id()).append("','");
                b.append(name).append("',true);");
                s.add(b.toString());
            }
        } else {
            for (String name : UPDATE_ACTIONS) {
                StringBuilder b = new StringBuilder();
                b.append("javascript:eXo.webui.UIForm.submitForm('").append(this.getConfig_id()).append("','");
                b.append(name).append("',true);");
                s.add(b.toString());
            }
        }
        return s;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String[] getActions() {
        if (this.isDelete() || this.isDeleteMultiple) {
            return new String[]{DELETE, CANCEL};
        }
        return new String[]{SAVE, CANCEL};
    }

    public boolean isDelete() {
        return this.isDelete;
    }

    public void setDelete(boolean isDelete) {
        this.isDelete = isDelete;
    }

    public boolean isDeleteMultiple() {
        return this.events != null && this.events.size() > 0;
    }

    public void setDeleteMultiple(boolean deleteMultiple) {
        this.isDeleteMultiple = deleteMultiple;
    }

    public Collection<CalendarEvent> getEvents() {
        return this.events;
    }

    public void setEvents(Collection<CalendarEvent> events) {
        this.events = events;
    }

    public void setEvent(CalendarEvent ev) {
        if (this.events == null) {
            this.events = new ArrayList();
        }
        this.events.add(ev);
    }
}

