/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.PermissionOwner;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.util.CalendarUtils;
import org.exoplatform.calendar.webui.popup.UIPermissionGrid;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UISharedForm;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * Exception performing whole class analysis ignored.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UISharedForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={OpenSelectUserFormActionListener.class}), @EventConfig(listeners={SelectUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OpenSelectGroupFormActionListener.class}), @EventConfig(listeners={SelectGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OpenSelectMembershipFormActionListener.class}), @EventConfig(listeners={SelectMembershipActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddEntryActionListener.class}), @EventConfig(listeners={DeleteEntryActionListener.class}), @EventConfig(listeners={UIPopupWindow.CloseActionListener.class}, name="Close", phase=Event.Phase.DECODE)}), @ComponentConfig(id="UIPopupUserSelector", type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={UIPopupWindow.CloseActionListener.class}, name="ClosePopup"), @EventConfig(listeners={SelectUserActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, name="Close", phase=Event.Phase.DECODE)})})
public class UISharedForm
extends UIForm
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getExoLogger(UISharedForm.class);
    private String calendarId_;
    protected boolean isAddNew_ = true;
    public static final String PERMISSION_GRID = "UIPermissionGrid";
    public static final String PERMISSION_ENTRY = "UIPermissionEntry";
    public static final String POPUP_USER_SELECTOR = "UIPopupUserSelector";
    public static final String POPUP_GROUP_MEMBERSHIP_SELECTOR = "UIPopupGroupMembershipSelector";
    public static final String OPEN_SELECT_USER_FORM = "OpenSelectUserForm";
    public static final String OPEN_SELECT_MEMBERSHIP_FORM = "OpenSelectMembershipForm";
    public static final String OPEN_SELECT_GROUP_FORM = "OpenSelectGroupForm";
    public static final String ADD_ENTRY = "AddEntry";
    public static final String DELETE_ENTRY = "DeleteEntry";
    public static final String USER_ICON = "uiIconUser uiIconLightGray";
    public static final String MEMBERSHIP_ICON = "uiIconMembership uiIconLightGray";
    public static final String GROUP_ICON = "uiIconGroup uiIconLightGray";
    public static final String ADD_ICON = "ActionIcon Add";
    public static final String INPUT_PERMISSION_OWNER = "PermissionOwnerInput";
    public static String INPUT_PERMISSION_OWNER_LABEL = "Select recipient";
    public static final int TYPE_BUTTON = 5;
    public static final String SAVE = "Save";
    public static final String CLOSE = "Cancel";
    private Map<String, Set<UIFormInputWithActions.ActionData>> actionField;
    private String calendarName;
    private Set<Permission> calendarPermissions = new HashSet();

    public UISharedForm() throws Exception {
        this.actionField = new HashMap();
        UIPermissionGrid permissionGrid = new UIPermissionGrid("UIPermissionGrid");
        this.addChild((UIComponent)permissionGrid);
        String[] actionNames = new String[]{"OpenSelectUserForm", "OpenSelectMembershipForm", "OpenSelectGroupForm", "AddEntry"};
        String[] actionIcons = new String[]{"uiIconUser uiIconLightGray", "uiIconMembership uiIconLightGray", "uiIconGroup uiIconLightGray", "ActionIcon Add"};
        LinkedHashSet<UIFormInputWithActions.ActionData> actions = new LinkedHashSet<UIFormInputWithActions.ActionData>();
        for (int i = 0; i < actionNames.length; ++i) {
            UIFormInputWithActions.ActionData action = new UIFormInputWithActions.ActionData();
            action.setActionListener(actionNames[i]);
            if (i < actionNames.length - 1) {
                action.setActionType(0);
            } else {
                action.setActionType(5);
            }
            action.setActionName(actionNames[i]);
            action.setCssIconClass(actionIcons[i]);
            actions.add(action);
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        INPUT_PERMISSION_OWNER_LABEL = res.getString("UISharedForm.label.UIPermissionOwnerInput");
        this.addUIFormInput((UIFormInput)new UIFormStringInput("PermissionOwnerInput", null, INPUT_PERMISSION_OWNER_LABEL));
        this.setActionField("PermissionOwnerInput", actions);
        this.addPopupWindow();
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public Set<Permission> getCalendarPermissions() {
        return this.calendarPermissions;
    }

    public void addPermission(Permission aPermission) throws Exception {
        if (this.containsPermission(aPermission.getId())) {
            return;
        }
        if (aPermission.getId().equals(CalendarUtils.getCurrentUser())) {
            return;
        }
        this.calendarPermissions.add(aPermission);
        UIPermissionGrid permissionGrid = (UIPermissionGrid)this.getChildById("UIPermissionGrid");
        permissionGrid.addEntry(aPermission);
    }

    public boolean containsPermission(String permissionId) {
        for (Permission aPermission : this.calendarPermissions) {
            if (!aPermission.getOwner().getId().equals(permissionId)) continue;
            return true;
        }
        return false;
    }

    public void removePermission(String permissionId) {
        Iterator it = this.calendarPermissions.iterator();
        while (it.hasNext()) {
            Permission aPermission = (Permission)it.next();
            if (!aPermission.getId().equals(permissionId)) continue;
            it.remove();
            break;
        }
        ((UIPermissionGrid)this.getChild(UIPermissionGrid.class)).removeEntry(permissionId);
    }

    public void setActionField(String fieldName, Set<UIFormInputWithActions.ActionData> actions) throws Exception {
        this.actionField.put(fieldName, actions);
    }

    public Set<UIFormInputWithActions.ActionData> getActionField(String fieldName) {
        return (Set)this.actionField.get(fieldName);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void init(String username, Calendar calendar, boolean isAddNew) throws Exception {
        this.isAddNew_ = isAddNew;
        this.calendarId_ = calendar.getId();
        this.calendarName = calendar.getName();
        if (calendar.getViewPermission() != null) {
            for (String permission : calendar.getViewPermission()) {
                Permission aPermission = new Permission(PermissionOwner.createPermissionOwnerFrom((String)permission));
                if (Arrays.asList(calendar.getEditPermission()).contains(permission)) {
                    aPermission.allowEditPermission();
                }
                this.addPermission(aPermission);
            }
        }
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    private void addPopupWindow() throws Exception {
        this.addChild(UIPopupWindow.class, "UIPopupUserSelector", "UIPopupUserSelector");
        this.addChild(UIPopupWindow.class, null, "UIPopupGroupMembershipSelector");
    }

    private void closeAllPopupAction() {
        ArrayList children = new ArrayList(this.getChildren());
        for (UIComponent uichild : children) {
            if (!(uichild instanceof UIPopupWindow)) continue;
            UISharedForm.closePopupAction((UIPopupWindow)((UIPopupWindow)uichild));
        }
    }

    private static void closePopupAction(UIPopupWindow uiPopupWindow) {
        uiPopupWindow.setUIComponent(null);
        uiPopupWindow.setShow(false);
    }

    private static void openPopupAction(UIPopupWindow uiPopup, UIComponent component, int width, int height) {
        uiPopup.setUIComponent(component);
        uiPopup.setShow(true);
        uiPopup.setWindowSize(width, height);
    }

    public void updatePermissionOwnerInputWith(String permissionId) throws Exception {
        UIFormStringInput permissionOwner = (UIFormStringInput)this.getChildById("PermissionOwnerInput");
        if (permissionOwner.getValue() == null) {
            permissionOwner.setValue((Object)"");
        }
        if (((String)permissionOwner.getValue()).contains(permissionId) || permissionId.equals(CalendarUtils.getCurrentUser())) {
            return;
        }
        if (((String)permissionOwner.getValue()).equals(INPUT_PERMISSION_OWNER_LABEL) || ((String)permissionOwner.getValue()).isEmpty()) {
            permissionOwner.setValue((Object)permissionId);
        } else {
            permissionOwner.setValue((Object)((String)permissionOwner.getValue() + CalendarUtils.COMMA + " " + permissionId));
        }
    }

    private static Set<String> getUsersByGroupId(String groupId) throws Exception {
        OrganizationService organizationService = CalendarUtils.getOrganizationService();
        List users = organizationService.getUserHandler().findUsersByGroup(groupId).getAll();
        HashSet<String> userIds = new HashSet<String>();
        if (users == null) {
            return userIds;
        }
        for (User user : users.toArray(new User[0])) {
            userIds.add(user.getUserName());
        }
        return userIds;
    }

    public static Set<String> getUsersAbleToEditSharedCalendar(Calendar calendar) throws Exception {
        HashSet<String> users = new HashSet<String>();
        for (String permissionId : calendar.getEditPermission()) {
            Permission aPermission = new Permission(PermissionOwner.createPermissionOwnerFrom((String)permissionId));
            PermissionOwner owner = aPermission.getOwner();
            if (owner.getOwnerType().equals("user")) {
                users.add(owner.getId());
                continue;
            }
            if (owner.getOwnerType().equals("group")) {
                users.addAll(UISharedForm.getUsersByGroupId((String)owner.getGroupId()));
                continue;
            }
            if (!owner.getOwnerType().equals("membership")) continue;
            users.addAll(Utils.getUserByMembershipId((String)owner.getMembership(), (String)owner.getGroupId()));
        }
        return users;
    }

    public static boolean canUserEditCalendar(String userId, Calendar calendar) throws Exception {
        return UISharedForm.getUsersAbleToEditSharedCalendar((Calendar)calendar).contains(userId);
    }

    static /* synthetic */ String access$000(UISharedForm x0) {
        return x0.calendarId_;
    }

    static /* synthetic */ void access$100(UISharedForm x0) {
        x0.closeAllPopupAction();
    }

    static /* synthetic */ void access$200(UIPopupWindow x0, UIComponent x1, int x2, int x3) {
        UISharedForm.openPopupAction((UIPopupWindow)x0, (UIComponent)x1, (int)x2, (int)x3);
    }

    static /* synthetic */ void access$300(UIPopupWindow x0) {
        UISharedForm.closePopupAction((UIPopupWindow)x0);
    }
}

