/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.calendar.model.query.CalendarQuery;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.ExtendedCalendarService;
import org.exoplatform.calendar.util.CalendarUtils;
import org.exoplatform.calendar.webui.UICalendarContainer;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UICalendarViewContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;

@ComponentConfig(template="app:/templates/calendar/webui/UICalendarWorkingContainer.gtmpl")
public class UICalendarWorkingContainer
extends UIContainer {
    public static boolean SHOW_LEFT_CONTAINER_DEFAULT = true;
    private Map<String, List<Calendar>> calendars = new HashMap();
    private LinkedHashMap<String, String> colorMap = new LinkedHashMap();
    private CalendarService calService = (CalendarService)this.getApplicationComponent(CalendarService.class);
    private ExtendedCalendarService xCalService = (ExtendedCalendarService)this.getApplicationComponent(ExtendedCalendarService.class);

    public UICalendarWorkingContainer() throws Exception {
        this.addChild(UICalendarContainer.class, null, null);
        this.addChild(UICalendarViewContainer.class, null, null);
    }

    public void init() throws Exception {
        PortletRequestContext context = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        Object initilized = context.getAttribute(this.getClass().toString());
        if (initilized != null) {
            return;
        }
        context.setAttribute(this.getClass().toString(), (Object)true);
        this.colorMap.clear();
        this.calendars.clear();
        Identity identity = ConversationState.getCurrent().getIdentity();
        CalendarQuery query = new CalendarQuery();
        query.setIdentity(identity);
        List tmp = this.xCalService.getCalendarHandler().findCalendars(query);
        for (org.exoplatform.calendar.model.Calendar cal : tmp) {
            LinkedList<Calendar> cals;
            Calendar calendar = Calendar.build((org.exoplatform.calendar.model.Calendar)cal);
            int t = this.calService.getTypeOfCalendar(identity.getUserId(), cal.getId());
            Calendar.Type type = Calendar.Type.getType((int)t);
            String typeName = Calendar.Type.UNDEFINED.equals((Object)type) ? String.valueOf(t) : type.name();
            if (calendar.isShared(identity.getUserId())) {
                typeName = Calendar.Type.SHARED.name();
            }
            if ((cals = (LinkedList<Calendar>)this.calendars.get(typeName)) == null) {
                cals = new LinkedList<Calendar>();
                this.calendars.put(typeName, cals);
            }
            cals.add(calendar);
            this.colorMap.put(cal.getId(), cal.getCalendarColor());
        }
        CalendarSetting setting = CalendarUtils.getCalendarService().getCalendarSetting(CalendarUtils.getCurrentUser());
        for (String key : setting.getSharedCalendarsColors()) {
            this.colorMap.put(key.split(CalendarUtils.COLON)[0], key.split(CalendarUtils.COLON)[1]);
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.init();
        super.processRender(context);
    }

    public static boolean isShowLeftContainer() {
        HttpServletRequest req = Util.getPortalRequestContext().getRequest();
        Cookie[] cookies = req.getCookies();
        boolean showLeftContainer = SHOW_LEFT_CONTAINER_DEFAULT;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("calendarlayout-" + req.getRemoteUser())) continue;
                if (!cookie.getValue().equals("")) break;
                showLeftContainer = false;
                break;
            }
        }
        return showLeftContainer;
    }

    public Map<String, List<Calendar>> getCalendarMap() {
        return this.calendars;
    }

    public Map<String, String> getColorMap() {
        return this.colorMap;
    }

    private boolean isInSpaceContext() {
        return ((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).isInSpaceContext();
    }
}

