/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.util.CalendarUtils;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIListContainer;
import org.exoplatform.calendar.webui.UIListView;
import org.exoplatform.calendar.webui.UIPreview;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadService;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIDefaultPreview.gtmpl", events={@EventConfig(listeners={DownloadActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmCloseActionListener.class}), @EventConfig(listeners={UICalendarView.AbortCloseActionListener.class}), @EventConfig(listeners={CloseWindowActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteOnlyInstance.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteAllSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteFollowingSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteCancel.class})})
public class UIPreview
extends UICalendarView
implements UIPopupComponent {
    public static final int DEFAULT_THUMBNAIL_DIMENSION = 50;
    public static final int DEFAULT_PREVIEW_DIMENSION = 170;
    private Event event_ = null;
    private boolean isShowPopup_ = false;
    private boolean isPreviewByUrl = false;
    protected static final String CLOSE_POPUP = "CloseWindow";

    public String getRestThumbnailLinkFor(Attachment attachment, int oneFixedDimension) throws Exception {
        int[] imageDimension = this.getScaledImageDimensionFor(attachment, oneFixedDimension);
        return "/" + PortalContainer.getInstance().getRestContextName() + "/thumbnailImage/custom/" + imageDimension[0] + "x" + imageDimension[1] + "/repository/collaboration/" + attachment.getDataPath();
    }

    private int getImageAttachmentWidth(Attachment attachment) throws Exception {
        return ImageIO.read(attachment.getInputStream()).getWidth();
    }

    private int getImageAttachmentHeight(Attachment attachment) throws Exception {
        return ImageIO.read(attachment.getInputStream()).getHeight();
    }

    private int[] getScaledImageDimensionFor(Attachment imageAttachment, int fixedDimension) throws Exception {
        int height;
        int width = this.getImageAttachmentWidth(imageAttachment);
        int biggerDimension = width > (height = this.getImageAttachmentHeight(imageAttachment)) ? width : height;
        int smallerDimension = biggerDimension == width ? height : width;
        double scalingRatio = (double)biggerDimension / (double)fixedDimension;
        int newScaledDimension = (int)Math.round((double)smallerDimension / scalingRatio);
        if (width > height) {
            return new int[]{fixedDimension, newScaledDimension};
        }
        if (width == height) {
            return new int[]{fixedDimension, fixedDimension};
        }
        return new int[]{newScaledDimension, fixedDimension};
    }

    public String getTemplate() {
        if (this.event_ == null) {
            return "app:/templates/calendar/webui/UIDefaultPreview.gtmpl";
        }
        if (this.event_.getEventType().equals(CalendarEvent.TYPE_EVENT)) {
            return "app:/templates/calendar/webui/UIEventPreview.gtmpl";
        }
        if (this.event_.getEventType().equals(CalendarEvent.TYPE_TASK)) {
            return "app:/templates/calendar/webui/UITaskPreview.gtmpl";
        }
        return "app:/templates/calendar/webui/UIDefaultPreview.gtmpl";
    }

    public Event getEvent() {
        return this.event_;
    }

    public void setEvent(Event event) {
        this.event_ = event;
    }

    public void refresh() throws Exception {
        if (this.getAncestorOfType(UIListContainer.class) != null) {
            this.event_ = ((UIListView)((UIListContainer)this.getAncestorOfType(UIListContainer.class)).findFirstComponentOfType(UIListView.class)).getSelectedEventObj();
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setShowPopup(boolean isShow) {
        this.isShowPopup_ = isShow;
    }

    public boolean isShowPopup() {
        return this.isShowPopup_;
    }

    public Attachment getAttachment(String attId) {
        if (this.getEvent() != null) {
            for (Attachment a : this.getEvent().getAttachment()) {
                if (!a.getId().equals(attId)) continue;
                return a;
            }
        }
        return null;
    }

    public String getDownloadLink(Attachment attach) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        return CalendarUtils.getDataSource((Attachment)attach, (DownloadService)dservice);
    }

    public String getImageSource(Attachment attach) throws Exception {
        try {
            return "/" + PortalContainer.getInstance().getRestContextName() + "/private/jcr/" + this.getRepository() + "/" + attach.getWorkspace() + attach.getDataPath();
        }
        catch (Exception e) {
            return this.getDownloadLink(attach);
        }
    }

    LinkedHashMap<String, Event> getDataMap() {
        LinkedHashMap<String, Event> dataMap = new LinkedHashMap<String, Event>();
        if (this.event_ != null) {
            dataMap.put(this.event_.getId(), this.event_);
        }
        return dataMap;
    }

    public Map<String, Map<String, CalendarEvent>> getRecurrenceMap() {
        HashMap<String, Map<String, CalendarEvent>> recurMap = new HashMap<String, Map<String, CalendarEvent>>();
        if (this.event_ != null) {
            HashMap<String, CalendarEvent> eventMap = new HashMap<String, CalendarEvent>();
            eventMap.put(this.event_.getRecurrenceId(), CalendarEvent.build((Event)this.event_));
            recurMap.put(this.event_.getId(), eventMap);
        }
        return recurMap;
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public String getDefaultStartTimeOfEvent() {
        return String.valueOf(this.calendar_.getTimeInMillis());
    }

    public static String getCalendarPortletUrl() {
        PortalRequestContext pContext = Util.getPortalRequestContext();
        String requestedURL = pContext.getRequest().getRequestURL().toString();
        if (requestedURL.indexOf("/details/") != -1) {
            return requestedURL.substring(0, requestedURL.indexOf("/details/"));
        }
        if (requestedURL.indexOf("/invitation/detail/") != -1) {
            return requestedURL.substring(0, requestedURL.indexOf("/invitation/detail/"));
        }
        return "";
    }

    public boolean isPreviewByUrl() {
        return this.isPreviewByUrl;
    }

    public void setPreviewByUrl(boolean isPreviewByUrl) {
        this.isPreviewByUrl = isPreviewByUrl;
    }
}

