/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.ws;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.rest.resource.ResourceContainer;

public class SubResourceHrefBuilder {
    private List<String> subResources = new LinkedList<String>();

    public SubResourceHrefBuilder(ResourceContainer restService) {
        this.subResources = this.getResourcesInfo(restService);
    }

    public String[] buildResourceMap(UriInfo uriInfo) {
        LinkedList<String> resources = new LinkedList<String>();
        StringBuilder uriBuilder = new StringBuilder();
        URI uri = uriInfo.getBaseUri();
        uriBuilder.append(uri.getScheme()).append("://");
        uriBuilder.append(uri.getHost());
        if (uri.getPort() != 80 && uri.getPort() != 443) {
            uriBuilder.append(":").append(uri.getPort());
        }
        uriBuilder.append(uri.getPath());
        String base = uriBuilder.toString();
        for (String rs : this.subResources) {
            resources.add(base + rs);
        }
        return resources.toArray(new String[resources.size()]);
    }

    private List<String> getResourcesInfo(ResourceContainer restService) {
        LinkedList<String> subResources = new LinkedList<String>();
        Path path = restService.getClass().getAnnotation(Path.class);
        if (path == null) {
            throw new IllegalStateException("base path for " + restService + " is not found");
        }
        String basePath = path.value();
        for (Method method : restService.getClass().getMethods()) {
            Path mPath = method.getAnnotation(Path.class);
            if (mPath == null) continue;
            String methodPath = mPath.value();
            subResources.add(basePath + methodPath);
        }
        return subResources;
    }
}

