/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.ws.bean;

import java.net.URI;
import java.net.URISyntaxException;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.ws.common.Resource;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AttachmentResource
extends Resource {
    private static final long serialVersionUID = -9218103606107024398L;
    private static final Log LOG = ExoLogger.getExoLogger(AttachmentResource.class);
    private String name;
    private String mimeType;
    private long weight;

    public AttachmentResource() {
        super(null);
    }

    public AttachmentResource(Attachment data, String basePath) {
        super(AttachmentResource.encode(data.getDataPath()));
        StringBuilder path = new StringBuilder(basePath);
        path.append("/attachments/");
        try {
            this.setHref(path.toString() + this.getId());
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        this.name = data.getName();
        this.mimeType = data.getMimeType();
        this.weight = data.getSize();
    }

    public static String encode(String id) {
        id = id.replace("/", "::");
        try {
            URI uri = new URI("http", "", "/" + id, "");
            return uri.toASCIIString().substring(8);
        }
        catch (URISyntaxException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String decode(String path) {
        return path.replace("::", "/");
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getWeight() {
        return this.weight;
    }
}

