/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.ws;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import com.sun.syndication.io.XmlReader;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCollection;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventDAO;
import org.exoplatform.calendar.service.EventHandler;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Invitation;
import org.exoplatform.calendar.service.PermissionOwner;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.RssData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.MailNotification;
import org.exoplatform.calendar.util.CalendarUtils;
import org.exoplatform.calendar.ws.RestEventQuery;
import org.exoplatform.calendar.ws.SubResourceHrefBuilder;
import org.exoplatform.calendar.ws.bean.AttachmentResource;
import org.exoplatform.calendar.ws.bean.CalendarResource;
import org.exoplatform.calendar.ws.bean.CategoryResource;
import org.exoplatform.calendar.ws.bean.CollectionResource;
import org.exoplatform.calendar.ws.bean.ErrorResource;
import org.exoplatform.calendar.ws.bean.EventResource;
import org.exoplatform.calendar.ws.bean.FeedResource;
import org.exoplatform.calendar.ws.bean.InvitationResource;
import org.exoplatform.calendar.ws.bean.ParticipantResource;
import org.exoplatform.calendar.ws.bean.RepeatResource;
import org.exoplatform.calendar.ws.bean.TaskResource;
import org.exoplatform.calendar.ws.bean.UploadResource;
import org.exoplatform.calendar.ws.common.Resource;
import org.exoplatform.commons.utils.DateUtils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.upload.UploadService;
import org.exoplatform.webservice.cs.bean.End;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/v1/calendar")
@Api(value="/v1/calendar", description="Entry point for calendar resources")
public class CalendarRestApi
implements ResourceContainer {
    public static final String CAL_BASE_URI = "/v1/calendar";
    public static final String TEXT_ICS = "text/calendar";
    public static final MediaType TEXT_ICS_TYPE = new MediaType("text", "calendar");
    public static final String BASE_URL = "/cs/calendar";
    public static final String BASE_EVENT_URL = "/cs/calendar/event";
    public static final String CALENDAR_URI = "/calendars/";
    public static final String EVENT_URI = "/events/";
    public static final String TASK_URI = "/tasks/";
    public static final String ICS_URI = "/ics";
    public static final String ATTACHMENT_URI = "/attachments/";
    public static final String OCCURRENCE_URI = "/occurrences";
    public static final String CATEGORY_URI = "/categories/";
    public static final String PARTICIPANT_URI = "/participants/";
    public static final String AVAILABILITY_URI = "/availabilities/";
    public static final String FEED_URI = "/feeds/";
    public static final String RSS_URI = "/rss";
    public static final String INVITATION_URI = "/invitations/";
    public static final String HEADER_LINK = "Link";
    public static final String HEADER_LOCATION = "Location";
    private OrganizationService orgService;
    private IdentityManager identityManager;
    private UploadService uploadService;
    private MailService mailService;
    private EventHandler eventHandler;
    private int defaultLimit = 10;
    private int hardLimit = 100;
    private SubResourceHrefBuilder subResourcesBuilder = new SubResourceHrefBuilder(this);
    private static final CacheControl nc = new CacheControl();
    public static final String DEFAULT_CAL_NAME = "calendar";
    public static final String DEFAULT_EVENT_NAME = "default";
    public static final String[] RP_WEEKLY_BYDAY = (String[])CalendarEvent.RP_WEEKLY_BYDAY.clone();
    public static final String[] EVENT_AVAILABILITY = new String[]{CalendarEvent.ST_AVAILABLE, CalendarEvent.ST_BUSY, CalendarEvent.ST_OUTSIDE};
    public static final String[] REPEATTYPES = (String[])CalendarEvent.REPEATTYPES.clone();
    public static final String RP_END_BYDATE = "endByDate";
    public static final String RP_END_AFTER = "endAfter";
    public static final String RP_END_NEVER = "neverEnd";
    public static final String[] PRIORITY = (String[])CalendarEvent.PRIORITY.clone();
    public static final String[] TASK_STATUS = (String[])CalendarEvent.TASK_STATUS.clone();
    private static final String[] INVITATION_STATUS = new String[]{"", "maybe", "yes", "no"};
    private org.exoplatform.calendar.model.query.EventQuery query = null;
    private final CacheControl cc = new CacheControl();
    private static final Log log;

    public CalendarRestApi(OrganizationService orgService, IdentityManager identityManager, UploadService uploadService, MailService mailService, InitParams params, EventHandler eventHandler) {
        this.orgService = orgService;
        this.identityManager = identityManager;
        this.uploadService = uploadService;
        this.mailService = mailService;
        this.eventHandler = eventHandler;
        int maxAge = 604800;
        if (params != null) {
            ValueParam cacheConfig;
            if (params.getValueParam("default.limit") != null) {
                this.defaultLimit = Integer.parseInt(params.getValueParam("default.limit").getValue());
            }
            if (params.getValueParam("hard.limit") != null) {
                this.hardLimit = Integer.parseInt(params.getValueParam("hard.limit").getValue());
            }
            if ((cacheConfig = params.getValueParam("cache_maxage")) != null) {
                try {
                    maxAge = Integer.parseInt(cacheConfig.getValue());
                }
                catch (Exception ex) {
                    log.warn("Can't parse {} to maxAge, use the default value {}", new Object[]{cacheConfig, maxAge});
                }
            }
        }
        this.cc.setPrivate(true);
        this.cc.setMaxAge(maxAge);
        this.cc.setSMaxAge(maxAge);
    }

    @GET
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns all the available subresources as json", notes="Returns all the available subresources as json, in order to navigate easily in the REST API.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of all available subresources")})
    public Response getSubResources(@Context UriInfo uri) {
        HashMap<String, String[]> subResources = new HashMap<String, String[]>();
        subResources.put("subResourcesHref", this.subResourcesBuilder.buildResourceMap(uri));
        return Response.ok(subResources, (String)"application/json").cacheControl(nc).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns all user-related calendars", notes="This method lists all the calendars a specific user can see.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of all user-related calendars"), @ApiResponse(code=404, message="Bad Request, or no calendars associated to the user"), @ApiResponse(code=503, message="Can't generate JSON file")})
    public Response getCalendars(@ApiParam(value="The calendar type to search for. It can be one of \"personal, group, shared\"", required=false, allowableValues="personal, group, shared") @QueryParam(value="type") String type, @ApiParam(value="The starting point when paging through a list of entities", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="The maximum number of results when paging through a list of entities, and do not exceed *hardLimit*. If not specified, *defaultLimit* will be used", required=false) @QueryParam(value="limit") int limit, @ApiParam(value="Tell the service if it must return the total size of the returned collection result, and the *link* http headers", required=false, defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="This is a list of comma-separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @Context UriInfo uri) {
        try {
            Response.ResponseBuilder okResult;
            CalendarCollection cals;
            limit = this.parseLimit(limit);
            Calendar.Type calType = Calendar.Type.UNDEFINED;
            if (type != null) {
                try {
                    calType = Calendar.Type.valueOf((String)type.toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    log.debug((Object)ex);
                }
            }
            if ((cals = CalendarRestApi.calendarServiceInstance().getAllCalendars(this.currentUserId(), calType.type(), offset, limit)) == null || cals.isEmpty()) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            String basePath = this.getBasePath(uri);
            LinkedList<Object> data = new LinkedList<Object>();
            for (Calendar cal : cals) {
                this.setCalType(cal);
                data.add(this.extractObject(new CalendarResource(cal, basePath), fields));
            }
            CollectionResource calData = new CollectionResource(data, returnSize ? cals.getFullSize() : -1L);
            calData.setOffset(offset);
            calData.setLimit(limit);
            if (jsonp != null) {
                JsonValue value = new JsonGeneratorImpl().createJsonObject(calData);
                StringBuilder sb = new StringBuilder(jsonp);
                sb.append("(").append(value).append(");");
                okResult = Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript"));
            } else {
                okResult = Response.ok(calData, (String)"application/json");
            }
            if (returnSize) {
                okResult.header(HEADER_LINK, (Object)this.buildFullUrl(uri, offset, limit, calData.getSize()));
            }
            return okResult.cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/")
    @ApiOperation(value="Creates a calendar", notes="Creates a calendar if: <br/>- this is a personal calendar and the user is authenticated<br/>- this is a group calendar and the user is authenticated and belongs to the group.")
    @ApiResponses(value={@ApiResponse(code=201, message="Calendar successfully created"), @ApiResponse(code=401, message="The User isn't authorized to create a calendar there")})
    public Response createCalendar(CalendarResource cal, @Context UriInfo uriInfo) {
        Response error;
        Calendar calendar = new Calendar();
        if (cal.getName() == null) {
            cal.setName(DEFAULT_CAL_NAME);
        }
        if (cal.getOwner() == null) {
            cal.setOwner(this.currentUserId());
        }
        if ((error = this.buildCalendar(calendar, cal)) != null) {
            return error;
        }
        if (cal.getGroups() != null && cal.getGroups().length > 0) {
            if (!this.isInGroups(cal.getGroups())) return Response.status((int)401).cacheControl(nc).build();
            CalendarRestApi.calendarServiceInstance().savePublicCalendar(calendar, true);
        } else {
            if (cal.getOwner() != null && !cal.getOwner().equals(this.currentUserId())) {
                return Response.status((int)401).cacheControl(nc).build();
            }
            String username = this.currentUserId();
            CalendarRestApi.calendarServiceInstance().saveUserCalendar(username, calendar, true);
            String[] viewPermissions = calendar.getViewPermission();
            if (viewPermissions != null && viewPermissions.length > 0) {
                HashSet<String> sharedUsers = new HashSet<String>();
                HashSet<String> sharedGroups = new HashSet<String>();
                for (String permission : viewPermissions) {
                    PermissionOwner perm = PermissionOwner.createPermissionOwnerFrom((String)permission);
                    if ("user".equals(perm.getOwnerType())) {
                        sharedUsers.add(perm.getId());
                        continue;
                    }
                    if ("group".equals(perm.getOwnerType())) {
                        sharedGroups.add(perm.getGroupId());
                        continue;
                    }
                    if (!"membership".equals(perm.getOwnerType())) continue;
                    try {
                        sharedUsers.addAll(Utils.getUserByMembershipId((String)perm.getMembership(), (String)perm.getGroupId()));
                    }
                    catch (Exception ex) {
                        log.warn((Object)("Can not share calendar to Membership: " + permission), (Throwable)ex);
                    }
                }
                if (sharedGroups.size() > 0) {
                    try {
                        CalendarRestApi.calendarServiceInstance().shareCalendarByRunJob(username, calendar.getId(), new ArrayList(sharedGroups));
                    }
                    catch (Exception ex) {
                        log.warn((Object)"Exception while share calendar to groups", (Throwable)ex);
                    }
                }
                if (sharedUsers.size() > 0) {
                    try {
                        CalendarRestApi.calendarServiceInstance().shareCalendar(username, calendar.getId(), new ArrayList(sharedUsers));
                    }
                    catch (Exception ex) {
                        log.warn((Object)"Exception while share calendar to users", (Throwable)ex);
                    }
                }
            }
        }
        StringBuilder location = new StringBuilder(this.getBasePath(uriInfo));
        location.append(CALENDAR_URI);
        location.append(calendar.getId());
        return Response.status((int)201).header(HEADER_LOCATION, (Object)location).cacheControl(nc).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Finds a calendar by ID", notes="Returns the calendar with the specified id parameter if:<br/>- The authenticated user is the owner of the calendar<br/>- The authenticated user belongs to the group of the calendar<br/>- The calendar has been shared with the authenticated user or with a group of the authenticated user")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of the calendar"), @ApiResponse(code=404, message="Calendar with provided ID Not Found"), @ApiResponse(code=503, message="Can't generate JSON file")})
    public Response getCalendarById(@ApiParam(value="Identity of the calendar to retrieve", required=true) @PathParam(value="id") String id, @ApiParam(value="This is a list of comma-separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo, @Context Request request) {
        try {
            CalendarService service = CalendarRestApi.calendarServiceInstance();
            Calendar cal = service.getCalendarById(id);
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            cal.setCalType(service.getTypeOfCalendar(this.currentUserId(), cal.getId()));
            Date lastModified = new Date(cal.getLastModified());
            Response.ResponseBuilder preCondition = request.evaluatePreconditions(lastModified);
            if (preCondition != null) {
                return preCondition.build();
            }
            CalendarResource calData = null;
            if (this.hasViewCalendarPermission(cal, this.currentUserId())) {
                this.setCalType(cal);
                calData = new CalendarResource(cal, this.getBasePath(uriInfo));
            }
            if (calData == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Object resource = this.extractObject(calData, fields);
            if (jsonp != null) {
                String json = null;
                if (resource instanceof Map) {
                    json = new JSONObject(resource).toString();
                } else {
                    JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                    json = generatorImpl.createJsonObject(resource).toString();
                }
                StringBuilder sb = new StringBuilder(jsonp);
                sb.append("(").append(json).append(");");
                return Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript")).cacheControl(this.cc).lastModified(lastModified).build();
            }
            return Response.ok((Object)resource, (String)"application/json").cacheControl(this.cc).lastModified(lastModified).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @PUT
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}")
    @ApiOperation(value="Updates a calendar", notes="Update the calendar with specified id if:<br/>- the authenticated user is the owner of the calendar<br/>- for group calendars, the authenticated user has edit rights on the calendar")
    @ApiResponses(value={@ApiResponse(code=200, message="Calendar successfully updated"), @ApiResponse(code=401, message="User unauthorized to update the calendar"), @ApiResponse(code=403, message="If user try to update invalid data to the calendar"), @ApiResponse(code=404, message="Calendar with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response updateCalendarById(@ApiParam(value="Identity of the calendar to update", required=true) @PathParam(value="id") String id, CalendarResource calObj) {
        try {
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(id);
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            if ((this.currentUserId().equals(cal.getCalendarOwner()) || cal.getGroups() != null) && Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                List<Object> oldViewPermissions = cal.getViewPermission() != null ? Collections.unmodifiableList(Arrays.asList(cal.getViewPermission())) : Collections.emptyList();
                Response error = this.buildCalendar(cal, calObj);
                if (error != null) {
                    return error;
                }
                int type = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), cal.getId());
                if (type == 0) {
                    if (!this.currentUserId().equals(cal.getCalendarOwner())) {
                        return Response.status((int)403).entity((Object)"Can not change owner of personal calendar").cacheControl(nc).build();
                    }
                    if (cal.getGroups() != null && cal.getGroups().length > 0) {
                        return Response.status((int)403).entity((Object)"Can not update groups of personal calendar").cacheControl(nc).build();
                    }
                }
                CalendarRestApi.calendarServiceInstance().saveCalendar(cal.getCalendarOwner(), cal, type, false);
                if (type == 0) {
                    List<Object> viewPermissions = cal.getViewPermission() != null ? Arrays.asList(cal.getViewPermission()) : Collections.emptyList();
                    boolean needUpdateShare = false;
                    if (oldViewPermissions.size() != viewPermissions.size()) {
                        needUpdateShare = true;
                    } else {
                        for (String string : oldViewPermissions) {
                            if (viewPermissions.contains(string)) continue;
                            needUpdateShare = true;
                            break;
                        }
                    }
                    if (needUpdateShare) {
                        String username = this.currentUserId();
                        String string = cal.getId();
                        HashSet<String> newSharedUsers = new HashSet<String>();
                        HashSet<String> newSharedGroups = new HashSet<String>();
                        for (String string2 : viewPermissions) {
                            PermissionOwner perm = PermissionOwner.createPermissionOwnerFrom((String)string2);
                            String string3 = perm.getOwnerType();
                            if ("user".equals(string3)) {
                                newSharedUsers.add(perm.getId());
                                continue;
                            }
                            if ("group".equals(string3)) {
                                newSharedGroups.add(perm.getGroupId());
                                continue;
                            }
                            if (!"membership".equals(string3)) continue;
                            try {
                                newSharedUsers.addAll(Utils.getUserByMembershipId((String)perm.getMembership(), (String)perm.getGroupId()));
                            }
                            catch (Exception ex) {
                                log.warn((Object)("Exception while try to share calendar to Membership: " + string2), (Throwable)ex);
                            }
                        }
                        HashSet<String> removeShareUsers = new HashSet<String>();
                        HashSet<String> hashSet = new HashSet<String>();
                        if (oldViewPermissions.size() > 0) {
                            for (String string4 : oldViewPermissions) {
                                if (viewPermissions.contains(string4)) continue;
                                PermissionOwner perm = PermissionOwner.createPermissionOwnerFrom((String)string4);
                                String ownerType = perm.getOwnerType();
                                if ("user".equals(ownerType)) {
                                    removeShareUsers.add(perm.getId());
                                    continue;
                                }
                                if ("group".equals(ownerType)) {
                                    hashSet.add(perm.getGroupId());
                                    continue;
                                }
                                if (!"membership".equals(ownerType)) continue;
                                try {
                                    removeShareUsers.addAll(Utils.getUserByMembershipId((String)perm.getMembership(), (String)perm.getGroupId()));
                                }
                                catch (Exception ex) {
                                    log.error((Object)("Exception when try unshare calendar to Membership: " + string4), (Throwable)ex);
                                }
                            }
                        }
                        for (String string5 : removeShareUsers) {
                            CalendarRestApi.calendarServiceInstance().removeSharedCalendar(string5, string);
                        }
                        if (hashSet.size() > 0) {
                            CalendarRestApi.calendarServiceInstance().removeSharedCalendarByJob(username, new ArrayList(hashSet), string);
                        }
                        if (newSharedUsers.size() > 0) {
                            newSharedUsers.remove(username);
                            CalendarRestApi.calendarServiceInstance().shareCalendar(username, string, new ArrayList(newSharedUsers));
                        }
                        if (newSharedGroups.size() > 0) {
                            CalendarRestApi.calendarServiceInstance().shareCalendarByRunJob(username, string, new ArrayList(newSharedGroups));
                        }
                    }
                }
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            log.error((Object)e);
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}")
    @ApiOperation(value="Deletes a calendar", notes="Delete the calendar with the specified id if:<br/>- the authenticated user is the owner of the calendar.<br/>- for group calendars, the authenticated user has edit rights on the calendar.<br/>- If it is a shared calendar the calendar is not shared anymore (but the original calendar is not deleted).")
    @ApiResponses(value={@ApiResponse(code=200, message="Calendar successfully deleted"), @ApiResponse(code=401, message="User unauthorized to delete the calendar"), @ApiResponse(code=404, message="Calendar with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response deleteCalendarById(@ApiParam(value="Identity of the calendar to delete", required=true) @PathParam(value="id") String id) {
        try {
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(id);
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            cal.setCalType(CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), id));
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal) || cal.getCalType() == 1) {
                switch (cal.getCalType()) {
                    case 0: {
                        CalendarRestApi.calendarServiceInstance().removeUserCalendar(cal.getCalendarOwner(), id);
                        break;
                    }
                    case 2: {
                        CalendarRestApi.calendarServiceInstance().removePublicCalendar(id);
                        break;
                    }
                    case 1: {
                        if (!this.hasViewCalendarPermission(cal, this.currentUserId())) break;
                        CalendarRestApi.calendarServiceInstance().removeSharedCalendar(this.currentUserId(), id);
                    }
                }
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}/ics")
    @Produces(value={"text/calendar"})
    @ApiOperation(value="Exports a calendar to iCal", notes="Returns an iCalendar formated file which is exported from the calendar with specified id if:<br/>- the calendar is public<br/>- the authenticated user is the owner of the calendar<br/>- the authenticated user belongs to the group of the calendar<br/>- the calendar has been shared with the authenticated user or with a group of the authenticated user")
    @ApiResponses(value={@ApiResponse(code=200, message="Calendar successfully exported to ICS"), @ApiResponse(code=404, message="Calendar with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred")})
    public Response exportCalendarToIcs(@ApiParam(value="Identity of the calendar to retrieve ICS file", required=true) @PathParam(value="id") String id, @Context Request request) {
        try {
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(id);
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            if (cal.getPublicUrl() != null || this.hasViewCalendarPermission(cal, this.currentUserId())) {
                byte[] data;
                byte[] hashCode;
                EntityTag tag;
                Response.ResponseBuilder preCondition;
                int type = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), id);
                String username = this.currentUserId();
                if (type == -1) {
                    type = 0;
                    username = cal.getCalendarOwner();
                }
                CalendarImportExport iCalExport = CalendarRestApi.calendarServiceInstance().getCalendarImportExports("ICalendar(.ics)");
                ArrayList<String> calIds = new ArrayList<String>();
                calIds.add(id);
                OutputStream out = iCalExport.exportCalendar(username, calIds, String.valueOf(type), -1);
                if (out == null) {
                    net.fortuna.ical4j.model.Calendar calendar = new net.fortuna.ical4j.model.Calendar();
                    calendar.getProperties().add((Property)new ProdId("-//Ben Fortuna//iCal4j 1.0//EN"));
                    calendar.getProperties().add((Property)Version.VERSION_2_0);
                    calendar.getProperties().add((Property)CalScale.GREGORIAN);
                    calendar.getProperties().add((Property)Method.REQUEST);
                    out = new ByteArrayOutputStream();
                    CalendarOutputter output = new CalendarOutputter(false);
                    output.output(calendar, out);
                }
                if ((preCondition = request.evaluatePreconditions(tag = new EntityTag(new String(hashCode = this.digest(data = out.toString().getBytes()).getBytes())))) != null) {
                    return preCondition.build();
                }
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                return Response.ok((Object)in, (MediaType)TEXT_ICS_TYPE).header("Content-Disposition", (Object)("attachment;filename=\"" + cal.getName() + ".ics")).cacheControl(this.cc).tag(tag).build();
            }
            return Response.status((int)404).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns an event by ID", notes="Returns an event with specified id parameter if:<br/>- the calendar of the event is public<br/>- the authenticated user is the owner of the calendar of the event<br/>- the authenticated user belongs to the group of the calendar of the event<br/>- the authenticated user is a participant of the event<br/>- the calendar of the event has been shared with the authenticated user or with a group of the authenticated user")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of the event"), @ApiResponse(code=404, message="Event with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred")})
    public Response getEventById(@ApiParam(value="Identity of the event to find", required=true) @PathParam(value="id") String id, @ApiParam(value="This is a list of comma separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="Used to ask for a full representation of a subresource, instead of only its link", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo, @Context Request request) {
        try {
            CalendarService service = CalendarRestApi.calendarServiceInstance();
            CalendarEvent ev = service.getEventById(id);
            if (ev == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Date lastModified = new Date(ev.getLastModified());
            Response.ResponseBuilder preCondition = request.evaluatePreconditions(lastModified);
            if (preCondition != null) {
                return preCondition.build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(ev.getCalendarId());
            boolean inParticipant = false;
            Object[] participant = ev.getParticipant();
            if (participant != null) {
                Arrays.sort(participant);
                if (Arrays.binarySearch(participant, this.currentUserId()) > -1) {
                    inParticipant = true;
                }
            }
            if (cal.getPublicUrl() != null || this.hasViewCalendarPermission(cal, this.currentUserId()) || inParticipant) {
                Object resource = this.buildEventResource(ev, uriInfo, expand, fields);
                return this.buildJsonP(resource, jsonp).cacheControl(this.cc).lastModified(lastModified).build();
            }
            return Response.status((int)404).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @PUT
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}")
    @ApiOperation(value="Updates an event identified by its ID", notes="Updates the event with specified id if:<br/>- the authenticated user is the owner of the calendar of the event<br/>- for group calendars, the authenticated user has edit rights on the calendar<br/>- the calendar of the event has been shared with the authenticated user, with modification rights<br/>- the calendar of the event has been shared with a group of the authenticated user, with modification rights")
    @ApiResponses(value={@ApiResponse(code=200, message="Event successfully updated"), @ApiResponse(code=400, message="Bad Request, parameters not valid"), @ApiResponse(code=401, message="User unauthorized to update the event"), @ApiResponse(code=404, message="Event with provided ID Not Found"), @ApiResponse(code=503, message="Error during the saving process")})
    public Response updateEventById(@ApiParam(value="Identity of the event to update", required=true) @PathParam(value="id") String id, @ApiParam(value="Recurring update type, can be ALL, FOLLOWING or ONE, by default, it's ONE", required=false) @QueryParam(value="recurringUpdateType") RecurringUpdateType recurringUpdateType, EventResource evObject) {
        try {
            CalendarEvent event = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (event == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            if (recurringUpdateType != null) {
                event = CalendarEvent.build((Event)event);
            }
            Calendar moveToCal = null;
            if (evObject.getCalendarId() != null && !event.getCalendarId().equals(evObject.getCalendarId())) {
                moveToCal = CalendarRestApi.calendarServiceInstance().getCalendarById(evObject.getCalendarId());
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(event.getCalendarId());
            int fromType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), cal.getId());
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal) && (moveToCal == null || Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)moveToCal))) {
                Response error = this.buildEvent(event, evObject, moveToCal);
                if (error != null) {
                    return error;
                }
                int toType = moveToCal != null ? moveToCal.getCalType() : fromType;
                moveToCal = moveToCal == null ? cal : moveToCal;
                this.saveEvent(cal.getId(), moveToCal.getId(), fromType, toType, event, recurringUpdateType, false);
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}")
    @ApiOperation(value="Deletes an event identified by its ID", notes="Delete an event with specified id parameter if:<br/>- the authenticated user is the owner of the calendar of the event<br/>- for group calendars, the authenticated user has edit rights on the calendar<br/>- the calendar of the event has been shared with the authenticated user, with modification rights<br/>- the calendar of the event has been shared with a group of the authenticated user, with modification rights")
    @ApiResponses(value={@ApiResponse(code=200, message="Event deleted successfully"), @ApiResponse(code=401, message="User unauthorized to delete this event"), @ApiResponse(code=404, message="Event with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response deleteEventById(@ApiParam(value="identity of the event to delete", required=true) @PathParam(value="id") String id) {
        try {
            CalendarEvent ev = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (ev == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(ev.getCalendarId());
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                int calType = -1;
                try {
                    calType = Integer.parseInt(ev.getCalType());
                }
                catch (NumberFormatException e) {
                    calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), ev.getCalendarId());
                }
                switch (calType) {
                    case 0: {
                        CalendarRestApi.calendarServiceInstance().removeUserEvent(this.currentUserId(), ev.getCalendarId(), id);
                        break;
                    }
                    case 2: {
                        CalendarRestApi.calendarServiceInstance().removePublicEvent(ev.getCalendarId(), id);
                        break;
                    }
                    case 1: {
                        CalendarRestApi.calendarServiceInstance().removeSharedEvent(this.currentUserId(), ev.getCalendarId(), id);
                        break;
                    }
                }
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}/attachments")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns the attachments of an event identified by its ID", notes="Returns attachments of an event with specified id if:<br/>- the calendar of the event is public<br/>- the authenticated user is the owner of the calendar of the event<br/>- the authenticated user belongs to the group of the calendar of the event<br/>- the authenticated user is a participant of the event<br/>- the calendar of the event has been shared with the authenticated user or with a group of the authenticated user")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of all attachments"), @ApiResponse(code=404, message="Event with provided ID Not Found"), @ApiResponse(code=503, message="An error occured during the saving process")})
    public Response getAttachmentsFromEvent(@ApiParam(value="Identity of an event to query for attachments", required=true) @PathParam(value="id") String id, @ApiParam(value="The starting point when paging through a list of entities", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="The maximum number of results when paging through a list of entities, and do not exceed *hardLimit*. If not specified, *defaultLimit* will be used*", required=false) @QueryParam(value="limit") int limit, @ApiParam(value="This is a list of comma-separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo) {
        try {
            limit = this.parseLimit(limit);
            CalendarEvent ev = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (ev == null || ev.getAttachment() == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(ev.getCalendarId());
            boolean inParticipant = false;
            if (ev.getParticipant() != null) {
                Object[] participant = ev.getParticipant();
                Arrays.sort(participant);
                int i = Arrays.binarySearch(participant, this.currentUserId());
                if (i > -1) {
                    inParticipant = true;
                }
            }
            if (cal.getPublicUrl() != null || this.hasViewCalendarPermission(cal, this.currentUserId()) || inParticipant) {
                Iterator it = ev.getAttachment().iterator();
                ArrayList<Object> attResource = new ArrayList<Object>();
                Utils.skip(it, (long)offset);
                int counter = 0;
                String basePath = this.getBasePath(uriInfo);
                while (it.hasNext()) {
                    Attachment a = (Attachment)it.next();
                    attResource.add(this.extractObject(new AttachmentResource(a, basePath), fields));
                    if (++counter != limit) continue;
                    break;
                }
                CollectionResource evData = new CollectionResource(attResource, ev.getAttachment().size());
                evData.setOffset(offset);
                evData.setLimit(limit);
                if (jsonp != null) {
                    JsonValue value = new JsonGeneratorImpl().createJsonObject(evData);
                    StringBuilder sb = new StringBuilder(jsonp);
                    sb.append("(").append(value).append(");");
                    return Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript")).cacheControl(nc).header(HEADER_LINK, (Object)this.buildFullUrl(uriInfo, offset, limit, evData.getSize())).build();
                }
                return Response.ok(evData, (String)"application/json").header(HEADER_LINK, (Object)this.buildFullUrl(uriInfo, offset, limit, evData.getSize())).cacheControl(nc).build();
            }
            return Response.status((int)404).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @POST
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}/attachments")
    @Consumes(value={"multipart/*"})
    @ApiOperation(value="Creates attachments for an event identified by its ID", notes="Creates attachments for an event with specified id if:<br/>- the authenticated user is the owner of the calendar of the event<br/>- for group calendars, the authenticated user has edit rights on the calendar<br/>- the calendar of the event has been shared with the authenticated user, with modification rights<br/>- the calendar of the event has been shared with a group of the authenticated user, with modification rights")
    @ApiResponses(value={@ApiResponse(code=201, message="Attachment successfully created"), @ApiResponse(code=401, message="User unauthorized to create an attachment to this event"), @ApiResponse(code=404, message="Event with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response createAttachmentForEvent(@Context UriInfo uriInfo, @ApiParam(value="Identity of an event where the attachment is created", required=true) @PathParam(value="id") String id, Iterator<FileItem> iter) {
        try {
            CalendarEvent event = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (event == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(event.getCalendarId());
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                int calType = -1;
                ArrayList<Attachment> attachment = new ArrayList<Attachment>();
                try {
                    calType = Integer.parseInt(event.getCalType());
                }
                catch (NumberFormatException e) {
                    calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), event.getCalendarId());
                }
                attachment.addAll(event.getAttachment());
                while (iter.hasNext()) {
                    FileItem file = iter.next();
                    String fileName = file.getName();
                    if (fileName == null) continue;
                    String mimeType = new MimeTypeResolver().getMimeType(fileName.toLowerCase());
                    Attachment at = new Attachment();
                    at.setMimeType(mimeType);
                    at.setSize(file.getSize());
                    at.setName(file.getName());
                    at.setInputStream(file.getInputStream());
                    attachment.add(at);
                }
                event.setAttachment(attachment);
                this.saveEvent(calType, event, false);
                StringBuilder attUri = new StringBuilder(this.getBasePath(uriInfo));
                attUri.append("/").append(event.getId());
                attUri.append(ATTACHMENT_URI);
                return Response.status((int)201).header(HEADER_LOCATION, (Object)attUri.toString()).cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}/events")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns the events of a calendar identified by its ID", notes="Returns events of an calendar with specified id when:<br/>- the calendar is public<br/>- the authenticated user is the owner of the calendar of the event<br/>- the authenticated user belongs to the group of the calendar of the event<br/>- the authenticated user is a participant of the event<br/>- the calendar of the event has been shared with the authenticated user or with a group of the authenticated user")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of all events from the calendar"), @ApiResponse(code=404, message="Calendar with provided ID Not Found")})
    public Response getEventsByCalendar(@ApiParam(value="Identity of a calendar to search for events", required=true) @PathParam(value="id") String id, @ApiParam(value="Date follow ISO8601 (YYYY-MM-DDThh:mm:ssTZD). Search for events *from* this date", required=false, defaultValue="Current server time") @QueryParam(value="startTime") String start, @ApiParam(value="Date follow ISO8601 (YYYY-MM-DDThh:mm:ssTZD). Search for events *to* this date", required=false, defaultValue="Current server time + 1 week") @QueryParam(value="endTime") String end, @ApiParam(value="Search for this category only. If not specified, search event of any category", required=false) @QueryParam(value="category") String category, @ApiParam(value="The starting point when paging through a list of entities", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="The maximum number of results when paging through a list of entities, and do not exceed *hardLimit*. If not specified, *defaultLimit* will be used", required=false) @QueryParam(value="limit") int limit, @ApiParam(value="This is a list of comma separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @ApiParam(value="Used to ask for a full representation of a subresource, instead of only its link", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Tells the service if it must return the total size of the returned collection result, and the *link* http headers", required=false, defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Context UriInfo uri) throws Exception {
        limit = this.parseLimit(limit);
        String username = this.currentUserId();
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        EventDAO evtDAO = service.getEventDAO();
        long fullSize = returnSize ? 0L : -1L;
        LinkedList<Object> data = new LinkedList<Object>();
        Calendar calendar = service.getCalendarById(id);
        if (calendar != null) {
            if (calendar.hasChildren()) {
                String participant = null;
                if (calendar.getPublicUrl() == null && !this.hasViewCalendarPermission(calendar, username)) {
                    participant = username;
                }
                EventQuery eventQuery = this.buildEventQuery(start, end, category, Arrays.asList(calendar), id, participant, CalendarEvent.TYPE_EVENT);
                ListAccess events = evtDAO.findEventsByQuery(eventQuery);
                for (CalendarEvent event : (CalendarEvent[])events.load(offset, limit)) {
                    data.add(this.buildEventResource(event, uri, expand, fields));
                }
                if (returnSize) {
                    fullSize = events.getSize();
                }
            }
        } else {
            return Response.status((int)404).cacheControl(nc).build();
        }
        CollectionResource evData = new CollectionResource(data, fullSize);
        evData.setOffset(offset);
        evData.setLimit(limit);
        Response.ResponseBuilder response = this.buildJsonP(evData, jsonp);
        if (returnSize) {
            response.header(HEADER_LINK, (Object)this.buildFullUrl(uri, offset, limit, fullSize));
        }
        return response.build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/events")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns the events of a calendar identified by its ID", notes="Returns events of an calendar with specified id when:<br/>- the calendar is public<br/>- the authenticated user is the owner of the calendar of the event<br/>- the authenticated user belongs to the group of the calendar of the event<br/>- the authenticated user is a participant of the event<br/>- the calendar of the event has been shared with the authenticated user or with a group of the authenticated user")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of all events from the calendar"), @ApiResponse(code=404, message="Calendar with provided ID Not Found")})
    public Response getEvents(@ApiParam(value="Date follow ISO8601 (YYYY-MM-DDThh:mm:ssTZD). Search for events *from* this date", required=false, defaultValue="Current server time") @QueryParam(value="startTime") String start, @ApiParam(value="Date follow ISO8601 (YYYY-MM-DDThh:mm:ssTZD). Search for events *to* this date", required=false, defaultValue="Current server time + 1 week") @QueryParam(value="endTime") String end, @ApiParam(value="Search for this category only. If not specified, search event of any category", required=false) @QueryParam(value="category") String category, @ApiParam(value="The starting point when paging through a list of entities", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="The maximum number of results when paging through a list of entities. If not specified or exceed the *query_limit* configuration of calendar rest service, it will use the *query_limit*", required=false) @QueryParam(value="limit") int limit, @ApiParam(value="This is a list of comma separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @ApiParam(value="Used to ask for a full representation of a subresource, instead of only its link", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Tells the service if it must return the total size of the returned collection result, and the *link* http headers", required=false, defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Context UriInfo uri) throws Exception {
        List<Calendar> calendarList;
        limit = this.parseLimit(limit);
        String username = this.currentUserId();
        this.query = new org.exoplatform.calendar.model.query.EventQuery();
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        java.util.Calendar[] dates = this.parseDate(start, end);
        CalendarSetting setting = service.getCalendarSetting(username);
        LinkedHashMap<String, Map> recurrenceEventsMap = new LinkedHashMap<String, Map>();
        long fullSize = returnSize ? 0L : -1L;
        LinkedList<Object> data = new LinkedList<Object>();
        LinkedList calIds = new LinkedList();
        LinkedList<Object> allEvents = new LinkedList<Object>();
        LinkedList<Object> tmp = new LinkedList<Object>();
        try {
            calendarList = this.getCalendarsOfUser(service, username);
        }
        catch (Exception e) {
            log.error((Object)("Cannot find calendars of user " + username), (Throwable)e);
            return Response.status((int)404).cacheControl(nc).build();
        }
        if (StringUtils.isNotBlank((String)category)) {
            this.query.setCategoryIds(new String[]{category});
        }
        calendarList.stream().forEach(c -> calIds.add(c.getId()));
        this.query.setCalendarIds(calIds.toArray(new String[calIds.size()]));
        this.query.setFromDate(Long.valueOf(dates[0].getTimeInMillis()));
        this.query.setToDate(Long.valueOf(dates[1].getTimeInMillis()));
        this.query.setEventType(CalendarEvent.TYPE_EVENT);
        this.query.setOwner(username);
        ListAccess list = this.eventHandler.findEventsByQuery(this.query);
        tmp.addAll(Arrays.asList(list.load(0, -1)));
        for (Event event : tmp) {
            if (event.getRepeatType() != null && !event.getRepeatType().equals(Event.RP_NOREPEAT)) {
                Map tempMap;
                CalendarEvent depEvt = CalendarEvent.build((Event)event);
                java.util.Calendar fromDate = CalendarUtils.getCalendarInstanceBySetting((CalendarSetting)setting);
                if (dates[0] != null) {
                    fromDate.setTimeInMillis(dates[0].getTimeInMillis());
                } else {
                    fromDate.setTime(event.getFromDateTime());
                }
                java.util.Calendar toDate = (java.util.Calendar)fromDate.clone();
                if (dates[1] != null) {
                    toDate.setTimeInMillis(dates[1].getTimeInMillis());
                } else {
                    toDate.add(1, 2);
                }
                if ((tempMap = service.getOccurrenceEvents(depEvt, fromDate, toDate, setting.getTimeZone())) == null) continue;
                recurrenceEventsMap.put(depEvt.getId(), tempMap);
                continue;
            }
            allEvents.add(event);
        }
        for (Map map : recurrenceEventsMap.values()) {
            allEvents.addAll(map.values());
        }
        for (int i = 0; i < allEvents.size(); ++i) {
            data.add(this.buildEventResource((CalendarEvent)allEvents.get(i), uri, expand, fields));
        }
        if (returnSize) {
            fullSize = list.getSize();
        }
        CollectionResource evData = new CollectionResource(data, fullSize);
        evData.setOffset(offset);
        evData.setLimit(limit);
        Response.ResponseBuilder responseBuilder = this.buildJsonP(evData, jsonp);
        if (returnSize) {
            responseBuilder.header(HEADER_LINK, (Object)this.buildFullUrl(uri, offset, limit, fullSize));
        }
        return responseBuilder.build();
    }

    private List<Calendar> getCalendarsOfUser(CalendarService service, String username) throws Exception {
        ArrayList<Calendar> list = new ArrayList<Calendar>();
        List listgroupCalendar = service.getGroupCalendars(this.getUserGroups(username), true, username);
        for (GroupCalendarData group : listgroupCalendar) {
            Optional.ofNullable(group.getCalendars()).ifPresent(list::addAll);
        }
        Optional.ofNullable(service.getUserCalendars(username, true)).ifPresent(list::addAll);
        return list;
    }

    private String[] getUserGroups(String username) throws Exception {
        Object[] objs = this.orgService.getGroupHandler().findGroupsOfUser(username).toArray();
        String[] groupsList = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            groupsList[i] = ((Group)objs[i]).getId();
        }
        return groupsList;
    }

    @POST
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}/events")
    @ApiOperation(value="Creates an event in a Calendar identified by its ID", notes="Creates an event in a calendar with specified id only if:<br/>- the authenticated user is the owner of the calendar<br/>- for group calendars, the authenticated user has edit rights on the calendar<br/>- the calendar has been shared with the authenticated user, with modification rights<br/>- the calendar has been shared with a group of the authenticated user, with modification rights")
    @ApiResponses(value={@ApiResponse(code=201, message="Event successfully created in the Calendar"), @ApiResponse(code=400, message="Bad Request: Provided attributes are not valid (not following the rules of evObject)"), @ApiResponse(code=401, message="User unauthorized to create an event in this calendar"), @ApiResponse(code=404, message="Calendar with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response createEventForCalendar(@ApiParam(value="Identity of the calendar where the event is created", required=true) @PathParam(value="id") String id, EventResource evObject, @Context UriInfo uriInfo) {
        try {
            Response error;
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(id);
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            CalendarEvent newEvent = new CalendarEvent();
            if (evObject.getSubject() == null) {
                evObject.setSubject(DEFAULT_EVENT_NAME);
            }
            if (evObject.getCategoryId() == null) {
                evObject.setCategoryId("defaultEventCategoryIdAll");
            }
            if ((error = this.buildEvent(newEvent, evObject, null)) != null) {
                return error;
            }
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                int calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), id);
                newEvent.setCalendarId(id);
                this.saveEvent(calType, newEvent, true);
                String username = ConversationState.getCurrent().getIdentity().getUserId();
                MailNotification mail = new MailNotification(this.mailService, this.orgService, CalendarRestApi.calendarServiceInstance());
                mail.sendEmail(newEvent, username);
                String location = this.getBasePath(uriInfo) + EVENT_URI + newEvent.getId();
                return Response.status((int)201).header(HEADER_LOCATION, (Object)location).cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}/occurrences")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns occurrences of a recurring event identified by its ID", notes="Returns occurrences of a recurring event with specified id when :<br/>- the calendar of the event is public<br/>- the authenticated user is the owner of the calendar of the event<br/>- the authenticated user belongs to the group of the calendar of the event<br/>- the authenticated user is a participant of the event<br/>- the calendar of the event has been shared with the authenticated user or with a group of the authenticated user")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of all occurrences of the event"), @ApiResponse(code=404, message="Event with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response getOccurrencesFromEvent(@ApiParam(value="Identity of the recurrent event", required=true) @PathParam(value="id") String id, @ApiParam(value="The starting point when paging through a list of entities", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="The maximum number of results when paging through a list of entities, and do not exceed *hardLimit*. If not specified, *defaultLimit* will be used", required=false) @QueryParam(value="limit") int limit, @ApiParam(value="Date follow ISO8601 (YYYY-MM-DDThh:mm:ssTZD). Search for events *from* this date.", required=false, defaultValue="current server time") @QueryParam(value="start") String start, @ApiParam(value="Date follow ISO8601 (YYYY-MM-DDThh:mm:ssTZD). Search for events *to* this date.", required=false, defaultValue="current server time + 1 week") @QueryParam(value="end") String end, @ApiParam(value="This is a list of comma separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @ApiParam(value="Used to ask for a full representation of a subresource, instead of only its link. This is a list of comma-separated property's names", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Tells the service if it must return the total size of the returned collection result, and the *link* http headers", required=false, defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Context UriInfo uriInfo) {
        try {
            limit = this.parseLimit(limit);
            java.util.Calendar[] dates = this.parseDate(start, end);
            CalendarEvent recurEvent = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (recurEvent == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            TimeZone tz = java.util.Calendar.getInstance().getTimeZone();
            String timeZone = tz.getID();
            Map occMap = CalendarRestApi.calendarServiceInstance().getOccurrenceEvents(recurEvent, dates[0], dates[1], timeZone);
            if (occMap == null || occMap.isEmpty()) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(recurEvent.getCalendarId());
            boolean inParticipant = false;
            if (recurEvent.getParticipant() != null) {
                Object[] participant = recurEvent.getParticipant();
                Arrays.sort(participant);
                int i = Arrays.binarySearch(participant, this.currentUserId());
                if (i > -1) {
                    inParticipant = true;
                }
            }
            if (cal.getPublicUrl() != null || this.hasViewCalendarPermission(cal, this.currentUserId()) || inParticipant) {
                ArrayList<Object> data = new ArrayList<Object>();
                Iterator evIter = occMap.values().iterator();
                Utils.skip(evIter, (long)offset);
                int counter = 0;
                while (evIter.hasNext()) {
                    data.add(this.buildEventResource((CalendarEvent)evIter.next(), uriInfo, expand, fields));
                    if (++counter != limit) continue;
                }
                int fullSize = returnSize ? occMap.values().size() : -1;
                CollectionResource evData = new CollectionResource(data, fullSize);
                evData.setOffset(offset);
                evData.setLimit(limit);
                Response.ResponseBuilder response = this.buildJsonP(evData, jsonp);
                if (returnSize) {
                    response.header(HEADER_LINK, (Object)this.buildFullUrl(uriInfo, offset, limit, evData.getSize()));
                }
                return response.build();
            }
            return Response.status((int)404).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}/tasks")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns tasks of a calendar identified by its ID", notes="Returns tasks of a calendar with specified id when:<br/>- the calendar is public<br/>- the authenticated user is the owner of the calendar of the task<br/>- the authenticated user belongs to the group of the calendar of the task<br/>- the authenticated user is delegated by the task<br/>- the calendar of the task has been shared with the authenticated user or with a group of the authenticated user")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of all tasks from the calendar"), @ApiResponse(code=404, message="Calendar with provided ID Not Found")})
    public Response getTasksByCalendar(@ApiParam(value="Identity of a calendar to search for tasks", required=true) @PathParam(value="id") String id, @ApiParam(value="Date follow ISO8601 (YYYY-MM-DDThh:mm:ssTZD). Search for events *from* this date.", required=false, defaultValue="current server time") @QueryParam(value="startTime") String start, @ApiParam(value="Date follow ISO8601 (YYYY-MM-DDThh:mm:ssTZD). Search for events *to* this date.", required=false, defaultValue="current server time + 1 week") @QueryParam(value="endTime") String end, @ApiParam(value="Search for this category only", required=false, defaultValue="If not specified, search task of any category") @QueryParam(value="category") String category, @ApiParam(value="The starting point when paging through a list of entities", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="The maximum number of results when paging through a list of entities, and do not exceed *hardLimit*. If not specified, *defaultLimit* will be used", required=false) @QueryParam(value="limit") int limit, @ApiParam(value="This is a list of comma separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @ApiParam(value="used to ask for a full representation of a subresource, instead of only its link", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Tells the service if it must return the total size of the returned collection result, and the *link* http headers", required=false, defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Context UriInfo uri) throws Exception {
        limit = this.parseLimit(limit);
        String username = this.currentUserId();
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        EventDAO evtDAO = service.getEventDAO();
        long fullSize = returnSize ? 0L : -1L;
        LinkedList<Object> data = new LinkedList<Object>();
        Calendar calendar = service.getCalendarById(id);
        if (calendar != null) {
            String participant = null;
            if (calendar.getPublicUrl() == null && !this.hasViewCalendarPermission(calendar, username)) {
                participant = username;
            }
            EventQuery eventQuery = this.buildEventQuery(start, end, category, Arrays.asList(calendar), id, participant, CalendarEvent.TYPE_TASK);
            ListAccess events = evtDAO.findEventsByQuery(eventQuery);
            for (CalendarEvent event : (CalendarEvent[])events.load(offset, limit)) {
                data.add(this.buildTaskResource(event, uri, expand, fields));
            }
            if (returnSize) {
                fullSize = events.getSize();
            }
        } else {
            return Response.status((int)404).cacheControl(nc).build();
        }
        CollectionResource evData = new CollectionResource(data, fullSize);
        evData.setOffset(offset);
        evData.setLimit(limit);
        Response.ResponseBuilder response = this.buildJsonP(evData, jsonp);
        if (returnSize) {
            response.header(HEADER_LINK, (Object)this.buildFullUrl(uri, offset, limit, fullSize));
        }
        return response.build();
    }

    @POST
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}/tasks")
    @ApiOperation(value="Creates a task for a calendar identified by its ID", notes="Creates a task for a calendar with specified id only if:<br/>- the authenticated user is the owner of the calendar<br/>- for group calendars, the authenticated user has edit rights on the calendar<br/>- the calendar has been shared with the authenticated user, with modification rights<br/>- the calendar has been shared with a group of the authenticated user, with modification rights<br/>")
    @ApiResponses(value={@ApiResponse(code=201, message="Task successfully created"), @ApiResponse(code=400, message="Bad Request: Provided attributes are not valid (not following the rules of evObject)"), @ApiResponse(code=401, message="User unauthorized to create a task for this calendar"), @ApiResponse(code=404, message="Calendar with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during saving process")})
    public Response createTaskForCalendar(@ApiParam(value="Identity of the calendar where the task is created", required=true) @PathParam(value="id") String id, TaskResource evObject, @Context UriInfo uriInfo) {
        try {
            Response error;
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(id);
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            CalendarEvent newEvent = new CalendarEvent();
            newEvent.setEventType(CalendarEvent.TYPE_TASK);
            if (evObject.getName() == null) {
                evObject.setName(DEFAULT_EVENT_NAME);
            }
            if (evObject.getCategoryId() == null) {
                evObject.setCategoryId("defaultEventCategoryIdAll");
            }
            if ((error = this.buildEventFromTask(newEvent, evObject)) != null) {
                return error;
            }
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                int calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), id);
                newEvent.setCalendarId(id);
                this.saveEvent(calType, newEvent, true);
                String location = this.getBasePath(uriInfo) + TASK_URI + newEvent.getId();
                return Response.status((int)201).header(HEADER_LOCATION, (Object)location).cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/tasks/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns a task identified by its ID", notes="Returns a task with specified id if:<br/>- the calendar of the task is public<br/>- the authenticated user is the owner of the calendar of the task<br/>- the authenticated user belongs to the group of the calendar of the task<br/>- the authenticated user is a participant of the task<br/>- the calendar of the task has been shared with the authenticated user or with a group of the authenticated user")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of the task"), @ApiResponse(code=404, message="Task with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response getTaskById(@ApiParam(value="Identity of the task to find", required=true) @PathParam(value="id") String id, @ApiParam(value="This is a list of comma separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="Used to ask for a full representation of a subresource, instead of only its link. This is a list of comma-separated property's names", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo, @Context Request request) {
        try {
            CalendarEvent ev = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (ev == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Date lastModified = new Date(ev.getLastModified());
            Response.ResponseBuilder preCondition = request.evaluatePreconditions(lastModified);
            if (preCondition != null) {
                return preCondition.build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(ev.getCalendarId());
            boolean inParticipant = false;
            if (ev.getParticipant() != null) {
                Object[] participant = ev.getParticipant();
                Arrays.sort(participant);
                if (Arrays.binarySearch(participant, this.currentUserId()) > -1) {
                    inParticipant = true;
                }
            }
            if (cal.getPublicUrl() != null || this.hasViewCalendarPermission(cal, this.currentUserId()) || inParticipant) {
                Object resource = this.buildTaskResource(ev, uriInfo, expand, fields);
                return this.buildJsonP(resource, jsonp).cacheControl(this.cc).lastModified(lastModified).build();
            }
            return Response.status((int)404).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @PUT
    @RolesAllowed(value={"users"})
    @Path(value="/tasks/{id}")
    @ApiOperation(value="Updates a task identified by its ID", notes="Updates a task with the specified id if:<br/>- the authenticated user is the owner of the calendar of the event<br/>- for group calendars, the authenticated user has edit rights on the calendar<br/>- the calendar of the event has been shared with the authenticated user, with modification rights<br/>- the calendar of the event has been shared with a group of the authenticated user, with modification rights")
    @ApiResponses(value={@ApiResponse(code=200, message="Task successfully updated"), @ApiResponse(code=400, message="Bad Request: Provided attributes are not valid (not following the rules of evObject)"), @ApiResponse(code=401, message="User unauthorized to update this task"), @ApiResponse(code=404, message="Task with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response updateTaskById(@ApiParam(value="Identity of the task to update", required=true) @PathParam(value="id") String id, TaskResource evObject) {
        try {
            CalendarEvent event = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (event == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(event.getCalendarId());
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                int calType = -1;
                try {
                    calType = Integer.parseInt(event.getCalType());
                }
                catch (NumberFormatException e) {
                    calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), event.getCalendarId());
                }
                this.buildEventFromTask(event, evObject);
                this.saveEvent(calType, event, false);
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/tasks/{id}")
    @ApiOperation(value="Deletes a task identified by its ID", notes="Deletes a task with specified id if:<br/>- the authenticated user is the owner of the calendar of the event<br/>- for group calendars, the authenticated user has edit rights on the calendar<br/>- the calendar of the event has been shared with the authenticated user, with modification rights<br/>- the calendar of the event has been shared with a group of the authenticated user, with modification rights")
    @ApiResponses(value={@ApiResponse(code=200, message="Task successfully deleted"), @ApiResponse(code=401, message="User unauthorized to delete this task"), @ApiResponse(code=404, message="Task with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response deleteTaskById(@ApiParam(value="Identity of the task to delete", required=true) @PathParam(value="id") String id) {
        try {
            CalendarEvent ev = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (ev == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(ev.getCalendarId());
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                int calType = -1;
                try {
                    calType = Integer.parseInt(ev.getCalType());
                }
                catch (NumberFormatException e) {
                    calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), ev.getCalendarId());
                }
                switch (calType) {
                    case 0: {
                        CalendarRestApi.calendarServiceInstance().removeUserEvent(this.currentUserId(), ev.getCalendarId(), id);
                        break;
                    }
                    case 2: {
                        CalendarRestApi.calendarServiceInstance().removePublicEvent(ev.getCalendarId(), id);
                        break;
                    }
                    case 1: {
                        CalendarRestApi.calendarServiceInstance().removeSharedEvent(this.currentUserId(), ev.getCalendarId(), id);
                        break;
                    }
                }
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/attachments/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns an attachment identified by its ID", notes="Returns an attachment with specified id if:<br/>- the calendar of the event is public<br/>- the authenticated user is the owner of the calendar of the event<br/>- the authenticated user belongs to the group of the calendar of the event<br/>- the authenticated user is a participant of the event<br/>- the calendar of the event has been shared with the authenticated user or with a group of the authenticated user")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of the attachment"), @ApiResponse(code=404, message="Attachment with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response getAttachmentById(@ApiParam(value="Identity of the attachment to find", required=true) @PathParam(value="id") String id, @ApiParam(value="This is a list of comma separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo, @Context Request request) {
        try {
            id = AttachmentResource.decode(id);
            CalendarEvent ev = this.findEventAttachment(id);
            if (ev == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(ev.getCalendarId());
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Attachment att = CalendarRestApi.calendarServiceInstance().getAttachmentById(id);
            if (att == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Date lastModified = new Date(att.getLastModified());
            Response.ResponseBuilder preCondition = request.evaluatePreconditions(lastModified);
            if (preCondition != null) {
                return preCondition.build();
            }
            boolean inParticipant = false;
            if (ev.getParticipant() != null) {
                Object[] participant = ev.getParticipant();
                Arrays.sort(participant);
                int i = Arrays.binarySearch(participant, this.currentUserId());
                if (i > -1) {
                    inParticipant = true;
                }
            }
            if (cal.getPublicUrl() != null || this.hasViewCalendarPermission(cal, this.currentUserId()) || inParticipant) {
                AttachmentResource evData = new AttachmentResource(att, this.getBasePath(uriInfo));
                Object resource = this.extractObject(evData, fields);
                if (jsonp != null) {
                    String json = null;
                    if (resource instanceof Map) {
                        json = new JSONObject(resource).toString();
                    } else {
                        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                        json = generatorImpl.createJsonObject(resource).toString();
                    }
                    StringBuilder sb = new StringBuilder(jsonp);
                    sb.append("(").append(json).append(");");
                    return Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript")).cacheControl(this.cc).lastModified(lastModified).build();
                }
                return Response.ok((Object)resource, (String)"application/json").cacheControl(this.cc).lastModified(lastModified).build();
            }
            return Response.status((int)404).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/attachments/{id}")
    @ApiOperation(value="Deletes an attachment identified by its ID", notes="Deletes an attachment with specified id if:<br/>- the authenticated user is the owner of the calendar of the event<br/>- for group calendars, the authenticated user has edit rights on the calendar<br/>- the calendar of the event has been shared with the authenticated user, with modification rights<br/>- the calendar of the event has been shared with a group of the authenticated user, with modification rights")
    @ApiResponses(value={@ApiResponse(code=200, message="Attachment successfully deleted"), @ApiResponse(code=401, message="User unauthorized to delete this attachment"), @ApiResponse(code=404, message="Attachment with provided ID Not Found"), @ApiResponse(code=503, message="An error occured during the saving process")})
    public Response deleteAttachmentById(@ApiParam(value="Identity of the attachment to delete", required=true) @PathParam(value="id") String id) {
        try {
            id = AttachmentResource.decode(id);
            CalendarEvent ev = this.findEventAttachment(id);
            if (ev == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(ev.getCalendarId());
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                CalendarRestApi.calendarServiceInstance().removeAttachmentById(id);
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/categories")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns the categories accessible to the user", notes="Returns the categories if a user is authenticated (the common categories + the personal categories)")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of all event categories"), @ApiResponse(code=404, message="No categories Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response getEventCategories(@ApiParam(value="The starting point when paging through a list of entities", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="The maximum number of results when paging through a list of entities, and do not exceed *hardLimit*. If not specified, *defaultLimit* will be used", required=false) @QueryParam(value="limit") int limit, @ApiParam(value="This is a list of comma separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo) {
        limit = this.parseLimit(limit);
        try {
            CalendarCollection ecData = CalendarRestApi.calendarServiceInstance().getEventCategories(this.currentUserId(), offset, limit);
            if (ecData == null || ecData.isEmpty()) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            ArrayList<Object> data = new ArrayList<Object>();
            String basePath = this.getBasePath(uriInfo);
            for (EventCategory ec : ecData) {
                data.add(this.extractObject(new CategoryResource(ec, basePath), fields));
            }
            CollectionResource resource = new CollectionResource(data, ecData.size());
            resource.setOffset(offset);
            resource.setLimit(limit);
            if (jsonp != null) {
                JsonValue json = new JsonGeneratorImpl().createJsonObject(resource);
                StringBuilder sb = new StringBuilder(jsonp);
                sb.append("(").append(json).append(");");
                return Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript")).header(HEADER_LINK, (Object)this.buildFullUrl(uriInfo, offset, limit, resource.getSize())).cacheControl(nc).build();
            }
            return Response.ok(resource, (String)"application/json").header(HEADER_LINK, (Object)this.buildFullUrl(uriInfo, offset, limit, resource.getSize())).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/categories/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns an event category identified by its ID", notes="Returns the event category by id if it belongs to the user")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of the event category"), @ApiResponse(code=404, message="Event category with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response getEventCategoryById(@ApiParam(value="Identity of the event category to find", required=true) @PathParam(value="id") String id, @ApiParam(value="This is a list of comma separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo, @Context Request request) {
        try {
            List data = CalendarRestApi.calendarServiceInstance().getEventCategories(this.currentUserId());
            if (data == null || data.isEmpty()) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            EventCategory category = null;
            for (int i = 0; i < data.size(); ++i) {
                if (!id.equals(((EventCategory)data.get(i)).getId())) continue;
                category = (EventCategory)data.get(i);
                break;
            }
            if (category == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Date lastModified = new Date(category.getLastModified());
            Response.ResponseBuilder preCondition = request.evaluatePreconditions(lastModified);
            if (preCondition != null) {
                return preCondition.build();
            }
            CategoryResource categoryR = new CategoryResource(category, this.getBasePath(uriInfo));
            Object resource = this.extractObject(categoryR, fields);
            if (jsonp != null) {
                String json = null;
                if (resource instanceof Map) {
                    json = new JSONObject((Map)resource).toString();
                } else {
                    JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                    json = generatorImpl.createJsonObject(resource).toString();
                }
                StringBuilder sb = new StringBuilder(jsonp);
                sb.append("(").append(json).append(");");
                return Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript")).cacheControl(this.cc).lastModified(lastModified).build();
            }
            return Response.ok((Object)resource, (String)"application/json").cacheControl(this.cc).lastModified(lastModified).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/feeds/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns a feed identified by its ID", notes="Returns the feed with the given ID if the authenticated user is the owner of the feed")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of the feed"), @ApiResponse(code=404, message="Feed with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response getFeedById(@ApiParam(value="Title of the feed to find", required=true) @PathParam(value="id") String id, @ApiParam(value="This is a list of comma separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="Used to ask for a full representation of a subresource, instead of only its link. This is a list of comma-separated property's names", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo, @Context Request request) {
        try {
            FeedData feed = null;
            for (FeedData feedData : CalendarRestApi.calendarServiceInstance().getFeeds(this.currentUserId())) {
                if (!feedData.getTitle().equals(id)) continue;
                feed = feedData;
                break;
            }
            if (feed == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            byte[] data = feed.getContent();
            byte[] hashCode = this.digest(data).getBytes();
            EntityTag tag = new EntityTag(new String(hashCode));
            Response.ResponseBuilder preCondition = request.evaluatePreconditions(tag);
            if (preCondition != null) {
                return preCondition.build();
            }
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed syndFeed = input.build((Reader)new XmlReader((InputStream)new ByteArrayInputStream(data)));
            ArrayList entries = new ArrayList(syndFeed.getEntries());
            ArrayList<String> calIds = new ArrayList<String>();
            for (SyndEntry entry : entries) {
                String calendarId = entry.getLink().substring(entry.getLink().lastIndexOf("/") + 1);
                calIds.add(calendarId);
            }
            Object resource = this.buildFeedResource(feed, calIds, uriInfo, expand, fields);
            return this.buildJsonP(resource, jsonp).cacheControl(this.cc).tag(tag).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @PUT
    @RolesAllowed(value={"users"})
    @Path(value="/feeds/{id}")
    @ApiOperation(value="Updates a feed identified by its ID", notes="Updates the feed with the given ID if the authenticated user is the owner of the feed")
    @ApiResponses(value={@ApiResponse(code=200, message="Feed successfully updated"), @ApiResponse(code=404, message="Feed with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response updateFeedById(@ApiParam(value="Title of the feed to update", required=true) @PathParam(value="id") String id, FeedResource feedResource) {
        try {
            String[] feed = null;
            for (String[] feedData : CalendarRestApi.calendarServiceInstance().getFeeds(this.currentUserId())) {
                if (!feedData.getTitle().equals(id)) continue;
                feed = feedData;
                break;
            }
            if (feed == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            LinkedHashMap<String, Calendar> calendars = new LinkedHashMap<String, Calendar>();
            if (feedResource.getCalendarIds() != null) {
                block8: for (String calendarId : feedResource.getCalendarIds()) {
                    Calendar calendar = CalendarRestApi.calendarServiceInstance().getCalendarById(calendarId);
                    int calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), calendarId);
                    switch (calType) {
                        case 0: {
                            calendars.put("0:" + calendarId, calendar);
                            continue block8;
                        }
                        case 2: {
                            calendars.put("2:" + calendarId, calendar);
                            continue block8;
                        }
                        case 1: {
                            calendars.put("1:" + calendarId, calendar);
                            continue block8;
                        }
                    }
                }
            }
            CalendarRestApi.calendarServiceInstance().removeFeedData(this.currentUserId(), id);
            RssData rssData = new RssData();
            if (feedResource.getName() != null) {
                rssData.setName(feedResource.getName() + ".rss");
                rssData.setTitle(feedResource.getName());
                rssData.setDescription(feedResource.getName());
            }
            rssData.setUrl(feed.getUrl());
            rssData.setLink(feed.getUrl());
            rssData.setVersion("rss_2.0");
            CalendarRestApi.calendarServiceInstance().generateRss(this.currentUserId(), calendars, rssData);
            return Response.ok().cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/feeds/{id}")
    @ApiOperation(value="Deletes a feed identified by its ID", notes="Deletes the feed with the given ID if the authenticated user is the owner of the feed")
    @ApiResponses(value={@ApiResponse(code=200, message="Feed successfully deleted"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response deleteFeedById(@ApiParam(value="Title of the feed to delete", required=true) @PathParam(value="id") String id) {
        try {
            CalendarRestApi.calendarServiceInstance().removeFeedData(this.currentUserId(), id);
            return Response.ok().cacheControl(nc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/feeds/{id}/rss")
    @Produces(value={"application/xml"})
    @ApiOperation(value="Gets the RSS stream of the feed with the given ID", notes="Returns the RSS stream if:<br/>- the calendar is public<br/>- the authenticated user is the owner of the calendar<br/>- the authenticated user belongs to the group of the calendar<br/>- the calendar has been shared with the authenticated user or with a group of the authenticated user")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of RSS stream from the feed"), @ApiResponse(code=404, message="Feed with provided ID Not Found"), @ApiResponse(code=503, message="An error occurrred during the saving process")})
    public Response getRssFromFeed(@ApiParam(value="Title of the feed", required=true) @PathParam(value="id") String id, @Context UriInfo uri, @Context Request request) {
        try {
            String username = this.currentUserId();
            String feedname = id;
            FeedData feed = null;
            for (FeedData feedData : CalendarRestApi.calendarServiceInstance().getFeeds(username)) {
                if (!feedData.getTitle().equals(feedname)) continue;
                feed = feedData;
                break;
            }
            if (feed == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed syndFeed = input.build((Reader)new XmlReader((InputStream)new ByteArrayInputStream(feed.getContent())));
            ArrayList entries = new ArrayList(syndFeed.getEntries());
            ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
            ArrayList<Calendar> calendars = new ArrayList<Calendar>();
            for (SyndEntry entry : entries) {
                String calendarId = entry.getLink().substring(entry.getLink().lastIndexOf("/") + 1);
                calendars.add(CalendarRestApi.calendarServiceInstance().getCalendarById(calendarId));
            }
            for (Calendar cal : calendars) {
                if (cal.getPublicUrl() == null && !this.hasViewCalendarPermission(cal, username)) continue;
                int calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(username, cal.getId());
                switch (calType) {
                    case 0: {
                        events.addAll(CalendarRestApi.calendarServiceInstance().getUserEventByCalendar(username, Arrays.asList(cal.getId())));
                        break;
                    }
                    case 1: {
                        events.addAll(CalendarRestApi.calendarServiceInstance().getSharedEventByCalendars(username, Arrays.asList(cal.getId())));
                        break;
                    }
                    case 2: {
                        EventQuery eventQuery = new EventQuery();
                        eventQuery.setCalendarId(new String[]{cal.getId()});
                        events.addAll(CalendarRestApi.calendarServiceInstance().getPublicEvents(eventQuery));
                        break;
                    }
                }
            }
            if (events.size() == 0) {
                return Response.status((int)404).entity((Object)("Feed " + feedname + "is removed")).cacheControl(nc).build();
            }
            String xml = this.makeFeed(username, events, feed, uri);
            byte[] hashCode = this.digest(xml.getBytes()).getBytes();
            EntityTag tag = new EntityTag(new String(hashCode));
            Response.ResponseBuilder preCondition = request.evaluatePreconditions(tag);
            if (preCondition != null) {
                return preCondition.build();
            }
            return Response.ok((Object)xml, (String)"application/xml").cacheControl(this.cc).tag(tag).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/invitations/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns an invitation identified by its ID", notes="Returns an invitation with specified id if:<br/>- the authenticated user is the participant of the invitation<br/>- the authenticated user has edit rights on the calendar of the event of the invitation")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of the invitation"), @ApiResponse(code=404, message="Invitation with provided ID Not Found")})
    public Response getInvitationById(@ApiParam(value="Identity of the invitation to find", required=true) @PathParam(value="id") String id, @ApiParam(value="This is a list of comma separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @ApiParam(value="Used to ask for a full representation of a subresource, instead of only its link. This is a list of comma-separated property's names", required=false) @QueryParam(value="expand") String expand, @Context UriInfo uriInfo, @Context Request request) throws Exception {
        CalendarEvent event;
        Calendar calendar;
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        EventDAO evtDAO = service.getEventDAO();
        String username = this.currentUserId();
        Invitation invitation = evtDAO.getInvitationById(id);
        if (invitation == null) {
            return Response.status((int)404).cacheControl(nc).build();
        }
        EntityTag tag = new EntityTag(String.valueOf(invitation.hashCode()));
        Response.ResponseBuilder preCondition = request.evaluatePreconditions(tag);
        if (preCondition != null) {
            return preCondition.build();
        }
        if (!username.equals(invitation.getParticipant()) && !Utils.isCalendarEditable((String)username, (Calendar)(calendar = service.getCalendarById((event = service.getEventById(invitation.getEventId())).getCalendarId())))) {
            return Response.status((int)404).cacheControl(nc).build();
        }
        Object resource = this.buildInvitationResource(invitation, uriInfo, expand, fields);
        return this.buildJsonP(resource, jsonp).cacheControl(this.cc).tag(tag).build();
    }

    @PUT
    @RolesAllowed(value={"users"})
    @Path(value="/invitations/{id}")
    @ApiOperation(value="Updates an invitation identified by its ID", notes="Update the invitation if the authenticated user is the participant of the invitation.<br/>This entry point only allow http PUT request, with id of invitation in the path, and the status")
    @ApiResponses(value={@ApiResponse(code=200, message="Invitation successfully updated"), @ApiResponse(code=400, message="Bad Request: Status invalid"), @ApiResponse(code=401, message="User unauthorized to update the invitation"), @ApiResponse(code=404, message="Invitation with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response updateInvitationById(@ApiParam(value="Identity of the invitation to update", required=true) @PathParam(value="id") String id, @ApiParam(value="New status to update", allowableValues="['', 'maybe', 'yes', 'no']", required=true) @QueryParam(value="status") String status) {
        if (Arrays.binarySearch(INVITATION_STATUS, status) < 0) {
            return this.buildBadResponse(new ErrorResource("status must be one of: " + StringUtils.join((Object[])INVITATION_STATUS, (String)","), "status"));
        }
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        EventDAO evtDAO = service.getEventDAO();
        String username = this.currentUserId();
        Invitation invitation = evtDAO.getInvitationById(id);
        if (invitation != null) {
            if (invitation.getParticipant().equals(username)) {
                evtDAO.updateInvitation(id, status);
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        return Response.status((int)404).cacheControl(nc).build();
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/invitations/{id}")
    @ApiOperation(value="Deletes an invitation identified by its ID", notes="Deletes an invitation with specified id if the authenticated user has edit rights on the calendar of the event of the invitation")
    @ApiResponses(value={@ApiResponse(code=200, message="Invitation deleted successfully"), @ApiResponse(code=401, message="User unauthorized to delete this invitation"), @ApiResponse(code=404, message="Invitation with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response deleteInvitationById(@ApiParam(value="Identity of the invitation to delete", required=true) @PathParam(value="id") String id) throws Exception {
        CalendarService calService = CalendarRestApi.calendarServiceInstance();
        EventDAO evtDAO = calService.getEventDAO();
        String username = this.currentUserId();
        Invitation invitation = evtDAO.getInvitationById(id);
        if (invitation == null) {
            return Response.status((int)404).cacheControl(nc).build();
        }
        CalendarEvent event = calService.getEventById(invitation.getEventId());
        Calendar calendar = calService.getCalendarById(event.getCalendarId());
        if (Utils.isCalendarEditable((String)username, (Calendar)calendar)) {
            evtDAO.removeInvitation(id);
            return Response.ok().cacheControl(nc).build();
        }
        return Response.status((int)401).cacheControl(nc).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}/invitations/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns the invitations of an event identified by its ID", notes="Returns invitations of an event with specified id when:<br/>- the authenticated user is the participant of the invitation<br/>- the authenticated user has edit rights on the calendar of the event of the invitation")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of all invitations from the event"), @ApiResponse(code=404, message="Event with provided ID Not Found")})
    public Response getInvitationsFromEvent(@ApiParam(value="Identity of the event to search for invitations", required=true) @PathParam(value="id") String id, @ApiParam(value="The starting point when paging through a list of entities", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="The maximum number of results when paging through a list of entities, and do not exceed *hardLimit*. If not specified, *defaultLimit* will be used", required=false) @QueryParam(value="limit") int limit, @ApiParam(value="Tells the service if it must return the total size of the returned collection result, and the *link* http headers", required=false, defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="search for this status only", required=false, defaultValue="If not specified, search invitation of any status ('', 'maybe', 'yes', 'no')") @QueryParam(value="status") String status, @ApiParam(value="This is a list of comma separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @ApiParam(value="Used to ask for a full representation of a subresource, instead of only its link. This is a list of comma-separated property's names", required=false) @QueryParam(value="expand") String expand, @Context UriInfo uriInfo) throws Exception {
        limit = this.parseLimit(limit);
        CalendarService calService = CalendarRestApi.calendarServiceInstance();
        CalendarEvent event = calService.getEventById(id);
        String username = this.currentUserId();
        List invitations = Collections.emptyList();
        if (event != null) {
            Iterator<Object> iter;
            invitations = new LinkedList<Invitation>(Arrays.asList(event.getInvitations()));
            Calendar calendar = calService.getCalendarById(event.getCalendarId());
            if (!Utils.isCalendarEditable((String)username, (Calendar)calendar)) {
                iter = invitations.iterator();
                while (iter.hasNext()) {
                    if (((Invitation)iter.next()).getParticipant().equals(username)) continue;
                    iter.remove();
                }
            }
            if (status != null) {
                iter = invitations.iterator();
                while (iter.hasNext()) {
                    if (((Invitation)iter.next()).getStatus().equals(status)) continue;
                    iter.remove();
                }
            }
        }
        LinkedList<Object> data = new LinkedList<Object>();
        for (Invitation invitation : Utils.subList(invitations, (int)offset, (int)limit)) {
            data.add(this.buildInvitationResource(invitation, uriInfo, expand, fields));
        }
        int fullSize = invitations.size();
        CollectionResource ivData = new CollectionResource(data, returnSize ? (long)fullSize : -1L);
        ivData.setOffset(offset);
        ivData.setLimit(limit);
        Response.ResponseBuilder response = this.buildJsonP(ivData, jsonp);
        if (returnSize) {
            response.header(HEADER_LINK, (Object)this.buildFullUrl(uriInfo, offset, limit, fullSize));
        }
        return response.build();
    }

    @POST
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}/invitations/")
    @ApiOperation(value="Creates an invitation in the event with the given id", notes="Creates the invitation only if:<br/>- the authenticated user is the participant of the invitation<br/>- the authenticated user has edit rights on the calendar of the event of the invitation")
    @ApiResponses(value={@ApiResponse(code=201, message="Invitation created successfully"), @ApiResponse(code=400, message="Bad Request: invalid participant or status"), @ApiResponse(code=401, message="User unauthorized to create an invitation for this event"), @ApiResponse(code=404, message="Event with provided ID Not Found"), @ApiResponse(code=503, message="An error occurred during the saving process")})
    public Response createInvitationForEvent(@ApiParam(value="Identity of the event where the invitation is created", required=true) @PathParam(value="id") String id, InvitationResource invitation, @Context UriInfo uriInfo) throws Exception {
        if (invitation == null) {
            return this.buildBadResponse(new ErrorResource("Invitation information must not null", "invitation"));
        }
        String participant = invitation.getParticipant();
        String status = invitation.getStatus();
        if (participant == null || participant.trim().isEmpty()) {
            return this.buildBadResponse(new ErrorResource("participant must not null or empty", "participant"));
        }
        if (Arrays.binarySearch(INVITATION_STATUS, status) < 0) {
            return this.buildBadResponse(new ErrorResource("status must be one of: " + StringUtils.join((Object[])INVITATION_STATUS, (String)","), "status"));
        }
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        EventDAO evtDAO = service.getEventDAO();
        String username = this.currentUserId();
        CalendarEvent event = service.getEventById(id);
        if (event != null) {
            Calendar calendar = service.getCalendarById(event.getCalendarId());
            if (!Utils.isCalendarEditable((String)username, (Calendar)calendar)) {
                return Response.status((int)401).cacheControl(nc).build();
            }
            Invitation invite = evtDAO.createInvitation(id, participant, status);
            if (invite != null) {
                String location = this.getBasePath(uriInfo) + INVITATION_URI + invite.getId();
                return Response.status((int)201).header(HEADER_LOCATION, (Object)location).cacheControl(nc).build();
            }
            return this.buildBadResponse(new ErrorResource(participant + " has already been participant, can't create more", "participant"));
        }
        return Response.status((int)404).cacheControl(nc).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/participants/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns all suggested participants", notes="This method lists all the participants a specific user can invite in a calendar.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of all participants"), @ApiResponse(code=503, message="Can't generate JSON file")})
    public Response suggestParticipants(@ApiParam(value="The participant name to search for", required=false) @QueryParam(value="name") String name, @ApiParam(value="The starting point when paging through a list of entities", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="The maximum number of results when paging through a list of entities, and do not exceed *hardLimit*. If not specified, *defaultLimit* will be used", required=false) @QueryParam(value="limit") int limit, @ApiParam(value="Tell the service if it must return the total size of the returned collection result, and the *link* http headers", required=false, defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="This is a list of comma-separated property's names of response json object", required=false) @QueryParam(value="fields") String fields, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @Context UriInfo uri) {
        try {
            Response.ResponseBuilder okResult;
            limit = this.parseLimit(limit);
            name = name == null ? "" : name;
            ProfileFilter filter = new ProfileFilter();
            filter.setName(name);
            filter.setCompany("");
            filter.setPosition("");
            filter.setSkills("");
            filter.setExcludedIdentityList(Collections.emptyList());
            ListAccess list = this.identityManager.getIdentitiesByProfileFilter("organization", filter, true);
            LinkedList<Object> data = new LinkedList<Object>();
            if (list != null) {
                for (org.exoplatform.social.core.identity.model.Identity identity : (org.exoplatform.social.core.identity.model.Identity[])list.load(offset, limit)) {
                    data.add(this.extractObject(new ParticipantResource(identity), fields));
                }
            }
            CollectionResource parData = new CollectionResource(data, returnSize ? (long)list.getSize() : -1L);
            parData.setOffset(offset);
            parData.setLimit(limit);
            if (jsonp != null) {
                JsonValue value = new JsonGeneratorImpl().createJsonObject(parData);
                StringBuilder sb = new StringBuilder(jsonp);
                sb.append("(").append(value).append(");");
                okResult = Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript"));
            } else {
                okResult = Response.ok(parData, (String)"application/json");
            }
            if (returnSize) {
                okResult.header(HEADER_LINK, (Object)this.buildFullUrl(uri, offset, limit, parData.getSize()));
            }
            return okResult.cacheControl(nc).build();
        }
        catch (Exception e) {
            log.error((Object)"Can not suggest participant", (Throwable)e);
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/availabilities")
    @Produces(value={"application/json"})
    @ApiOperation(value="Return availability of users.", notes="(free/busy time)")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval"), @ApiResponse(code=503, message="Can't generate JSON file")})
    public Response getAvailabilities(@ApiParam(value="usernames to check availability", required=true) @QueryParam(value="usernames") String usernames, @ApiParam(value="usernames to check availability", required=true) @QueryParam(value="fromDate") Long fromDate, @ApiParam(value="usernames to check availability", required=true) @QueryParam(value="toDate") Long toDate, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @Context UriInfo uri) {
        try {
            Response.ResponseBuilder okResult;
            HashMap<String, String> parMap_ = new HashMap<String, String>();
            parMap_.clear();
            HashMap tmpMap = new HashMap();
            ArrayList<String> newPars = new ArrayList<String>();
            if (StringUtils.isNotBlank((String)usernames)) {
                for (String par : usernames.split(",")) {
                    if (this.orgService.getUserHandler().findUserByName(par) == null) continue;
                    String vl = (String)tmpMap.get(par);
                    parMap_.put(par.trim(), vl);
                    if (vl != null) continue;
                    newPars.add(par.trim());
                }
            }
            if (newPars.size() > 0) {
                EventQuery eventQuery = new EventQuery();
                CalendarSetting setting = CalendarRestApi.calendarServiceInstance().getCalendarSetting(this.currentUserId());
                TimeZone timeZone = DateUtils.getTimeZone((String)setting.getTimeZone());
                java.util.Calendar from = this.buildTimeFrom(fromDate, timeZone);
                eventQuery.setFromDate(from);
                java.util.Calendar to = this.buildTimeFrom(toDate, timeZone);
                eventQuery.setToDate(to);
                eventQuery.setParticipants(newPars.toArray(new String[0]));
                eventQuery.setNodeType("exo:calendarPublicEvent");
                Map parsMap = CalendarRestApi.calendarServiceInstance().checkFreeBusy(eventQuery);
                parMap_.putAll(parsMap);
            }
            if (jsonp != null) {
                JsonValue value = new JsonGeneratorImpl().createJsonObject(parMap_);
                StringBuilder sb = new StringBuilder(jsonp);
                sb.append("(").append(value).append(");");
                okResult = Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript"));
            } else {
                okResult = Response.ok(parMap_, (String)"application/json");
            }
            return okResult.cacheControl(nc).build();
        }
        catch (Exception e) {
            log.error((Object)"Can not check availability", (Throwable)e);
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    private java.util.Calendar buildTimeFrom(Long miliseconds, TimeZone timeZone) {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTimeZone(timeZone);
        cal.setTimeInMillis(miliseconds);
        return cal;
    }

    private Response buildBadResponse(ErrorResource error) {
        return Response.status((int)400).entity((Object)error).type("application/json").cacheControl(nc).build();
    }

    private java.util.Calendar[] parseDate(String start, String end) {
        java.util.Calendar from = GregorianCalendar.getInstance();
        java.util.Calendar to = GregorianCalendar.getInstance();
        if (Utils.isEmpty((String)start)) {
            from = java.util.Calendar.getInstance();
            from.set(10, 0);
            from.set(12, 0);
            from.set(13, 0);
            from.set(14, 0);
        } else {
            from = ISO8601.parse((String)start);
        }
        if (Utils.isEmpty((String)end)) {
            to.add(4, 1);
            to.set(10, 0);
            to.set(12, 0);
            to.set(13, 0);
            to.set(14, 0);
        } else {
            to = ISO8601.parse((String)end);
        }
        return new java.util.Calendar[]{from, to};
    }

    private int parseLimit(int limit) {
        if (limit <= 0) {
            return this.defaultLimit;
        }
        if (limit > this.hardLimit) {
            return this.hardLimit;
        }
        return limit;
    }

    private String getBasePath(UriInfo uriInfo) {
        StringBuilder path = new StringBuilder(uriInfo.getBaseUri().toString());
        path.append(CAL_BASE_URI);
        return path.toString();
    }

    private String buildFullUrl(UriInfo uriInfo, int offset, int limit, long fullSize) {
        long next;
        if (fullSize <= 0L) {
            return "";
        }
        offset = offset < 0 ? 0 : offset;
        long prev = offset - limit;
        prev = offset > 0 && prev < 0L ? 0L : prev;
        long prevLimit = (long)offset - prev;
        StringBuilder sb = new StringBuilder();
        if (prev >= 0L) {
            sb.append("<").append(uriInfo.getAbsolutePath()).append("?offset=");
            sb.append(prev).append("&limit=").append(prevLimit).append(">").append(";").append("rel=\"previous\",");
        }
        if ((next = (long)(offset + limit)) < fullSize) {
            sb.append("<").append(uriInfo.getAbsolutePath()).append("?offset=");
            sb.append(next).append("&limit=").append(limit).append(">").append(";").append("rel=\"next\",");
        }
        long firstLimit = (long)limit > fullSize ? fullSize : (long)limit;
        sb.append("<").append(uriInfo.getAbsolutePath()).append("?offset=0&limit=").append(firstLimit).append(">");
        sb.append(";").append("rel=\"first\",");
        long lastIndex = fullSize - fullSize % firstLimit;
        if (lastIndex == fullSize) {
            lastIndex = fullSize - firstLimit;
        }
        if (lastIndex > 0L) {
            sb.append("<").append(uriInfo.getAbsolutePath()).append("?offset=").append(lastIndex);
            sb.append("&limit=").append(fullSize - lastIndex).append(">");
            sb.append(";").append("rel=\"last\"");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private static CalendarService calendarServiceInstance() {
        return (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
    }

    private String makeFeed(String author, List<CalendarEvent> events, FeedData feedData, UriInfo uri) throws Exception {
        URI baseUri = uri.getBaseUri();
        String baseURL = baseUri.getScheme() + "://" + baseUri.getHost() + ":" + Integer.toString(baseUri.getPort());
        String baseRestURL = baseUri.toString();
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        feed.setTitle(feedData.getTitle());
        feed.setLink(baseURL + feedData.getUrl());
        feed.setDescription(feedData.getTitle());
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        for (CalendarEvent event : events) {
            if (Utils.EVENT_NUMBER > 0 && Utils.EVENT_NUMBER <= entries.size()) break;
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(event.getSummary());
            entry.setLink(baseRestURL + BASE_EVENT_URL + "/" + author + "/" + event.getId() + "splitter" + event.getCalType() + ".ics");
            entry.setAuthor(author);
            SyndContentImpl description = new SyndContentImpl();
            description.setType("text/plain");
            description.setValue(event.getDescription());
            entry.setDescription((SyndContent)description);
            entries.add(entry);
            entry.getEnclosures();
        }
        feed.setEntries(entries);
        feed.setEncoding("UTF-8");
        SyndFeedOutput output = new SyndFeedOutput();
        String feedXML = output.outputString((SyndFeed)feed);
        feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
        return feedXML;
    }

    private boolean isInGroups(String[] groups) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        for (String group : groups) {
            if (!identity.isMemberOf(group)) continue;
            return true;
        }
        return false;
    }

    private boolean hasViewCalendarPermission(Calendar cal, String username) throws Exception {
        if (cal.getCalendarOwner() != null && cal.getCalendarOwner().equals(username)) {
            return true;
        }
        if (cal.getGroups() != null) {
            return this.isInGroups(cal.getGroups());
        }
        if (cal.getViewPermission() != null) {
            return Utils.hasPermission((OrganizationService)this.orgService, (String[])cal.getViewPermission(), (String)username);
        }
        return false;
    }

    private List<Calendar> findViewableCalendars(String username) throws Exception {
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        List uCals = service.getUserCalendars(username, true);
        Set groupIds = ConversationState.getCurrent().getIdentity().getGroups();
        List gCals = service.getGroupCalendars(groupIds.toArray(new String[groupIds.size()]), true, username);
        GroupCalendarData sCals = service.getSharedCalendars(username, true);
        if (sCals != null) {
            gCals.add(sCals);
        }
        Calendar[] publicCals = (Calendar[])service.getPublicCalendars().load(0, -1);
        LinkedList<Calendar> results = new LinkedList<Calendar>();
        results.addAll(Arrays.asList(publicCals));
        for (GroupCalendarData data : gCals) {
            if (data.getCalendars() == null) continue;
            for (Calendar cal : data.getCalendars()) {
                results.add(cal);
            }
        }
        results.addAll(uCals);
        return results;
    }

    private List<Calendar> findEditableCalendars(String username) throws Exception {
        List<Calendar> calendars = this.findViewableCalendars(username);
        Iterator<Calendar> iter = calendars.iterator();
        while (iter.hasNext()) {
            if (Utils.isCalendarEditable((String)username, (Calendar)iter.next())) continue;
            iter.remove();
        }
        return calendars;
    }

    private EventQuery buildEventQuery(String start, String end, String category, List<Calendar> calendars, String calendarPath, String participant, String eventType) {
        java.util.Calendar[] dates = this.parseDate(start, end);
        RestEventQuery uQuery = new RestEventQuery();
        uQuery.setQueryType("sql");
        if (calendarPath != null) {
            uQuery.setCalendarPath(calendarPath);
        }
        LinkedList<String> calIds = new LinkedList<String>();
        if (calendars != null) {
            for (Calendar cal : calendars) {
                calIds.add(cal.getId());
            }
            uQuery.setCalendarId(calIds.toArray(new String[calIds.size()]));
        }
        if (category != null) {
            uQuery.setCategoryId(new String[]{category});
        }
        if (participant != null) {
            uQuery.setParticipants(new String[]{participant});
        }
        uQuery.setEventType(eventType);
        uQuery.setFromDate(dates[0]);
        uQuery.setToDate(dates[1]);
        uQuery.setOrderType("ASC");
        uQuery.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        return uQuery;
    }

    private CalendarEvent findEventAttachment(String attachmentID) throws Exception {
        int idx = attachmentID.indexOf(CALENDAR_URI);
        if (idx != -1) {
            int calendars = idx + CALENDAR_URI.length();
            int calendar = attachmentID.indexOf(47, calendars) + 1;
            int event = attachmentID.indexOf(47, calendar);
            if (calendar != -1 && event != -1) {
                String eventId = attachmentID.substring(calendar, event);
                return CalendarRestApi.calendarServiceInstance().getEventById(eventId);
            }
        }
        return null;
    }

    private Object extractObject(Resource iv, String fields) {
        String[] f;
        if (fields != null && iv != null && (f = fields.split(",")).length > 0) {
            JSONObject obj = new JSONObject((Object)iv);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String name : f) {
                try {
                    map.put(name, obj.get(name));
                }
                catch (JSONException e) {
                    log.warn("Can't extract property {} from object {}", new Object[]{name, iv});
                }
            }
            return map;
        }
        return iv;
    }

    private String currentUserId() {
        return ConversationState.getCurrent().getIdentity().getUserId();
    }

    private Response buildEvent(CalendarEvent old, EventResource evObject, Calendar moveToCal) {
        String subject;
        String privacy;
        String priority;
        String eventState;
        if (moveToCal != null) {
            old.setCalendarId(moveToCal.getId());
            try {
                int calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), moveToCal.getId());
                old.setCalType(String.valueOf(calType));
            }
            catch (Exception ex) {
                return this.buildBadResponse(new ErrorResource("Can not get type of calendar " + moveToCal.getId()));
            }
        }
        try {
            if (CalendarRestApi.calendarServiceInstance().isRemoteCalendar(this.currentUserId(), old.getCalendarId())) {
                return this.buildBadResponse(new ErrorResource("Can not add/update event in remote calendar", "cant-add-event-on-remote-calendar"));
            }
        }
        catch (Exception ex) {
            return this.buildBadResponse(new ErrorResource("Can not check remote calendar " + moveToCal.getId(), "cant-check-remote"));
        }
        String catId = evObject.getCategoryId();
        this.setEventCategory(old, catId);
        if (evObject.getDescription() != null) {
            old.setDescription(evObject.getDescription());
        }
        if ((eventState = evObject.getAvailability()) != null) {
            if (Arrays.binarySearch(EVENT_AVAILABILITY, eventState) < 0) {
                return this.buildBadResponse(new ErrorResource("availability must be one of " + StringUtils.join((Object[])EVENT_AVAILABILITY, (String)","), "availability"));
            }
            old.setEventState(eventState);
        }
        if (evObject.getParticipants() != null) {
            old.setParticipant(evObject.getParticipants());
            List<String> parStatus = Stream.of(evObject.getParticipants()).map(par -> par + ":").collect(Collectors.toList());
            old.setParticipantStatus(parStatus.toArray(new String[parStatus.size()]));
        }
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (old.getAttachment() != null && evObject.getUploadResources() != null) {
            for (Attachment att : old.getAttachment()) {
                for (UploadResource resource : evObject.getUploadResources()) {
                    if (!att.getName().equals(resource.getName()) || !StringUtils.isBlank((String)resource.getId())) continue;
                    attachments.add(att);
                }
            }
        }
        if (evObject.getUploadResources() != null) {
            Stream.of(evObject.getUploadResources()).forEach(upload -> {
                String uploadId = upload.getId();
                org.exoplatform.upload.UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
                try {
                    Attachment attachment = new Attachment();
                    attachment.setInputStream((InputStream)new FileInputStream(uploadResource.getStoreLocation()));
                    attachment.setMimeType(uploadResource.getMimeType());
                    attachment.setName(uploadResource.getFileName());
                    long fileSize = (long)uploadResource.getUploadedSize();
                    attachment.setSize(fileSize);
                    attachment.setResourceId(uploadId);
                    attachments.add(attachment);
                }
                catch (Exception ex) {
                    log.error((Object)("Can not save event with upload resource: " + uploadId), (Throwable)ex);
                }
            });
        }
        old.setAttachment(attachments);
        if (evObject.getRepeat() != null) {
            RepeatResource repeat = evObject.getRepeat();
            old.setRepeatType(repeat.getType());
            if (repeat.getExclude() != null) {
                old.setExceptionIds(Arrays.asList(repeat.getExclude()));
            }
            if (repeat.getRepeatOn() != null) {
                String[] reptOns = repeat.getRepeatOn().split(",");
                for (String on : reptOns) {
                    if (Arrays.binarySearch(RP_WEEKLY_BYDAY, on) >= 0) continue;
                    return this.buildBadResponse(new ErrorResource("repeatOn can only contains " + StringUtils.join((Object[])RP_WEEKLY_BYDAY, (String)","), "repeatOn"));
                }
                old.setRepeatByDay(reptOns);
            }
            if (repeat.getRepeateBy() != null) {
                String[] repeatBy = repeat.getRepeateBy().split(",");
                long[] by = new long[repeatBy.length];
                for (int i = 0; i < repeatBy.length; ++i) {
                    try {
                        by[i] = Integer.parseInt(repeatBy[i]);
                        if (by[i] >= 1L && by[i] <= 31L) continue;
                        return this.buildBadResponse(new ErrorResource("repeatBy must be >= 1 and <= 31", "repeatBy"));
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                }
                old.setRepeatByMonthDay(by);
            }
            Date untilDate = null;
            long count = 0L;
            if (repeat.getEnd() != null) {
                End end = repeat.getEnd();
                String val = end.getValue();
                if (RP_END_AFTER.equals(end.getType())) {
                    try {
                        count = Long.parseLong(val);
                    }
                    catch (Exception ex) {
                        log.debug("Can not set repeat count, count is invalid: {}", new Object[]{val});
                    }
                } else if (RP_END_BYDATE.equals(end.getType())) {
                    try {
                        untilDate = ISO8601.parse((String)val).getTime();
                    }
                    catch (Exception e) {
                        log.debug("Can not set repeat until date, date is invalid: {}", new Object[]{val});
                    }
                }
            }
            old.setRepeatUntilDate(untilDate);
            old.setRepeatCount(count);
            int every = repeat.getEvery();
            if (every < 1 || every > 30) {
                every = 1;
            }
            old.setRepeatInterval((long)repeat.getEvery());
        } else {
            old.setRepeatType(Event.RP_NOREPEAT);
        }
        old.setRecurrenceId(evObject.getRecurrenceId());
        java.util.Calendar[] fromTo = this.parseDate(evObject.getFrom(), evObject.getTo());
        if (fromTo[0].after(fromTo[1]) || fromTo[0].equals(fromTo[1])) {
            return this.buildBadResponse(new ErrorResource("\"from\" date must be before \"to\" date", "event-date-time-logic"));
        }
        old.setFromDateTime(fromTo[0].getTime());
        if (evObject.getLocation() != null) {
            old.setLocation(evObject.getLocation());
        }
        if ((priority = evObject.getPriority()) != null) {
            if (Arrays.binarySearch(PRIORITY, priority) < 0) {
                return this.buildBadResponse(new ErrorResource("priority must be one of " + StringUtils.join((Object[])PRIORITY, (String)","), "priority"));
            }
            old.setPriority(evObject.getPriority());
        }
        if (evObject.getReminder() != null) {
            Arrays.stream(evObject.getReminder()).forEach(reminder -> {
                if (reminder.getReminderOwner() == null) {
                    reminder.setReminderOwner(this.currentUserId());
                }
                try {
                    if (reminder.getReminderType().equals(Reminder.TYPE_EMAIL) && reminder.getEmailAddress() == null) {
                        String email = this.orgService.getUserHandler().findUserByName(this.currentUserId()).getEmail();
                        reminder.setEmailAddress(email);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)("Can not set default email for reminder of user " + this.currentUserId()), (Throwable)ex);
                }
                if (reminder.getFromDateTime() == null) {
                    reminder.setFromDateTime(old.getFromDateTime());
                }
            });
            old.setReminders(Arrays.asList(evObject.getReminder()));
        }
        if ((privacy = evObject.getPrivacy()) != null) {
            if (!CalendarEvent.IS_PRIVATE.equals(privacy) && !CalendarEvent.IS_PUBLIC.equals(privacy)) {
                return this.buildBadResponse(new ErrorResource("privacy can only be public or private", "privacy"));
            }
            old.setPrivate(CalendarEvent.IS_PRIVATE.equals(privacy));
        }
        if ((subject = evObject.getSubject()) != null) {
            if ((subject = subject.trim()).isEmpty()) {
                return this.buildBadResponse(new ErrorResource("subject must not be empty", "subject"));
            }
            old.setSummary(subject);
        }
        old.setToDateTime(fromTo[1].getTime());
        return null;
    }

    private Response buildEventFromTask(CalendarEvent old, TaskResource evObject) {
        String name;
        String status;
        java.util.Calendar[] fromTo;
        String catId = evObject.getCategoryId();
        this.setEventCategory(old, catId);
        if (evObject.getNote() != null) {
            old.setDescription(evObject.getNote());
        }
        if ((fromTo = this.parseDate(evObject.getFrom(), evObject.getTo()))[0].after(fromTo[1]) || fromTo[0].equals(fromTo[1])) {
            return this.buildBadResponse(new ErrorResource("\"from\" date must be before \"to\" date", "from"));
        }
        old.setFromDateTime(fromTo[0].getTime());
        String priority = evObject.getPriority();
        if (priority != null) {
            if (Arrays.binarySearch(PRIORITY, priority) < 0) {
                return this.buildBadResponse(new ErrorResource("priority must be one of " + StringUtils.join((Object[])PRIORITY, (String)","), "priority"));
            }
            old.setPriority(evObject.getPriority());
        }
        if (evObject.getReminder() != null) {
            old.setReminders(Arrays.asList(evObject.getReminder()));
        }
        if ((status = evObject.getStatus()) != null && !status.isEmpty()) {
            if (Arrays.binarySearch(TASK_STATUS, status) < 0) {
                return this.buildBadResponse(new ErrorResource("status must be one of " + StringUtils.join((Object[])TASK_STATUS, (String)","), "status"));
            }
            old.setStatus(status);
            old.setEventState(status);
        }
        if ((name = evObject.getName()) != null) {
            if ((name = name.trim()).isEmpty()) {
                return this.buildBadResponse(new ErrorResource("name must not be empty", "name"));
            }
            old.setSummary(evObject.getName());
        }
        old.setToDateTime(fromTo[1].getTime());
        if (evObject.getDelegation() != null) {
            old.setTaskDelegator(StringUtils.join((Object[])evObject.getDelegation(), (String)","));
        }
        return null;
    }

    private void setEventCategory(CalendarEvent old, String catId) {
        if (catId != null) {
            try {
                EventCategory cat = CalendarRestApi.calendarServiceInstance().getEventCategory(this.currentUserId(), catId);
                if (cat != null) {
                    old.setEventCategoryId(cat.getId());
                    old.setEventCategoryName(cat.getName());
                }
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private Response buildCalendar(Calendar cal, CalendarResource calR) {
        String name;
        if (calR.getColor() != null) {
            cal.setCalendarColor(calR.getColor());
        }
        if (calR.getOwner() != null) {
            cal.setCalendarOwner(calR.getOwner());
        }
        if (calR.getDescription() != null) {
            cal.setDescription(calR.getDescription());
        }
        HashSet<String> viewPermissions = new HashSet<String>();
        if (calR.getEditPermission() != null && !calR.getEditPermission().isEmpty()) {
            cal.setEditPermission(calR.getEditPermission().split(";"));
            for (String permission : cal.getEditPermission()) {
                viewPermissions.add(permission);
            }
        }
        if (calR.getViewPermission() != null && !calR.getViewPermission().isEmpty()) {
            for (String permission : calR.getViewPermission().split(";")) {
                viewPermissions.add(permission);
            }
        }
        if (viewPermissions.size() > 0) {
            cal.setViewPermission(viewPermissions.toArray(new String[viewPermissions.size()]));
        }
        if (calR.getGroups() != null) {
            cal.setGroups(calR.getGroups());
        }
        if ((name = calR.getName()) != null) {
            if ((name = name.trim()).isEmpty() || this.containSpecialChar(name)) {
                return this.buildBadResponse(new ErrorResource("calendar name is empty or contains special characters", "name"));
            }
            cal.setName(calR.getName());
        }
        if (calR.getPrivateURL() != null) {
            cal.setPrivateUrl(calR.getPrivateURL());
        }
        if (calR.getPublicURL() != null) {
            cal.setPublicUrl(calR.getPublicURL());
        }
        if (calR.getTimeZone() != null) {
            cal.setTimeZone(calR.getTimeZone());
        }
        return null;
    }

    private boolean containSpecialChar(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-' || Character.isSpaceChar(c)) continue;
            return true;
        }
        return false;
    }

    private Response.ResponseBuilder buildJsonP(Object resource, String jsonp) throws Exception {
        Response.ResponseBuilder response = null;
        if (jsonp != null) {
            String json = null;
            if (resource instanceof Map) {
                json = new JSONObject((Map)resource).toString();
            } else {
                JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                json = generatorImpl.createJsonObject(resource).toString();
            }
            StringBuilder sb = new StringBuilder(jsonp);
            sb.append("(").append(json).append(");");
            response = Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript")).cacheControl(nc);
        } else {
            response = Response.ok((Object)resource, (String)"application/json").cacheControl(nc);
        }
        return response;
    }

    private Object buildTaskResource(CalendarEvent event, UriInfo uriInfo, String expand, String fields) throws Exception {
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        String basePath = this.getBasePath(uriInfo);
        TaskResource evtResource = new TaskResource(event, basePath);
        List<Expand> expands = Expand.parse(expand);
        for (Expand exp : expands) {
            if (DEFAULT_CAL_NAME.equals(exp.getField())) {
                Calendar cal = service.getCalendarById(event.getCalendarId());
                this.setCalType(cal);
                evtResource.setCal(new CalendarResource(cal, basePath));
                continue;
            }
            if ("categories".equals(exp.getField())) {
                EventCategory evCat;
                String categoryId = event.getEventCategoryId();
                if (categoryId == null || (evCat = service.getEventCategory(this.currentUserId(), categoryId)) == null) continue;
                Object[] catRs = new CategoryResource[]{new CategoryResource(evCat, basePath)};
                evtResource.setCats((Serializable[])Utils.subArray((Object[])catRs, (int)exp.getOffset(), (int)exp.getLimit()));
                continue;
            }
            if (!"attachments".equals(exp.getField()) || event.getAttachment() == null) continue;
            List attRs = new LinkedList<AttachmentResource>();
            for (Attachment att : event.getAttachment()) {
                attRs.add(new AttachmentResource(att, basePath));
            }
            attRs = Utils.subList(attRs, (int)exp.getOffset(), (int)exp.getLimit());
            evtResource.setAtts(attRs.toArray(new AttachmentResource[attRs.size()]));
        }
        return this.extractObject(evtResource, fields);
    }

    private Object buildEventResource(CalendarEvent ev, UriInfo uriInfo, String expand, String fields) throws Exception {
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        String basePath = this.getBasePath(uriInfo);
        EventResource evtResource = new EventResource(ev, basePath);
        List<Expand> expands = Expand.parse(expand);
        for (Expand exp : expands) {
            if (DEFAULT_CAL_NAME.equals(exp.getField())) {
                Calendar cal = service.getCalendarById(ev.getCalendarId());
                this.setCalType(cal);
                evtResource.setCal(new CalendarResource(cal, basePath));
                continue;
            }
            if ("categories".equals(exp.getField())) {
                EventCategory evCat;
                String categoryId = ev.getEventCategoryId();
                if (categoryId == null || (evCat = service.getEventCategory(this.currentUserId(), categoryId)) == null) continue;
                Object[] catRs = new CategoryResource[]{new CategoryResource(evCat, basePath)};
                evtResource.setCats((Serializable[])Utils.subArray((Object[])catRs, (int)exp.getOffset(), (int)exp.getLimit()));
                continue;
            }
            if ("originalEvent".equals(exp.getField())) {
                CalendarEvent orgEv;
                String orgId = ev.getOriginalReference();
                if (orgId == null || (orgEv = service.getEventById(orgId)) == null) continue;
                evtResource.setOEvent(new EventResource(orgEv, basePath));
                continue;
            }
            if (!"attachments".equals(exp.getField()) || ev.getAttachment() == null) continue;
            List attRs = new LinkedList<AttachmentResource>();
            for (Attachment att : ev.getAttachment()) {
                attRs.add(new AttachmentResource(att, basePath));
            }
            attRs = Utils.subList(attRs, (int)exp.getOffset(), (int)exp.getLimit());
            evtResource.setAtts(attRs.toArray(new AttachmentResource[attRs.size()]));
        }
        return this.extractObject(evtResource, fields);
    }

    private Object buildFeedResource(FeedData feed, List<String> calIds, UriInfo uriInfo, String expand, String fields) throws Exception {
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        String basePath = this.getBasePath(uriInfo);
        FeedResource feedResource = new FeedResource(feed, calIds.toArray(new String[calIds.size()]), basePath);
        List<Expand> expands = Expand.parse(expand);
        for (Expand exp : expands) {
            if (!"calendars".equals(exp.getField())) continue;
            ArrayList<CalendarResource> calendars = new ArrayList<CalendarResource>();
            for (String calId : Utils.subList(calIds, (int)exp.getOffset(), (int)exp.getLimit())) {
                Calendar cal = service.getCalendarById(calId);
                this.setCalType(cal);
                calendars.add(new CalendarResource(cal, this.getBasePath(uriInfo)));
            }
            feedResource.setCals(Utils.subList(calendars, (int)exp.getOffset(), (int)exp.getLimit()));
        }
        return this.extractObject(feedResource, fields);
    }

    private Object buildInvitationResource(Invitation invitation, UriInfo uriInfo, String expand, String fields) throws Exception {
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        String basePath = this.getBasePath(uriInfo);
        InvitationResource ivtResource = new InvitationResource(invitation, basePath);
        List<Expand> expands = Expand.parse(expand);
        for (Expand exp : expands) {
            if (!"event".equals(exp.getField())) continue;
            CalendarEvent event = service.getEventById(invitation.getEventId());
            ivtResource.setEvt(new EventResource(event, basePath));
        }
        return this.extractObject(ivtResource, fields);
    }

    private String digest(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] hashCode = md5.digest(data);
        return String.valueOf(hashCode);
    }

    private void setCalType(Calendar cal) {
        try {
            cal.setCalType(CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), cal.getId()));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void saveEvent(int calType, CalendarEvent event, boolean bln) throws Exception {
        this.saveEvent(event.getCalendarId(), event.getCalendarId(), calType, calType, event, null, bln);
    }

    private void saveEvent(String fromCal, String toCal, int fromType, int toType, CalendarEvent event, RecurringUpdateType recurringUpdateType, boolean bln) throws Exception {
        CalendarService calService = CalendarRestApi.calendarServiceInstance();
        if (recurringUpdateType == null) {
            if (bln) {
                switch (toType) {
                    case 0: {
                        calService.saveUserEvent(this.currentUserId(), event.getCalendarId(), event, bln);
                        break;
                    }
                    case 2: {
                        calService.savePublicEvent(event.getCalendarId(), event, bln);
                        break;
                    }
                    case 1: {
                        calService.saveEventToSharedCalendar(this.currentUserId(), event.getCalendarId(), event, bln);
                        break;
                    }
                }
            } else {
                List<CalendarEvent> listEvent = Arrays.asList(event);
                if (Utils.isExceptionOccurrence((CalendarEvent)event)) {
                    calService.updateOccurrenceEvent(fromCal, toCal, String.valueOf(fromType), String.valueOf(toType), listEvent, this.currentUserId());
                } else {
                    calService.moveEvent(fromCal, toCal, String.valueOf(fromType), String.valueOf(toType), listEvent, this.currentUserId());
                }
            }
        } else {
            CalendarEvent original = calService.getRepetitiveEvent(event);
            recurringUpdateType = recurringUpdateType == null ? RecurringUpdateType.ONE : recurringUpdateType;
            switch (recurringUpdateType) {
                case ALL: {
                    calService.saveAllSeriesEvents(event, this.currentUserId());
                    break;
                }
                case FOLLOWING: {
                    calService.saveFollowingSeriesEvents(original, event, this.currentUserId());
                    break;
                }
                case ONE: {
                    calService.saveOneOccurrenceEvent(original, event, this.currentUserId());
                }
            }
        }
    }

    static {
        Arrays.sort(RP_WEEKLY_BYDAY);
        Arrays.sort(EVENT_AVAILABILITY);
        Arrays.sort(REPEATTYPES);
        Arrays.sort(PRIORITY);
        Arrays.sort(TASK_STATUS);
        Arrays.sort(INVITATION_STATUS);
        nc.setNoCache(true);
        nc.setNoStore(true);
        log = ExoLogger.getExoLogger(CalendarRestApi.class);
    }

    public static class Expand {
        private String field;
        private int offset;
        private int limit;

        public Expand(String field, int offset, int limit) {
            this.field = field;
            this.offset = offset;
            this.limit = limit;
        }

        public static List<Expand> parse(String expand) {
            LinkedList<Expand> expands = new LinkedList<Expand>();
            if (expand != null) {
                String[] frags = expand.split(",");
                LinkedList<String> tmp = new LinkedList<String>();
                for (int i = 0; i < frags.length; ++i) {
                    String str = frags[i].trim();
                    if (!str.contains("(") && str.contains("")) {
                        tmp.add(str);
                        continue;
                    }
                    if (!str.contains("(") || i + 1 >= frags.length) continue;
                    tmp.add(str + "," + frags[++i]);
                }
                for (String exp : tmp) {
                    String fieldName = null;
                    int offset = 0;
                    int limit = -1;
                    if (exp != null) {
                        int i = (exp = exp.trim()).indexOf(40);
                        if (i > 0) {
                            fieldName = exp.substring(0, i).trim();
                            try {
                                offset = Integer.parseInt(exp.substring(exp.indexOf("offset:") + "offset:".length(), exp.indexOf(",")).trim());
                                limit = Integer.parseInt(exp.substring(exp.indexOf("limit:") + "limit:".length(), exp.indexOf(")")).trim());
                            }
                            catch (Exception ex) {
                                log.debug((Object)ex);
                            }
                        } else {
                            fieldName = exp;
                        }
                    }
                    expands.add(new Expand(fieldName, offset, limit));
                }
            }
            return expands;
        }

        public String getField() {
            return this.field;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLimit() {
            return this.limit;
        }
    }

    public static enum RecurringUpdateType {
        ALL,
        FOLLOWING,
        ONE;

    }
}

