/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Value;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.services.jcr.util.IdGenerator;

public class NotificationInfo {
    public static final String PREFIX_ID = "NotificationMessage";
    public static final String FOR_ALL_USER = "&forAllUser";
    private String id;
    private PluginKey key;
    private String from = "";
    private String to;
    private int order;
    private Map<String, String> ownerParameter = new HashMap<String, String>();
    private List<String> sendToUserIds = new ArrayList<String>();
    private String[] sendToDaily;
    private String[] sendToWeekly;
    private long lastModifiedDate;
    private String title = "";
    private ChannelKey channelKey;
    private Calendar dateCreated;
    private boolean isOnPopOver;
    private boolean isUpdate = false;

    public NotificationInfo() {
        this.id = PREFIX_ID + IdGenerator.generate();
        this.sendToDaily = new String[]{""};
        this.sendToWeekly = new String[]{""};
        this.lastModifiedDate = System.currentTimeMillis();
        this.setDateCreated(Calendar.getInstance());
    }

    public static NotificationInfo instance() {
        return new NotificationInfo();
    }

    public String getId() {
        return this.id;
    }

    public NotificationInfo setId(String id) {
        this.id = id;
        return this;
    }

    public NotificationInfo setSendAll(boolean isSendAll) {
        if (isSendAll) {
            this.setSendToDaily(new String[]{FOR_ALL_USER});
            this.setSendToWeekly(new String[]{FOR_ALL_USER});
        } else {
            this.removeOnSendToDaily(FOR_ALL_USER);
            this.removeOnSendToWeekly(FOR_ALL_USER);
        }
        return this;
    }

    public boolean isSendAll() {
        return ArrayUtils.contains((Object[])this.sendToDaily, (Object)FOR_ALL_USER) || ArrayUtils.contains((Object[])this.sendToWeekly, (Object)FOR_ALL_USER);
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public NotificationInfo setUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
        return this;
    }

    public PluginKey getKey() {
        return this.key;
    }

    public NotificationInfo key(PluginKey key) {
        this.key = key;
        return this;
    }

    public NotificationInfo key(String id) {
        this.key = PluginKey.key(id);
        return this;
    }

    public String getFrom() {
        return this.from;
    }

    public NotificationInfo setFrom(String from) {
        this.from = from;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public NotificationInfo setTitle(String title) {
        this.title = title;
        return this;
    }

    public ChannelKey getChannelKey() {
        return this.channelKey;
    }

    public void setChannelKey(ChannelKey channelKey) {
        this.channelKey = channelKey;
    }

    public String getTo() {
        return this.to;
    }

    public NotificationInfo setTo(String to) {
        this.to = to;
        return this;
    }

    public int getOrder() {
        return this.order;
    }

    public NotificationInfo setOrder(int order) {
        this.order = order;
        return this;
    }

    public List<String> getSendToUserIds() {
        return this.sendToUserIds;
    }

    public NotificationInfo to(List<String> sendToUserIds) {
        this.sendToUserIds = sendToUserIds;
        return this;
    }

    public NotificationInfo to(String sendToUserId) {
        this.sendToUserIds.add(sendToUserId);
        if (this.to == null) {
            this.to = sendToUserId;
        }
        return this;
    }

    public Map<String, String> getOwnerParameter() {
        return this.ownerParameter;
    }

    public String getValueOwnerParameter(String key) {
        return this.ownerParameter.get(key);
    }

    public String[] getArrayOwnerParameter() {
        if (this.ownerParameter.size() == 0) {
            return new String[]{""};
        }
        String[] strs = this.ownerParameter.toString().split(", ");
        strs[0] = strs[0].replace("{", "");
        strs[strs.length - 1] = strs[strs.length - 1].replace("}", "");
        return strs;
    }

    public NotificationInfo setOwnerParameter(Map<String, String> ownerParameter) {
        this.ownerParameter = ownerParameter;
        return this;
    }

    public NotificationInfo with(String key, String value) {
        this.ownerParameter.put(key, value);
        return this;
    }

    public NotificationInfo end() {
        return this;
    }

    public NotificationInfo setOwnerParameter(Value[] values) {
        if (values == null || values.length == 0) {
            return this;
        }
        for (Value val : values) {
            try {
                String str = val.getString();
                if (str.indexOf("=") <= 0) continue;
                String key = str.substring(0, str.indexOf("=")).trim();
                String value = str.substring(str.indexOf("=") + 1).trim();
                this.with(key, value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return this;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public NotificationInfo setLastModifiedDate(Calendar lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate.getTimeInMillis();
        return this;
    }

    public NotificationInfo setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
        return this;
    }

    public Calendar getDateCreated() {
        return this.dateCreated;
    }

    public NotificationInfo setDateCreated(Calendar dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public boolean isOnPopOver() {
        return this.isOnPopOver;
    }

    public NotificationInfo setOnPopOver(boolean isOnPopOver) {
        this.isOnPopOver = isOnPopOver;
        return this;
    }

    public String[] getSendToDaily() {
        return this.sendToDaily;
    }

    public NotificationInfo setSendToDaily(String[] userIds) {
        this.sendToDaily = userIds;
        return this;
    }

    public NotificationInfo setSendToDaily(String userId) {
        this.sendToDaily = this.addMoreItemInArray(this.sendToDaily, userId);
        return this;
    }

    public NotificationInfo removeOnSendToDaily(String userId) {
        this.sendToDaily = this.removeItemInArray(this.sendToDaily, userId);
        return this;
    }

    public String[] getSendToWeekly() {
        return this.sendToWeekly;
    }

    public NotificationInfo setSendToWeekly(String[] userIds) {
        this.sendToWeekly = userIds;
        return this;
    }

    public NotificationInfo setSendToWeekly(String userId) {
        this.sendToWeekly = this.addMoreItemInArray(this.sendToWeekly, userId);
        return this;
    }

    public NotificationInfo removeOnSendToWeekly(String userId) {
        this.sendToWeekly = this.removeItemInArray(this.sendToWeekly, userId);
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof NotificationInfo) {
            NotificationInfo m = (NotificationInfo)o;
            if (super.equals(o)) {
                return true;
            }
            if (m.getId().equals(this.id)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{");
        buffer.append("providerType: ").append(this.key).append(", sendToDaily: ").append(Arrays.asList(this.sendToDaily).toString()).append(", sendToWeekly: ").append(Arrays.asList(this.sendToWeekly).toString());
        return buffer.toString();
    }

    private String[] addMoreItemInArray(String[] src, String element) {
        if (element == null || element.trim().length() == 0) {
            return src;
        }
        ArrayList<Object> where = new ArrayList();
        if (src.length > 1 || src.length == 1 && !src[0].equals("")) {
            where = new ArrayList<String>(Arrays.asList(src));
        }
        if (!where.contains(element)) {
            where.add(element);
            return where.toArray(new String[where.size()]);
        }
        return src;
    }

    private String[] removeItemInArray(String[] src, String element) {
        if (element == null || element.trim().length() == 0) {
            return src;
        }
        ArrayList<Object> where = new ArrayList();
        if (src.length > 1 || src.length == 1 && !src[0].equals("")) {
            where = new ArrayList<String>(Arrays.asList(src));
        }
        if (where.contains(element)) {
            where.remove(element);
            return where.toArray(new String[where.size()]);
        }
        return src;
    }

    public NotificationInfo clone() {
        return this.clone(false);
    }

    public NotificationInfo clone(boolean isNew) {
        NotificationInfo message = NotificationInfo.instance();
        message.setFrom(this.from).key(this.key).setTitle(this.title).setOrder(this.order).setOwnerParameter(new HashMap<String, String>(this.ownerParameter)).setSendToDaily(this.arrayCopy(this.sendToDaily)).setSendToWeekly(this.arrayCopy(this.sendToWeekly)).setTo(this.to);
        if (!isNew) {
            message.setId(this.id);
        }
        return message;
    }

    private String[] arrayCopy(String[] source) {
        String[] stringArray;
        if (source != null && source.length > 0) {
            stringArray = Arrays.asList(source).toArray(new String[source.length]);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        return stringArray;
    }
}

