/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.settings.data;

import java.io.Serializable;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Tools;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;

public class SettingContext
implements Serializable {
    private static final long serialVersionUID = 437625857263645213L;
    protected String repositoryName;
    protected Context context;
    protected String ContextPath;

    public SettingContext(Context context) {
        this.context = context;
        this.repositoryName = SettingContext.getCurrentRepositoryName();
        this.ContextPath = Tools.buildContextPath(context);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof SettingContext) {
            SettingContext dest = (SettingContext)obj;
            return this.repositoryName.equals(dest.getRepositoryName()) && this.getContextPath().equals(dest.getContextPath());
        }
        return false;
    }

    public int hashCode() {
        int result = this.repositoryName.hashCode();
        result = 31 * result + this.ContextPath.hashCode();
        return result;
    }

    public String getContextPath() {
        return this.ContextPath;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public Context getContext() {
        return this.context;
    }

    public static String getCurrentRepositoryName() {
        RepositoryService repositoryService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        try {
            return repositoryService.getCurrentRepository().getConfiguration().getName();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }
}

