/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.plugin;

import groovy.text.Template;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;

public abstract class AbstractNotificationChildPlugin
extends BaseNotificationPlugin {
    private static final String PARENT_ID_KEY = "parentIds";
    private static final String TEMPLATE_PATH_KEY = "templatePath";
    private List<String> parentPluginIds = new ArrayList<String>();
    private Template engine;
    private String templatePath;

    public AbstractNotificationChildPlugin(InitParams initParams) {
        super(initParams);
        ValueParam paramTemplatePath;
        ValuesParam params = initParams.getValuesParam(PARENT_ID_KEY);
        if (params != null) {
            this.parentPluginIds.addAll(params.getValues());
        }
        if ((paramTemplatePath = initParams.getValueParam(TEMPLATE_PATH_KEY)) != null) {
            this.templatePath = paramTemplatePath.getValue();
        }
    }

    public List<String> getParentPluginIds() {
        return this.parentPluginIds;
    }

    protected String getLanguage(NotificationInfo message) {
        return NotificationPluginUtils.getLanguage(message.getTo());
    }

    @Override
    protected NotificationInfo makeNotification(NotificationContext ctx) {
        throw new UnsupportedOperationException("The children plugin " + this.getId() + " unsupported method makeNotification.");
    }

    public abstract String makeContent(NotificationContext var1);

    public Template getTemplateEngine() {
        return this.engine;
    }

    public void setTemplateEngine(Template engine) {
        this.engine = engine;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }
}

