/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.model;

import org.exoplatform.services.mail.Message;
import org.json.JSONObject;

public class MessageInfo {
    private String id;
    private String from;
    private String to;
    private String body = "";
    private String subject = "";
    private String footer;
    private String pluginId = "digest";
    private long createdTime;
    private int numberOnBadge = 0;
    private boolean moveTop = true;

    public MessageInfo setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public MessageInfo pluginId(String pluginId) {
        this.pluginId = pluginId;
        return this;
    }

    public String getFrom() {
        return this.from;
    }

    public MessageInfo from(String from) {
        this.from = from;
        return this;
    }

    public String getTo() {
        return this.to;
    }

    public MessageInfo to(String to) {
        this.to = to;
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public MessageInfo body(String body) {
        this.body = body;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public MessageInfo subject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getFooter() {
        return this.footer;
    }

    public MessageInfo footer(String footer) {
        this.footer = footer;
        return this;
    }

    public MessageInfo end() {
        return this;
    }

    public Message makeEmailNotification() {
        Message message = new Message();
        message.setMimeType("text/html");
        message.setFrom(this.from);
        message.setTo(this.to);
        message.setSubject(this.subject);
        message.setBody(this.body + (this.footer != null && this.footer.length() > 0 ? this.footer : ""));
        return message;
    }

    public String makeNotification() {
        return this.toString();
    }

    public String toJSON() {
        return new JSONObject((Object)this).toString();
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    public int getNumberOnBadge() {
        return this.numberOnBadge;
    }

    public boolean isMoveTop() {
        return this.moveTop;
    }

    public void setMoveTop(boolean moveTop) {
        this.moveTop = moveTop;
    }

    public MessageInfo setNumberOnBadge(int numberOnBadge) {
        this.numberOnBadge = numberOnBadge;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String body = this.body + (this.footer != null && this.footer.length() > 0 ? this.footer : "");
        builder.append("{ ").append("numberOnBadge: '").append(this.numberOnBadge).append("', ").append("subject: '").append(this.subject.replaceAll("'", "&#39;")).append("', ").append("from: '").append(this.from).append("', ").append("to: '").append(this.to).append("', ").append("body: '").append(body.replaceAll("'", "&#39;")).append("' ").append("}");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageInfo && this.getId().equals(((MessageInfo)obj).getId())) {
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
        result = 31 * result + (this.footer != null ? this.footer.hashCode() : 0);
        result = 31 * result + this.pluginId.hashCode();
        result = 31 * result + Long.hashCode(this.createdTime);
        result = 31 * result + this.numberOnBadge;
        return result;
    }
}

