/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.websocket;

import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.exoplatform.commons.api.websocket.ExtensibleWSFilter;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;

public abstract class AbstractEndpoint
extends Endpoint
implements MessageHandler.Whole<String>,
MessageHandler.Partial<String> {
    protected volatile Session _session;
    private ExtensibleWSFilter filter;

    public void onOpen(Session wsSession, EndpointConfig config) {
        this._session = wsSession;
        wsSession.addMessageHandler((MessageHandler)this);
        this.getFilter().onOpen(wsSession, config, this);
    }

    public void onClose(Session wsSession, CloseReason closeReason) {
        this._session = wsSession;
        this.getFilter().onClose(wsSession, closeReason, this);
    }

    public void onError(Session wsSession, Throwable failure) {
        this._session = wsSession;
        this.getFilter().onError(wsSession, failure, this);
    }

    public void onMessage(String message) {
        this.getFilter().onMessage(message, this);
    }

    public void onMessage(String message, boolean arg1) {
        this.getFilter().onMessage(message, arg1, this);
    }

    private ExtensibleWSFilter getFilter() {
        if (this.filter == null) {
            PortalContainer container = RootContainer.getInstance().getPortalContainer(PortalContainer.getCurrentPortalContainerName());
            this.filter = (ExtensibleWSFilter)container.getComponentInstanceOfType(ExtensibleWSFilter.class);
        }
        return this.filter;
    }

    protected abstract void doOpen(Session var1, EndpointConfig var2);

    protected abstract void doClose(Session var1, CloseReason var2);

    protected abstract void doError(Session var1, Throwable var2);

    protected abstract void doMessage(Session var1, String var2);

    protected abstract void doMessage(Session var1, String var2, boolean var3);
}

