/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.api.ui.ActionContext;
import org.exoplatform.commons.api.ui.BaseUIPlugin;
import org.exoplatform.commons.api.ui.PlugableUIService;
import org.exoplatform.commons.api.ui.RenderContext;
import org.exoplatform.commons.api.ui.Response;

public class PlugableUIServiceImpl
implements PlugableUIService {
    private Map<String, List<BaseUIPlugin>> plugins = new HashMap<String, List<BaseUIPlugin>>();

    @Override
    public void addPlugin(BaseUIPlugin plugin) {
        List<BaseUIPlugin> lst = this.plugins.get(plugin.getType());
        if (lst == null) {
            lst = new ArrayList<BaseUIPlugin>();
            this.plugins.put(plugin.getType(), lst);
        }
        lst.add(plugin);
    }

    @Override
    public List<BaseUIPlugin> getPlugins(String type) {
        return this.plugins.get(type);
    }

    @Override
    public List<Response> render(RenderContext renderContext) {
        List<BaseUIPlugin> plugins = this.getPlugins(renderContext.getPluginType());
        ArrayList<Response> response = new ArrayList<Response>();
        if (plugins != null) {
            for (BaseUIPlugin plugin : plugins) {
                response.add(plugin.render(renderContext));
            }
        }
        return response;
    }

    @Override
    public Response processAction(ActionContext actionContext) {
        List<BaseUIPlugin> plugins = this.getPlugins(actionContext.getPluginType());
        if (plugins != null) {
            for (BaseUIPlugin plugin : plugins) {
                Response response = plugin.processAction(actionContext);
                if (response == null) continue;
                return response;
            }
        }
        return null;
    }
}

