/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.websocket;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.api.websocket.WSFilter;

public class WSFilterDefinition {
    private WSFilter filter;
    private volatile FilterMapping mapping;
    private List<String> patterns;

    public WSFilterDefinition() {
    }

    public WSFilterDefinition(WSFilter filter, List<String> patterns) {
        this.filter = filter;
        this.patterns = patterns;
    }

    public WSFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(String path) {
        if (this.mapping == null) {
            WSFilterDefinition wSFilterDefinition = this;
            synchronized (wSFilterDefinition) {
                if (this.mapping == null) {
                    this.mapping = new FilterMapping(this.patterns);
                    this.patterns = null;
                }
            }
        }
        return this.mapping.match(path);
    }

    private static class FilterMapping {
        private final List<Pattern> patterns;

        public FilterMapping(List<String> strPatterns) {
            if (strPatterns == null || strPatterns.isEmpty()) {
                throw new IllegalArgumentException("The list of patterns cannot be empty");
            }
            this.patterns = new ArrayList<Pattern>(strPatterns.size());
            for (String sPattern : strPatterns) {
                this.patterns.add(Pattern.compile(sPattern));
            }
        }

        public boolean match(String path) {
            int length = this.patterns.size();
            for (int i = 0; i < length; ++i) {
                Pattern pattern = this.patterns.get(i);
                Matcher matcher = pattern.matcher(path);
                if (!matcher.matches()) continue;
                return true;
            }
            return false;
        }
    }
}

