/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.channel.template;

import groovy.text.Template;
import java.io.Writer;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.services.organization.OrganizationService;

public abstract class AbstractTemplateBuilder {
    private Template engine;

    protected abstract MessageInfo makeMessage(NotificationContext var1);

    protected abstract boolean makeDigest(NotificationContext var1, Writer var2);

    public MessageInfo buildMessage(NotificationContext ctx) {
        NotificationInfo notif = ctx.getNotificationInfo();
        try {
            MessageInfo messageInfo = this.makeMessage(ctx);
            if (messageInfo == null) {
                return null;
            }
            return messageInfo.setId(notif.getId()).pluginId(notif.getKey().getId()).from(NotificationPluginUtils.getFrom(notif.getFrom())).to(NotificationPluginUtils.getTo(notif.getTo())).end();
        }
        catch (Exception e) {
            ctx.setException(e);
            return new MessageInfo();
        }
    }

    public boolean buildDigest(NotificationContext ctx, Writer writer) {
        return this.makeDigest(ctx, writer);
    }

    protected String getLanguage(NotificationInfo notif) {
        return NotificationPluginUtils.getLanguage(notif.getTo());
    }

    protected OrganizationService getOrganizationService() {
        return NotificationPluginUtils.getOrganizationService();
    }

    public Template getTemplateEngine() {
        return this.engine;
    }

    public void setTemplateEngine(Template engine) {
        this.engine = engine;
    }

    public NotificationInfo getNotificationToStore(NotificationInfo notificationInfo) {
        return notificationInfo;
    }
}

