/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class UserSetting {
    public static final String EMAIL_CHANNEL = "MAIL_CHANNEL";
    private Set<String> channelActives = this.newSet(null);
    private Calendar lastUpdateTime;
    private String userId;
    private Map<String, List<String>> channelPlugins = this.newMap(null);
    private List<String> dailyPlugins = this.newList(null);
    private List<String> weeklyPlugins = this.newList(null);
    private List<Long> mutedSpaces;
    private long lastReadDate = 0L;
    private boolean isEnabled = true;

    public UserSetting() {
        this.lastUpdateTime = Calendar.getInstance();
    }

    public static UserSetting getInstance() {
        return new UserSetting();
    }

    public long getLastReadDate() {
        return this.lastReadDate;
    }

    public void setLastReadDate(long lastReadDate) {
        this.lastReadDate = lastReadDate;
    }

    public Set<String> getChannelActives() {
        if (this.channelActives == null) {
            this.channelActives = this.newSet(null);
        }
        return this.channelActives;
    }

    public boolean isChannelGloballyActive(String channelId) {
        return this.isEnabled && this.channelActives != null && this.channelActives.contains(channelId);
    }

    public boolean isChannelActive(String channelId, String pluginId) {
        return this.isEnabled && this.channelPlugins != null && this.channelPlugins.containsKey(channelId) && this.channelPlugins.get(channelId).contains(pluginId);
    }

    public boolean isSpaceMuted(long spaceId) {
        return this.mutedSpaces != null && this.mutedSpaces.contains(spaceId);
    }

    public void addMutedSpace(long spaceId) {
        if (this.mutedSpaces == null) {
            this.mutedSpaces = new ArrayList<Long>();
        }
        this.mutedSpaces.add(spaceId);
    }

    public void removeMutedSpace(long spaceId) {
        if (this.mutedSpaces != null) {
            this.mutedSpaces.remove(spaceId);
        }
    }

    public void setMutedSpaces(List<Long> mutedSpaces) {
        this.mutedSpaces = mutedSpaces == null ? new ArrayList<Long>() : new ArrayList<Long>(mutedSpaces);
    }

    public List<Long> getMutedSpaces() {
        if (this.mutedSpaces == null) {
            return Collections.emptyList();
        }
        return this.mutedSpaces;
    }

    public void setChannelActive(String channelId) {
        if (this.channelActives == null) {
            this.channelActives = this.newSet(null);
        }
        this.channelActives.add(channelId);
    }

    public void removeChannelActive(String channelId) {
        this.channelActives.remove(channelId);
    }

    public void setChannelActives(Set<String> channelActives) {
        this.channelActives = this.newSet(channelActives);
    }

    public String getUserId() {
        return this.userId;
    }

    public UserSetting setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public Calendar getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public UserSetting setLastUpdateTime(Calendar lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    public void setAllChannelPlugins(Map<String, List<String>> channelPlugins) {
        this.channelPlugins = this.newMap(channelPlugins);
    }

    public Map<String, List<String>> getAllChannelPlugins() {
        return this.channelPlugins;
    }

    public List<String> getPlugins(String channelId) {
        return this.channelPlugins.getOrDefault(channelId, Collections.emptyList());
    }

    public void setChannelPlugins(String channelId, List<String> pluginIds) {
        this.channelPlugins.put(channelId, this.newList(pluginIds));
    }

    public void addChannelPlugin(String channelId, String pluginId) {
        List plugins = this.channelPlugins.computeIfAbsent(channelId, key -> this.newList(null));
        if (!plugins.contains(pluginId)) {
            plugins.add(pluginId);
        }
    }

    public void removeChannelPlugin(String channelId, String pluginId) {
        List<String> plugins = this.channelPlugins.get(channelId);
        if (plugins != null && plugins.contains(pluginId)) {
            plugins.remove(pluginId);
        }
    }

    public List<String> getDailyPlugins() {
        return this.dailyPlugins;
    }

    public void setDailyPlugins(List<String> dailyPlugins) {
        this.dailyPlugins = this.newList(dailyPlugins);
    }

    public List<String> getWeeklyPlugins() {
        return this.weeklyPlugins;
    }

    public void setWeeklyPlugins(List<String> weeklyPlugins) {
        this.weeklyPlugins = this.newList(weeklyPlugins);
    }

    public void addPlugin(String pluginId, FREQUENCY frequencyType) {
        if (frequencyType.equals((Object)FREQUENCY.DAILY)) {
            this.addProperty(this.dailyPlugins, pluginId);
            this.weeklyPlugins.remove(pluginId);
        } else if (frequencyType.equals((Object)FREQUENCY.WEEKLY)) {
            this.addProperty(this.weeklyPlugins, pluginId);
            this.dailyPlugins.remove(pluginId);
        } else if (frequencyType.equals((Object)FREQUENCY.INSTANTLY)) {
            this.addChannelPlugin(EMAIL_CHANNEL, pluginId);
        }
    }

    public void removePlugin(String pluginId, FREQUENCY frequencyType) {
        if (frequencyType.equals((Object)FREQUENCY.DAILY)) {
            this.weeklyPlugins.remove(pluginId);
        } else if (frequencyType.equals((Object)FREQUENCY.WEEKLY)) {
            this.dailyPlugins.remove(pluginId);
        } else if (frequencyType.equals((Object)FREQUENCY.INSTANTLY)) {
            this.removeChannelPlugin(EMAIL_CHANNEL, pluginId);
        }
    }

    public boolean isActive(String channelId, String pluginId) {
        return this.isEnabled && this.getPlugins(channelId).contains(pluginId);
    }

    public boolean isInDaily(String pluginId) {
        return this.isEnabled && this.dailyPlugins.contains(pluginId);
    }

    public boolean isInWeekly(String pluginId) {
        return this.isEnabled && this.weeklyPlugins.contains(pluginId);
    }

    private void addProperty(List<String> providers, String pluginId) {
        if (!providers.contains(pluginId)) {
            providers.add(pluginId);
        }
    }

    public UserSetting clone() {
        UserSetting setting = UserSetting.getInstance();
        setting.setChannelActives(this.newSet(this.channelActives));
        setting.setDailyPlugins(this.newList(this.dailyPlugins));
        setting.setWeeklyPlugins(this.newList(this.weeklyPlugins));
        for (Map.Entry<String, List<String>> entry : this.channelPlugins.entrySet()) {
            setting.setChannelPlugins(entry.getKey(), this.newList(entry.getValue()));
        }
        setting.setUserId(this.userId);
        setting.setMutedSpaces(this.mutedSpaces);
        return setting;
    }

    public String toString() {
        return "UserSetting : {userId : " + this.userId + "}";
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSetting that = (UserSetting)o;
        return this.lastReadDate == that.lastReadDate && this.isEnabled == that.isEnabled && Objects.equals(this.channelActives, that.channelActives) && Objects.equals(this.lastUpdateTime, that.lastUpdateTime) && Objects.equals(this.userId, that.userId) && Objects.equals(this.channelPlugins, that.channelPlugins) && Objects.equals(this.dailyPlugins, that.dailyPlugins) && Objects.equals(this.weeklyPlugins, that.weeklyPlugins);
    }

    public int hashCode() {
        return Objects.hash(this.channelActives, this.lastUpdateTime, this.userId, this.channelPlugins, this.dailyPlugins, this.weeklyPlugins, this.lastReadDate, this.isEnabled);
    }

    private Map<String, List<String>> newMap(Map<String, List<String>> map) {
        return Collections.synchronizedMap(map == null ? new HashMap() : new HashMap<String, List<String>>(map));
    }

    private List<String> newList(List<String> list) {
        return Collections.synchronizedList(list == null ? new ArrayList() : new ArrayList<String>(list));
    }

    private Set<String> newSet(Set<String> set) {
        return Collections.synchronizedSet(set == null ? new HashSet() : new HashSet<String>(set));
    }

    public static enum FREQUENCY {
        INSTANTLY,
        DAILY,
        WEEKLY;


        public static FREQUENCY getFrequecy(String name) {
            for (int i = 0; i < FREQUENCY.values().length; ++i) {
                if (!FREQUENCY.values()[i].name().equalsIgnoreCase(name)) continue;
                return FREQUENCY.values()[i];
            }
            return null;
        }
    }
}

