/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.cometd.loadbalancer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.loadbalancer.LoadBalancer;
import org.exoplatform.ws.frameworks.cometd.loadbalancer.LoadBalancerConfigPlugin;
import org.exoplatform.ws.frameworks.cometd.loadbalancer.Node;
import org.picocontainer.Startable;

public class LoadBalancerImpl
implements LoadBalancer,
Startable {
    private static final Log LOG = ExoLogger.getLogger(LoadBalancerImpl.class);
    private LoadBalancerConf loadBalancerConf;
    private ConcurrentHashMap<String, Node> nodes = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> connectionMap = new ConcurrentHashMap();

    public LoadBalancerImpl(InitParams params) {
    }

    @Override
    public void addNode(Node node) {
        this.nodes.put(node.getId(), node);
    }

    @Override
    public String connection(String exoId) {
        return this.getNodeURL(exoId);
    }

    @Override
    public List<String> getAliveNodesURL() {
        ArrayList<String> urls = new ArrayList<String>();
        Collection<Node> ns = this.nodes.values();
        for (Node node : ns) {
            if (!node.isAlive()) continue;
            urls.add(node.getUrl());
        }
        return urls;
    }

    @Override
    public boolean release(String exoId) {
        String id = this.connectionMap.get(exoId);
        if (id != null) {
            Node node = this.nodes.get(id);
            node.delConnection();
            this.connectionMap.remove(exoId);
            this.nodes.put(node.getId(), node);
            return true;
        }
        return false;
    }

    @Override
    public void removeNode(String id) {
        this.nodes.remove(id);
        Set set = this.connectionMap.keySet();
        for (String key : set) {
            if (!this.connectionMap.get(key).equals(id)) continue;
            this.connectionMap.remove(key);
        }
    }

    private String getNodeURL(String exoId) {
        if (this.connectionMap.containsKey(exoId)) {
            return this.nodes.get(this.connectionMap.get(exoId)).getUrl();
        }
        Collection<Node> ns = this.nodes.values();
        for (Node node : ns) {
            if (node.getConnected() >= node.getMaxConnection()) continue;
            node.addConnection();
            this.nodes.put(node.getId(), node);
            this.connectionMap.put(exoId, node.getId());
            return node.getUrl();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Overflow new client cannot connect!");
        }
        return null;
    }

    public void start() {
        if (this.loadBalancerConf != null) {
            List<Node> list = this.loadBalancerConf.getNodes();
            for (Node node : list) {
                this.nodes.put(node.getId(), node);
            }
        }
    }

    public void stop() {
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (LoadBalancerConfigPlugin.class.isAssignableFrom(plugin.getClass())) {
            LoadBalancerConfigPlugin configPlugin = (LoadBalancerConfigPlugin)plugin;
            this.loadBalancerConf = configPlugin.getBalancerConf();
        }
    }

    public static class LoadBalancerConf {
        private List<Node> nodes = new ArrayList<Node>();

        public List<Node> getNodes() {
            return this.nodes;
        }

        public void setNodes(List<Node> nodes) {
            this.nodes = nodes;
        }
    }
}

