/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.cometd;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.installer.ZipURLInstaller;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.util.log.LogLevel;
import org.codehaus.cargo.util.log.Logger;
import org.codehaus.cargo.util.log.SimpleLogger;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CargoContainer {
    private static final Log LOG = ExoLogger.getLogger(CargoContainer.class);
    protected static final String TEST_PATH = System.getProperty("testPath") == null ? "." : System.getProperty("testPath");
    protected static final String TEST_LIB_PATH = TEST_PATH + "/target/test";

    public static InstalledLocalContainer cargoContainerStart(String port, String home) {
        try {
            int c;
            String[] arr;
            if (port == null || port == "") {
                port = "8080";
            }
            if (home == null || home == "") {
                home = System.getProperty("java.io.tmpdir");
            }
            ZipURLInstaller installer = new ZipURLInstaller(new URL("http://www.apache.org/dist/tomcat/tomcat-6/v6.0.35/bin/apache-tomcat-6.0.35.zip"), home);
            installer.install();
            LocalConfiguration configuration = (LocalConfiguration)new DefaultConfigurationFactory().createConfiguration("tomcat5x", ContainerType.INSTALLED, ConfigurationType.STANDALONE);
            configuration.setProperty("cargo.servlet.port", port);
            configuration.addDeployable((Deployable)new WAR(TEST_PATH + "/target/test/war/rest.war"));
            InstalledLocalContainer container = (InstalledLocalContainer)new DefaultContainerFactory().createContainer("tomcat5x", ContainerType.INSTALLED, (Configuration)configuration);
            container.setHome(installer.getHome());
            ArrayList<CallSite> lst = new ArrayList<CallSite>();
            File dir = new File(TEST_LIB_PATH);
            for (String name : arr = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            })) {
                lst.add((CallSite)((Object)(TEST_LIB_PATH + "/" + name)));
            }
            String[] arr2 = new String[lst.size()];
            lst.toArray(arr2);
            container.setExtraClasspath(arr2);
            container.setOutput("target/logs/tomcat.log");
            SimpleLogger logger = new SimpleLogger();
            LogLevel level = LogLevel.WARN;
            logger.setLevel(level);
            container.setLogger((Logger)logger);
            File inputFile = new File(TEST_PATH + "/src/test/resources/tomcat/exo-configuration.xml");
            File outputFile = new File(container.getHome() + "/exo-configuration.xml");
            LOG.info((Object)("CargoContainer.cargoContainerStart()" + container.getHome()));
            FileReader in = new FileReader(inputFile);
            FileWriter out = new FileWriter(outputFile);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
            container.start();
            LOG.info((Object)("CargoContainer.containerStart() : " + container.getState().isStarted()));
            return container;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public static void cargoContainerStop(InstalledLocalContainer container) {
        container.stop();
    }
}

