/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.continuation;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.client.http.jetty.JettyHttpClientTransport;
import org.cometd.client.websocket.javax.WebSocketTransport;
import org.cometd.oort.Oort;
import org.cometd.oort.OortMulticastConfigServlet;
import org.cometd.oort.OortStaticConfigServlet;
import org.cometd.oort.Seti;
import org.cometd.oort.SetiServlet;
import org.cometd.server.CometDServlet;
import org.eclipse.jetty.client.HttpClient;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.ServletContextWrapper;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

public class EXoContinuationCometdServlet
extends CometDServlet {
    private static final long serialVersionUID = 9204910608302112814L;
    private static final Log LOG = ExoLogger.getLogger(CometDServlet.class);
    private SetiServlet setiConfig;
    private ExoContainer container;
    private boolean initialized;
    private boolean clusterEnabled = false;
    private static EXoContinuationCometdServlet instance;
    private ServletConfig originConfig;
    public static final String PREFIX = "exo.cometd.";
    protected static final String CLOUD_ID_SEPARATOR = "exo.cometd.cloudIDSeparator";
    public static String OORT_CONFIG_TYPE;
    public static String OORT_CONFIG_CLOUD;
    public static String OORT_CONFIG_URL;
    public static String EXO_OORT_CONFIG_TYPE;
    public static String EXO_OORT_CONFIG_CLOUD;
    public static String EXO_OORT_CONFIG_URL;
    public static String OORT_MULTICAST;
    public static String OORT_STATIC;
    public static final Pattern URL_REGEX;
    private ServletConfig servletConfig;

    public void init(ServletConfig config) throws ServletException {
        this.originConfig = config;
        RootContainer.PortalContainerPostInitTask task = new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                EXoContinuationCometdServlet.this.setContainer((ExoContainer)portalContainer);
                EXoContinuationCometdServlet.this.init();
                EXoContinuationCometdServlet.this.initialized = true;
            }
        };
        PortalContainer.addInitTask((ServletContext)config.getServletContext(), (RootContainer.PortalContainerInitTask)task);
        instance = this;
    }

    public void reInit() {
        if (this.initialized) {
            this.init();
        }
    }

    public void init() {
        ServletConfig servletConfig = this.getServletConfig();
        try {
            super.init();
            String profiles = PropertyManager.getProperty((String)"exo.profiles");
            if (profiles != null) {
                this.clusterEnabled = profiles.contains("cluster");
                if (this.clusterEnabled) {
                    this.warnInvalidUrl(this.getInitParameter("oort.url"));
                }
            }
            String configType = this.getInitParameter(OORT_CONFIG_TYPE);
            LOG.info("Cometd configured with type {}", new Object[]{configType});
            if (this.clusterEnabled) {
                if (OORT_MULTICAST.equals(configType)) {
                    oConfig = new OortMulticastConfig();
                    oConfig.init(servletConfig);
                } else if (OORT_STATIC.equals(configType)) {
                    LOG.info("Cometd configured with cloud {}", new Object[]{this.getInitParameter(OORT_CONFIG_CLOUD)});
                    oConfig = new OortStaticConfig();
                    oConfig.init(servletConfig);
                } else {
                    LOG.warn("No valid parameter {} value was set ({}), cometd initialization will fail", new Object[]{EXO_OORT_CONFIG_TYPE, configType});
                }
            } else {
                PropertyManager.setProperty((String)EXO_OORT_CONFIG_CLOUD, (String)"");
                oConfig = new OortStaticConfig();
                oConfig.init(servletConfig);
            }
            this.setiConfig = new SetiServlet();
            this.setiConfig.init(servletConfig);
            ServletContext cometdContext = servletConfig.getServletContext();
            Seti seti = (Seti)cometdContext.getAttribute(Seti.SETI_ATTRIBUTE);
            Oort oort = (Oort)cometdContext.getAttribute(Oort.OORT_ATTRIBUTE);
            EXoContinuationBayeux bayeux = this.getBayeux();
            bayeux.setSeti(seti);
            bayeux.setOort(oort);
            String separator = this.getInitParameter(CLOUD_ID_SEPARATOR);
            if (separator != null) {
                bayeux.setCloudIDSeparator(separator);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot initialize Bayeux", (Throwable)e);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.getContainer() == null || this.getBayeux() == null) {
            AsyncContext ac = request.startAsync((ServletRequest)request, (ServletResponse)response);
            ac.start(() -> {
                while (this.getContainer() == null || this.getBayeux() == null) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)e);
                    }
                }
                try {
                    this.service(ac.getRequest(), ac.getResponse());
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
            });
        } else {
            super.service(request, response);
        }
    }

    public String getInitParameter(String name) {
        return this.getServletConfig().getInitParameter(name);
    }

    public ServletConfig getServletConfig() {
        EXoContinuationBayeux bayeux = this.getBayeux();
        if (this.servletConfig == null) {
            this.servletConfig = new ServletConfigWrapper(this.originConfig);
            bayeux.setServletConfig(this.servletConfig);
        }
        return this.servletConfig;
    }

    public void setContainer(ExoContainer container) {
        this.container = container;
    }

    private ExoContainer getContainer() {
        return this.container;
    }

    protected EXoContinuationBayeux newBayeuxServer() {
        return this.getBayeux();
    }

    public EXoContinuationBayeux getBayeux() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("EXoContinuationCometdServlet - Current Container-ExoContainer: " + String.valueOf(this.getContainer())));
            }
            EXoContinuationBayeux bayeux = (EXoContinuationBayeux)((Object)this.getContainer().getComponentInstanceOfType(BayeuxServer.class));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("EXoContinuationCometdServlet - -->AbstractBayeux=" + String.valueOf((Object)bayeux)));
            }
            return bayeux;
        }
        catch (Exception e) {
            LOG.error((Object)"Error new Bayeux creation ", (Throwable)e);
            return null;
        }
    }

    public static EXoContinuationCometdServlet getInstance() {
        return instance;
    }

    public void destroy() {
    }

    private Oort configTransports(Oort oort) {
        ServletConfig config = this.getServletConfig();
        String transport = config.getInitParameter("transports");
        if (transport == null || !transport.contains(WebSocketTransport.class.getName())) {
            oort.getClientTransportFactories().add(new JettyHttpClientTransport.Factory(new HttpClient()));
        }
        return oort;
    }

    private void warnInvalidUrl(String url) {
        if (url == null || url.isEmpty()) {
            LOG.warn((Object)"You didn\u2019t set exo.cometd.oort.url, cometd cannot work in cluster mode without this property, please set it.");
        } else if (!URL_REGEX.matcher(url).matches()) {
            LOG.warn("exo.cometd.oort.url is invalid {}, cometd cannot work in cluster mode without this property, please set it.", new Object[]{url});
        }
    }

    static {
        OORT_CONFIG_TYPE = "oort.configType";
        OORT_CONFIG_CLOUD = "oort.cloud";
        OORT_CONFIG_URL = "oort.cloud";
        EXO_OORT_CONFIG_TYPE = PREFIX + OORT_CONFIG_TYPE;
        EXO_OORT_CONFIG_CLOUD = PREFIX + OORT_CONFIG_CLOUD;
        EXO_OORT_CONFIG_URL = PREFIX + OORT_CONFIG_URL;
        OORT_MULTICAST = "multicast";
        OORT_STATIC = "static";
        String ip_regex = "(((((25[0-5])|(2[0-4][0-9])|([01]?[0-9]?[0-9]))\\.){3}((25[0-4])|(2[0-4][0-9])|((1?[1-9]?[1-9])|([1-9]0))))|(0\\.){3}0)";
        URL_REGEX = Pattern.compile("^((ht|f)tp(s?)://)(\\w+(:\\w+)?@)?(" + ip_regex + "|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6}|([a-zA-Z][-a-zA-Z0-9]+))(:[0-9]{1,5})?((/?)|(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?)$");
    }

    public class OortMulticastConfig
    extends OortMulticastConfigServlet {
        private static final long serialVersionUID = 6836833932474627776L;

        protected void configureCloud(ServletConfig config, Oort oort) throws Exception {
            if (EXoContinuationCometdServlet.this.clusterEnabled) {
                super.configureCloud(config, oort);
            }
        }

        protected Oort newOort(BayeuxServer bayeux, String url) {
            Oort oort = super.newOort(bayeux, url);
            return EXoContinuationCometdServlet.this.configTransports(oort);
        }
    }

    public class OortStaticConfig
    extends OortStaticConfigServlet {
        private static final long serialVersionUID = 1054209695244836363L;

        protected void configureCloud(ServletConfig config, Oort oort) throws Exception {
            if (EXoContinuationCometdServlet.this.clusterEnabled) {
                super.configureCloud(config, oort);
            }
        }

        protected Oort newOort(BayeuxServer bayeux, String url) {
            Oort oort = super.newOort(bayeux, url);
            return EXoContinuationCometdServlet.this.configTransports(oort);
        }
    }

    private class ServletConfigWrapper
    implements ServletConfig {
        private ServletConfig delegate;
        private ServletContext contextWrapper;
        private String[] configs;

        public ServletConfigWrapper(ServletConfig config) {
            this.delegate = config;
            this.contextWrapper = new ServletContextWrapper(this.delegate.getServletContext());
        }

        public String getInitParameter(String name) {
            String propertyName = EXoContinuationCometdServlet.PREFIX + name;
            String value = PropertyManager.getProperty((String)propertyName);
            LOG.debug("Reading cometd property {} from JVM properties, value = {}", new Object[]{propertyName, value});
            if (value == null) {
                value = this.delegate.getInitParameter(name);
                LOG.debug("Reading cometd property {} from Servlet init params, value = {}", new Object[]{propertyName, value});
            }
            return value;
        }

        public Enumeration<String> getInitParameterNames() {
            if (this.configs == null) {
                LinkedList<String> keys = new LinkedList<String>();
                Properties props = PrivilegedSystemHelper.getProperties();
                int len = EXoContinuationCometdServlet.PREFIX.length();
                for (Object key : props.keySet()) {
                    String k = key.toString().trim();
                    if (!k.startsWith(EXoContinuationCometdServlet.PREFIX) || k.length() <= len) continue;
                    keys.add(k.substring(len));
                }
                this.configs = keys.toArray(new String[keys.size()]);
            }
            HashSet<Object> names = new HashSet<Object>();
            names.addAll(Collections.list(this.delegate.getInitParameterNames()));
            names.addAll(Arrays.asList(this.configs));
            return Collections.enumeration(names);
        }

        public ServletContext getServletContext() {
            return this.contextWrapper;
        }

        public String getServletName() {
            return this.delegate.getServletName();
        }
    }
}

