/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.template;

import groovy.lang.Writable;
import groovy.text.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.exoplatform.commons.api.notification.model.NotificationKey;
import org.exoplatform.commons.api.notification.service.setting.PluginContainer;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.api.notification.template.Element;
import org.exoplatform.commons.api.notification.template.ElementVisitor;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GroovyElementVisitor
implements ElementVisitor {
    private static final Log LOG = ExoLogger.getLogger(GroovyElementVisitor.class);
    private final Writer writer = new StringWriter();
    private TemplateContext ctx;

    public ElementVisitor visit(Element element) {
        this.ctx.put((Object)"_ctx", (Object)element);
        try {
            NotificationKey key = new NotificationKey(this.ctx.getPluginId());
            Template engine = CommonsUtils.getService(PluginContainer.class).getPlugin(key).getTemplateEngine();
            Writable writable = engine.make((Map)this.getTemplateContext());
            writable.writeTo(this.writer);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed at visit().", (Throwable)e);
        }
        return this;
    }

    public String out() {
        return this.writer.toString();
    }

    public TemplateContext getTemplateContext() {
        return this.ctx;
    }

    public ElementVisitor with(TemplateContext ctx) {
        this.ctx = ctx;
        return this;
    }

    public Writer getWriter() {
        return this.writer;
    }
}

