/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.user;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/state/")
public class RESTUserService
implements ResourceContainer {
    private final UserStateService userService;
    protected static final String ACTIVITY = "activity";
    protected static final String STATUS = "status";

    public RESTUserService(UserStateService userService) {
        this.userService = userService;
    }

    @GET
    @Path(value="/ping/")
    @RolesAllowed(value={"users"})
    public Response updateState() {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        this.userService.ping(userId);
        return Response.ok().cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/status/")
    @RolesAllowed(value={"users"})
    public Response online() throws ParserConfigurationException, JSONException {
        List<UserStateModel> usersOnline = this.userService.online();
        if (usersOnline == null) {
            return Response.ok().build();
        }
        JSONArray json = new JSONArray();
        for (UserStateModel model : usersOnline) {
            json.put((Object)this.fillModelToJson(model));
        }
        return Response.ok((Object)json.toString(), (String)"application/json").build();
    }

    private JSONObject fillModelToJson(UserStateModel model) throws JSONException {
        JSONObject object = new JSONObject();
        object.put(ACTIVITY, (Object)"offline");
        object.put("userId", (Object)model.getUserId());
        Date date = new Date(model.getLastActivity());
        SimpleDateFormat ISO_8601_DATE_TIME = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        String lastActivityDate = ISO_8601_DATE_TIME.format(date);
        object.put("lastActivityDate", (Object)lastActivityDate);
        object.put(STATUS, (Object)model.getStatus());
        if (this.userService.isOnline(model.getUserId())) {
            object.put(ACTIVITY, (Object)"online");
        }
        return object;
    }

    @GET
    @Path(value="/status/{userId}/")
    @RolesAllowed(value={"users"})
    public Response getStatus(@PathParam(value="userId") String userId) throws JSONException {
        UserStateModel model = this.userService.getUserState(userId);
        if (model == null) {
            return Response.noContent().build();
        }
        JSONObject object = this.fillModelToJson(model);
        return Response.ok((Object)object.toString(), (String)"application/json").build();
    }

    @PUT
    @Path(value="/status/{userId}/")
    @RolesAllowed(value={"users"})
    @Deprecated
    public Response setStatus(@PathParam(value="userId") String userId, @QueryParam(value="status") String status) throws JSONException {
        String authenticated = ConversationState.getCurrent().getIdentity().getUserId();
        if (!authenticated.equals(userId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        UserStateModel model = this.userService.getUserState(userId);
        if (StringUtils.isNotEmpty((String)status)) {
            model.setStatus(status);
            this.userService.save(model);
            return Response.ok().build();
        }
        return Response.notModified().build();
    }

    @PUT
    @Path(value="/status")
    @RolesAllowed(value={"users"})
    public Response setStatus(@QueryParam(value="status") String status) throws JSONException {
        String authenticated = ConversationState.getCurrent().getIdentity().getUserId();
        UserStateModel model = this.userService.getUserState(authenticated);
        if (StringUtils.isNotEmpty((String)status)) {
            model.setStatus(status);
            this.userService.save(model);
            return Response.ok().build();
        }
        return Response.notModified().build();
    }
}

