/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service.storage;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NotificationIterator
implements Iterator<Node> {
    private static final Log LOG = ExoLogger.getLogger(NotificationIterator.class);
    private int offset;
    private int limit;
    private NodeIterator parentNotifIter;
    private NodeIterator notifIter;
    private WebNotificationFilter filter;

    public NotificationIterator(WebNotificationFilter filter, Node parentNode, int offset, int limit) {
        this.offset = offset;
        this.limit = limit;
        this.filter = filter;
        try {
            this.parentNotifIter = AbstractService.getNodeIteratorOrderDESC(parentNode);
            if (this.parentNotifIter.hasNext()) {
                this.notifIter = AbstractService.getNodeIteratorOrderDESC(this.parentNotifIter.nextNode());
            }
        }
        catch (RepositoryException e) {
            this.parentNotifIter = null;
        }
    }

    public NodeIterator getCurrentDateIterator() throws Exception {
        while (!this.notifIter.hasNext() && this.parentNotifIter.hasNext()) {
            this.notifIter = AbstractService.getNodeIteratorOrderDESC(this.parentNotifIter.nextNode());
        }
        return this.notifIter;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.getCurrentDateIterator().hasNext();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Node next() {
        return this.notifIter.nextNode();
    }

    @Override
    public void remove() {
    }

    public List<Node> nodes() {
        if (this.parentNotifIter == null) {
            return Collections.emptyList();
        }
        LinkedList<Node> nodes = new LinkedList<Node>();
        while (this.hasNext() && this.limit > 0) {
            Node node = this.next();
            try {
                if (this.filter.isOnPopover() && !node.getProperty("ntf:showPopover").getBoolean()) {
                    continue;
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"Failed to get value of property ntf:showPopover ", (Throwable)e);
            }
            if (this.offset > 0) {
                --this.offset;
                continue;
            }
            nodes.add(node);
            --this.limit;
        }
        return nodes;
    }
}

