/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import org.exoplatform.services.jcr.impl.util.ISO9075;

public class XPathUtils {
    public static String escapeIllegalXPathName(String path) {
        if (path == null) {
            return null;
        }
        if (path.length() == 0) {
            return "";
        }
        StringBuilder encoded = new StringBuilder();
        StringBuilder currentItem = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '/') {
                if (currentItem != null && currentItem.length() > 0) {
                    encoded.append(ISO9075.encode((String)currentItem.toString()));
                    currentItem = new StringBuilder();
                }
                encoded.append('/');
                continue;
            }
            currentItem.append(path.charAt(i));
        }
        if (currentItem != null && currentItem.length() > 0) {
            encoded.append(ISO9075.encode((String)currentItem.toString()));
        }
        return encoded.toString();
    }

    public static String escapeIllegalSQLName(String path) {
        return path == null || path.trim().length() == 0 ? path : path.replace("'", "''");
    }
}

