/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.cluster;

import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.cluster.StartableClusterAware;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class StartableClusterService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(StartableClusterService.class);
    private ExoContainer container;
    private SettingService settingService;
    private final Thread hook = new ShutdownThread();
    private static final Timer CLUSTER_AWARE_TIMER = new Timer("CLUSTER AWARE Timer", true);
    private TimerTask task;
    private static final String CLUSTER_NODE_NAME = "exo.cluster.node.name";
    private static final String CLUSTER_CHECK_PERIOD = "exo.cluster.startable.check.period";
    private static final String SETTING_LIFECYCLE = "setting";
    private static final String CLUSTER_SERVICE_SETTING_GLOBAL_KEY = "CLUSTER_SERVICE_CLUSTER_STARTABLE_SERVICE";
    private static Map<Object, Boolean> services = new HashMap<Object, Boolean>();
    private static final String nodeName;
    private static final boolean clusterEnabled;
    private static long checkPeriod;

    public StartableClusterService(InitParams initParams, ExoContainerContext containerContext, SettingService settingService) {
        this.container = containerContext.getContainer();
        this.settingService = settingService;
        if (initParams.getValueParam(CLUSTER_CHECK_PERIOD) != null) {
            checkPeriod = Long.parseLong(initParams.getValueParam(CLUSTER_CHECK_PERIOD).getValue());
        }
        if (clusterEnabled && (nodeName == null || nodeName.isEmpty())) {
            LOG.error((Object)"Cluster node name cannot be empty, exo.cluster.node.name should be configured");
            throw new IllegalArgumentException("Cluster node name cannot be empty");
        }
    }

    public void start() {
        for (ComponentAdapter componentAdapter : this.container.getComponentAdaptersOfType(StartableClusterAware.class)) {
            if (componentAdapter == null) continue;
            Object key = componentAdapter.getComponentKey();
            StartableClusterAware service = (StartableClusterAware)this.container.getComponentInstance(key);
            services.put(key, false);
            if (service.isDone() || !this.canStart(key)) continue;
            if (clusterEnabled) {
                LOG.info("Start service {} on node {} mode cluster aware ", new Object[]{key, nodeName});
            }
            service.start();
            services.put(key, true);
        }
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Runtime.getRuntime().addShutdownHook(StartableClusterService.this.hook);
                return null;
            }
        });
        if (clusterEnabled) {
            boolean initTimer = false;
            for (Object key : services.keySet()) {
                if (services.get(key).booleanValue()) continue;
                initTimer = true;
                break;
            }
            if (initTimer && !this.checkAllIsDone()) {
                this.task = new TimerTask(){

                    @Override
                    public void run() {
                        if (StartableClusterService.this.checkAllIsDone()) {
                            this.cancel();
                        }
                        for (Object key : services.keySet()) {
                            if (((Boolean)services.get(key)).booleanValue()) continue;
                            SettingValue serviceSetting = StartableClusterService.this.currentSetting(key.toString());
                            StartableClusterAware service = (StartableClusterAware)StartableClusterService.this.container.getComponentInstance(key);
                            if (serviceSetting == null || !((String)serviceSetting.getValue()).isEmpty() || service.isDone() || !StartableClusterService.this.canStart(key)) continue;
                            LOG.info("Start service {} on node {} mode cluster aware ", new Object[]{key, nodeName});
                            service.start();
                            services.put(key, true);
                        }
                    }
                };
                CLUSTER_AWARE_TIMER.schedule(this.task, 0L, checkPeriod);
            }
        }
    }

    public void stop() {
        this.resetSetting();
        for (ComponentAdapter componentAdapter : this.container.getComponentAdaptersOfType(StartableClusterAware.class)) {
            if (componentAdapter == null) continue;
            Object key = componentAdapter.getComponentKey();
            StartableClusterAware service = (StartableClusterAware)this.container.getComponentInstance(key);
            service.stop();
        }
    }

    private boolean canStart(Object key) {
        if (!clusterEnabled) {
            return true;
        }
        String name = this.getServiceSettings(key.toString(), nodeName);
        if (name == null) {
            LOG.error("Unable to get service setting {} ", new Object[]{key.toString()});
            return false;
        }
        return nodeName.equalsIgnoreCase(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getServiceSettings(String key, String defaultValue) {
        try {
            SettingValue<String> serviceSetting = this.currentSetting(key);
            if (serviceSetting != null && !((String)serviceSetting.getValue()).isEmpty()) {
                String string = (String)serviceSetting.getValue();
                return string;
            }
            this.updateServiceSettings(key, defaultValue);
            serviceSetting = this.currentSetting(key);
            String string = (String)serviceSetting.getValue();
            return string;
        }
        finally {
            Scope.GLOBAL.id(null);
        }
    }

    private SettingValue<String> currentSetting(String key) {
        return this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(CLUSTER_SERVICE_SETTING_GLOBAL_KEY), key);
    }

    private void updateServiceSettings(String key, String value) {
        try {
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(CLUSTER_SERVICE_SETTING_GLOBAL_KEY), key, SettingValue.create((String)value));
        }
        finally {
            RequestLifeCycle.end();
            Scope.GLOBAL.id(null);
        }
    }

    private void resetSetting() {
        for (Object key : services.keySet()) {
            SettingValue<String> serviceSetting = this.currentSetting(key.toString());
            if (serviceSetting == null || !((String)serviceSetting.getValue()).equalsIgnoreCase(nodeName)) continue;
            this.updateServiceSettings(key.toString(), "");
        }
    }

    private boolean checkAllIsDone() {
        for (Object key : services.keySet()) {
            StartableClusterAware service = (StartableClusterAware)this.container.getComponentInstance(key);
            if (service.isDone()) continue;
            return false;
        }
        return true;
    }

    static {
        checkPeriod = 120000L;
        nodeName = PropertyManager.getProperty((String)CLUSTER_NODE_NAME);
        clusterEnabled = PropertyManager.getProperty((String)"exo.profiles") != null ? PropertyManager.getProperty((String)"exo.profiles").contains("cluster") : false;
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        @Override
        public void run() {
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    StartableClusterService.this.resetSetting();
                    return null;
                }
            });
        }
    }
}

