/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service;

import java.util.GregorianCalendar;
import org.exoplatform.commons.api.notification.service.QueueMessage;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.notification.impl.jpa.email.JPAQueueMessageImpl;
import org.exoplatform.commons.notification.job.SendEmailNotificationJob;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.scheduler.PeriodInfo;
import org.picocontainer.Startable;
import org.quartz.JobDataMap;
import org.quartz.Trigger;

@Managed
@ManagedDescription(value="Mail Queue Massage service manager")
@NameTemplate(value={@Property(key="service", value="notification"), @Property(key="view", value="mailqueue")})
public class MailQueueMessageManager
implements ManagementAware,
Startable {
    private static final String SEND_EMAIL_NOTIFICATION_JOB_GROUP = "Notification";
    private static final String SEND_EMAIL_NOTIFICATION_JOB = "SendEmailNotificationJob";
    private static final String CACHE_REPO_NAME = "repositoryName";
    private static final Log LOG = ExoLogger.getExoLogger(MailQueueMessageManager.class);
    private boolean isOn = false;
    private long sentCounter = 0L;
    private long currentCapacity = 0L;
    private int emailPerSend = 0;
    private int interval = 120;
    private QueueMessage queueMessage;
    private SettingService settingService;
    private ListenerService listenerService;
    private Trigger defaultTrigger;
    private JobSchedulerService schedulerService;

    public MailQueueMessageManager(JPAQueueMessageImpl queueMessage) {
        this.queueMessage = queueMessage;
    }

    public void setContext(ManagementContext context) {
    }

    public void counter() {
        ++this.sentCounter;
    }

    public void addCurrentCapacity() {
        ++this.currentCapacity;
    }

    public void removeCurrentCapacity() {
        if (this.currentCapacity > 0L) {
            --this.currentCapacity;
        }
    }

    @Managed
    @ManagedDescription(value="Current mail service capacity should be available.")
    @Impact(value=ImpactType.READ)
    public long getCurrentCapacity() {
        return this.currentCapacity;
    }

    @Managed
    @ManagedDescription(value="Turn on the mail service.")
    @Impact(value=ImpactType.READ)
    public void on() {
        this.queueMessage.enable(true);
        this.resetCounter();
        this.isOn = true;
        this.makeJob(this.interval);
    }

    @Managed
    @ManagedDescription(value="Status of mail service. (true/false)")
    @Impact(value=ImpactType.READ)
    public boolean isOn() {
        return this.isOn;
    }

    @Managed
    @ManagedDescription(value="Turn off the mail service.")
    @Impact(value=ImpactType.READ)
    public String off() {
        this.queueMessage.enable(false);
        this.resetCounter();
        this.isOn = false;
        return this.resetDefaultConfigJob();
    }

    @Managed
    @ManagedDescription(value="Number emails sent")
    @Impact(value=ImpactType.READ)
    public long getSentCounter() {
        return this.sentCounter;
    }

    @Managed
    @ManagedDescription(value="Reset email countet.")
    @Impact(value=ImpactType.READ)
    public void resetCounter() {
        this.sentCounter = 0L;
    }

    @Managed
    @ManagedDescription(value="Set number emails send per one time.")
    @Impact(value=ImpactType.READ)
    public void setNumberEmailPerSend(int emailPerSend) {
        this.emailPerSend = emailPerSend;
        this.makeJob(this.interval);
    }

    @Managed
    @ManagedDescription(value="Number emails send per one time.")
    @Impact(value=ImpactType.READ)
    public int getNumberEmailPerSend() {
        return this.emailPerSend;
    }

    @Managed
    @ManagedDescription(value="Set period of time (in seconds) for each sending notification execution.")
    @Impact(value=ImpactType.READ)
    public void setInterval() {
        this.makeJob(this.interval);
    }

    @Managed
    @ManagedDescription(value="Get period of time (in seconds) for each sending notification execution.")
    @Impact(value=ImpactType.READ)
    public int getInterval() {
        return this.interval;
    }

    @Managed
    @ManagedDescription(value="Removes all notification data that stored in database.")
    @Impact(value=ImpactType.READ)
    public String resetTestMail() {
        this.currentCapacity = 0L;
        this.resetCounter();
        this.isOn = true;
        try {
            this.queueMessage.removeAll();
            return "Done";
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while removing all mail messages from queue", (Throwable)e);
            return "An error occurred while removing all mail messages from queue, cause : " + e.getMessage();
        }
    }

    @Managed
    @ManagedDescription(value="Removes all users setting that stored in database.")
    @Impact(value=ImpactType.READ)
    public String removeUsersSetting() {
        this.settingService.remove(Context.USER);
        return "Done";
    }

    public void start() {
        this.settingService = CommonsUtils.getService(SettingService.class);
        this.schedulerService = CommonsUtils.getService(JobSchedulerService.class);
        this.listenerService = CommonsUtils.getService(ListenerService.class);
        this.computeDefaultJobTrigger();
        this.addDefaultListeners();
    }

    public void stop() {
    }

    private String makeJob(int interval) {
        if (this.isOn) {
            if (interval > 0) {
                GregorianCalendar cal = new GregorianCalendar();
                try {
                    PeriodInfo periodInfo = new PeriodInfo(cal.getTime(), null, -1, (long)interval);
                    JobInfo info = new JobInfo(SEND_EMAIL_NOTIFICATION_JOB, SEND_EMAIL_NOTIFICATION_JOB_GROUP, SendEmailNotificationJob.class);
                    info.setDescription("Send email notification job.");
                    this.schedulerService.removeJob(info);
                    JobDataMap jdatamap = new JobDataMap();
                    jdatamap.put(CACHE_REPO_NAME, CommonsUtils.getRepository().getConfiguration().getName());
                    this.schedulerService.addPeriodJob(info, periodInfo, jdatamap);
                    LOG.debug((Object)("Job executes interval: " + interval));
                    return "done";
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while building new Email Queue processing Job information", (Throwable)e);
                    this.resetDefaultConfigJob();
                    return "An error occurred while building new Email Queue processing Job information";
                }
            }
            return "";
        }
        return "done";
    }

    private void addDefaultListeners() {
        this.listenerService.addListener("MESSAGE_ADDED_IN_QUEUE", (Listener)new Listener<QueueMessage, String>(){

            public void onEvent(Event<QueueMessage, String> event) throws Exception {
                MailQueueMessageManager.this.addCurrentCapacity();
            }
        });
        this.listenerService.addListener("MESSAGE_DELETED_FROM_QUEUE", (Listener)new Listener<QueueMessage, String>(){

            public void onEvent(Event<QueueMessage, String> event) throws Exception {
                MailQueueMessageManager.this.removeCurrentCapacity();
            }
        });
        this.listenerService.addListener("MESSAGE_SENT_FROM_QUEUE", (Listener)new Listener<QueueMessage, String>(){

            public void onEvent(Event<QueueMessage, String> event) throws Exception {
                if (MailQueueMessageManager.this.isOn()) {
                    MailQueueMessageManager.this.counter();
                }
            }
        });
    }

    private void computeDefaultJobTrigger() {
        try {
            Trigger[] triggersOfJob = this.schedulerService.getTriggersOfJob(SEND_EMAIL_NOTIFICATION_JOB, SEND_EMAIL_NOTIFICATION_JOB_GROUP);
            if (triggersOfJob != null && triggersOfJob.length > 0) {
                this.defaultTrigger = triggersOfJob[0];
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while getting default job 'SendEmailNotificationJob'  trigger details. Can't reset to default if job details modified", (Throwable)e);
        }
    }

    private String resetDefaultConfigJob() {
        if (this.isOn) {
            if (this.defaultTrigger != null) {
                try {
                    this.schedulerService.rescheduleJob(SEND_EMAIL_NOTIFICATION_JOB, SEND_EMAIL_NOTIFICATION_JOB_GROUP, this.defaultTrigger);
                }
                catch (Exception e) {
                    LOG.warn((Object)"Failed to reset default job 'SendEmailNotificationJob' trigger.", (Throwable)e);
                }
                return "done";
            }
            return "Can't reset to default. Default trigger information not found.";
        }
        return "done";
    }
}

