/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.jpa;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.persistence.DataInitializer;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.notification.NotificationConfiguration;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.notification.job.NotificationJob;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;

public class JPAUserSettingServiceImpl
extends AbstractService
implements UserSettingService {
    private static final Log LOG = ExoLogger.getLogger(JPAUserSettingServiceImpl.class);
    public static final Scope NOTIFICATION_SCOPE = Scope.APPLICATION.id("NOTIFICATION");
    public static final String NAME_PATTERN = "exo:{CHANNELID}Channel";
    private SettingService settingService;
    private ChannelManager channelManager;

    public JPAUserSettingServiceImpl(SettingService settingService, NotificationConfiguration configuration, ChannelManager channelManager, DataInitializer dataInitializer) {
        this.settingService = settingService;
        this.channelManager = channelManager;
    }

    public void save(UserSetting model) {
        String userId = model.getUserId();
        String dailys = NotificationUtils.listToString(model.getDailyPlugins(), "{VALUE}");
        String weeklys = NotificationUtils.listToString(model.getWeeklyPlugins(), "{VALUE}");
        String channelActives = NotificationUtils.listToString(model.getChannelActives(), "{VALUE}");
        Set channels = model.getAllChannelPlugins().keySet();
        for (String channelId : channels) {
            this.saveUserSetting(userId, NOTIFICATION_SCOPE, this.getChannelProperty(channelId), NotificationUtils.listToString(model.getPlugins(channelId), "{VALUE}"));
        }
        this.saveUserSetting(userId, NOTIFICATION_SCOPE, "exo:daily", dailys);
        this.saveUserSetting(userId, NOTIFICATION_SCOPE, "exo:weekly", weeklys);
        this.saveUserSetting(userId, NOTIFICATION_SCOPE, "exo:isActive", channelActives);
        if (model.getLastReadDate() > 0L) {
            this.saveLastReadDate(userId, model.getLastReadDate());
        }
        this.saveUserSetting(userId, Scope.GLOBAL, "exo:isEnabled", "" + model.isEnabled());
    }

    public void setUserEnabled(String username, boolean enabled) {
        this.saveUserSetting(username, Scope.GLOBAL, "exo:isEnabled", "" + enabled);
    }

    public UserSetting get(String userId) {
        UserSetting model = UserSetting.getDefaultInstance();
        model.setUserId(userId);
        Map userNotificationSettings = this.settingService.getSettingsByContext(Context.USER.id(userId));
        if (userNotificationSettings == null || userNotificationSettings.isEmpty()) {
            return model;
        }
        List channels = this.channelManager.getChannels();
        Map channelsByPropertyName = channels.stream().collect(Collectors.toMap(channel -> this.getChannelProperty(channel.getId()), Function.identity()));
        if (userNotificationSettings.containsKey(Scope.GLOBAL) && ((Map)userNotificationSettings.get(Scope.GLOBAL)).containsKey("exo:isEnabled")) {
            SettingValue enabledSetting = (SettingValue)((Map)userNotificationSettings.get(Scope.GLOBAL)).get("exo:isEnabled");
            model.setEnabled(enabledSetting == null ? true : Boolean.valueOf((String)enabledSetting.getValue()));
        } else {
            model.setEnabled(true);
        }
        if (userNotificationSettings.containsKey(NOTIFICATION_SCOPE)) {
            boolean cleared = false;
            Map notificationSettings = (Map)userNotificationSettings.get(NOTIFICATION_SCOPE);
            for (Map.Entry setting : notificationSettings.entrySet()) {
                String key = (String)setting.getKey();
                String value = (String)((SettingValue)setting.getValue()).getValue();
                if (StringUtils.isBlank((String)value)) continue;
                if ("exo:isActive".equals(key)) {
                    cleared = this.clearDefaultValue(model, cleared);
                    model.setChannelActives(this.getArrayListValue(value, model.getChannelActives()));
                    continue;
                }
                if ("exo:lastReadDate".equals(key)) {
                    model.setLastReadDate(Long.valueOf(Long.parseLong(value)).longValue());
                    continue;
                }
                if ("exo:daily".equals(key)) {
                    cleared = this.clearDefaultValue(model, cleared);
                    model.setDailyPlugins(this.getArrayListValue(value, model.getDailyPlugins()));
                    continue;
                }
                if ("exo:weekly".equals(key)) {
                    cleared = this.clearDefaultValue(model, cleared);
                    model.setWeeklyPlugins(this.getArrayListValue(value, model.getWeeklyPlugins()));
                    continue;
                }
                if (channelsByPropertyName.containsKey(key)) {
                    cleared = this.clearDefaultValue(model, cleared);
                    AbstractChannel channel2 = (AbstractChannel)channelsByPropertyName.get(key);
                    model.setChannelPlugins(channel2.getId(), this.getArrayListValue(value, new ArrayList<String>()));
                    continue;
                }
                if (PropertyManager.isDevelopping()) {
                    LOG.warn("A setting was found for user {}, but not considered", new Object[]{userId});
                    continue;
                }
                LOG.debug("A setting was found for user {}, but not considered", new Object[]{userId});
            }
        }
        return model;
    }

    private boolean clearDefaultValue(UserSetting model, boolean cleared) {
        if (!cleared) {
            model.getAllChannelPlugins().clear();
            model.getChannelActives().clear();
            model.getDailyPlugins().clear();
            model.getWeeklyPlugins().clear();
            cleared = true;
        }
        return cleared;
    }

    public void initDefaultSettings(String userName) {
        try {
            this.fillDefaultSettingsOfUser(userName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to init default settings for user " + userName), (Throwable)e);
        }
    }

    public void initDefaultSettings(User[] users) {
        for (User user : users) {
            String userName = user.getUserName();
            try {
                this.fillDefaultSettingsOfUser(userName);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to init default settings for user " + userName), (Throwable)e);
            }
        }
    }

    public List<UserSetting> getDigestSettingForAllUser(NotificationContext notificationContext, int offset, int limit) {
        ArrayList<UserSetting> models = new ArrayList<UserSetting>();
        Boolean isWeekly = (Boolean)notificationContext.value(NotificationJob.JOB_WEEKLY);
        String frequency = "exo:daily";
        if (isWeekly.booleanValue()) {
            frequency = "exo:weekly";
        }
        try {
            boolean continueSearching = true;
            while (models.size() < limit && continueSearching) {
                List contexts = this.settingService.getContextsByTypeAndScopeAndSettingName(Context.USER.getName(), NOTIFICATION_SCOPE.getName(), NOTIFICATION_SCOPE.getId(), frequency, offset, limit);
                continueSearching = contexts.size() == limit;
                for (Context context : contexts) {
                    String username = context.getId();
                    UserSetting userSetting = this.get(username);
                    if (!userSetting.isEnabled()) continue;
                    models.add(userSetting);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get all " + frequency + " users have notification messages"), (Throwable)e);
        }
        return models;
    }

    public List<UserSetting> getDigestDefaultSettingForAllUser(int offset, int limit) {
        ArrayList<UserSetting> users = new ArrayList<UserSetting>();
        try {
            Set userNames = this.settingService.getEmptyContextsByTypeAndScopeAndSettingName(Context.USER.getName(), NOTIFICATION_SCOPE.getName(), NOTIFICATION_SCOPE.getId(), "exo:daily", offset, limit);
            for (String userName : userNames) {
                users.add(new UserSetting().setUserId(userName).setLastUpdateTime(Calendar.getInstance()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get default daily users have notification messages", (Throwable)e);
        }
        return users;
    }

    public void saveLastReadDate(String userId, Long time) {
        this.settingService.set(Context.USER.id(userId), NOTIFICATION_SCOPE, "exo:lastReadDate", SettingValue.create((Long)time));
    }

    private String getChannelProperty(String channelId) {
        return NAME_PATTERN.replace("{CHANNELID}", channelId);
    }

    private void saveUserSetting(String userId, Scope scope, String key, String value) {
        this.settingService.set(Context.USER.id(userId), scope, key, SettingValue.create((String)value));
    }

    private List<String> getArrayListValue(String value, List<String> defaultValue) {
        if (StringUtils.isNotBlank((String)value) && !"false".equals(value)) {
            if ("true".equals(value)) {
                value = UserSetting.EMAIL_CHANNEL;
            }
            return NotificationUtils.stringToList(JPAUserSettingServiceImpl.getValues(value));
        }
        return defaultValue;
    }

    private void fillDefaultSettingsOfUser(String username) throws Exception {
        this.settingService.save(Context.USER.id(username));
    }
}

