/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.settings.rest.SettingEntity;
import org.exoplatform.settings.rest.SettingValueEntity;

@Path(value="/v1/settings")
@Api(tags={"/v1/settings"}, value="/v1/settings", description="Managing settings")
public class SettingResource
implements ResourceContainer {
    private SettingService settingService;
    private UserACL userACL;

    public SettingResource(SettingService settingService, UserACL userACL) {
        this.settingService = settingService;
        this.userACL = userACL;
    }

    @Path(value="/{context}/{scope}/{settingKey}")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a specific setting value", httpMethod="GET", response=Response.class, notes="This returns the requested setting value in the following cases: <br/><ul><li>the authenticated user is the super user</li><li>the requested setting is a setting of the authenticated user (Context=USER)</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User does not have permissions to get it"), @ApiResponse(code=404, message="Setting does not exist"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSetting(@ApiParam(value="Context - Format 'contextName,contextId' where 'contextId' is optional. Example: GLOBAL or USER,john", required=true) @PathParam(value="context") String contextParams, @ApiParam(value="Scope - Format 'scopeName,scopeId' where 'scopeId' is optional. Example: GLOBAL or APPLICATION,wiki or SPACE,marketing", required=true) @PathParam(value="scope") String scopeParams, @ApiParam(value="Setting key", required=true) @PathParam(value="settingKey") String settingKey) {
        if (StringUtils.isEmpty((String)contextParams) || StringUtils.isEmpty((String)scopeParams) || StringUtils.isEmpty((String)settingKey)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Context, scope and setting key are mandatory").build();
        }
        Context context = this.extractContext(contextParams);
        if (!this.hasPermissions(context)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Scope scope = this.extractScope(scopeParams);
        SettingValue settingValue = this.settingService.get(context, scope, settingKey);
        if (settingValue == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        SettingEntity settingEntity = new SettingEntity(context, scope, settingKey, settingValue.getValue().toString());
        return Response.ok((Object)settingEntity, (String)"application/json").build();
    }

    @Path(value="/{context}/{scope}/{settingKey}")
    @PUT
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Sets a specific setting value", httpMethod="PUT", response=Response.class, notes="This creates or updates the given setting value in the following cases: <br/><ul><li>the authenticated user is the super user</li><li>the given setting is a setting of the authenticated user (Context=USER)</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User does not have permissions to update it"), @ApiResponse(code=500, message="Internal server error")})
    public Response setSetting(@ApiParam(value="Context - Format 'contextName,contextId' where 'contextId' is optional. Example: GLOBAL or USER,john", required=true) @PathParam(value="context") String contextParams, @ApiParam(value="Scope - Format 'scopeName,scopeId' where 'scopeId' is optional. Example: GLOBAL or APPLICATION,wiki or SPACE,marketing", required=true) @PathParam(value="scope") String scopeParams, @ApiParam(value="Setting key", required=true) @PathParam(value="settingKey") String settingKey, @ApiParam(value="Setting value", required=true) SettingValueEntity settingValue) {
        if (StringUtils.isEmpty((String)contextParams) || StringUtils.isEmpty((String)scopeParams) || StringUtils.isEmpty((String)settingKey) || settingValue == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Context, scope and setting key and value are mandatory").build();
        }
        Context context = this.extractContext(contextParams);
        if (!this.hasPermissions(context)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Scope scope = this.extractScope(scopeParams);
        this.settingService.set(context, scope, settingKey, SettingValue.create((String)settingValue.getValue()));
        return Response.ok().build();
    }

    private boolean hasPermissions(Context context) {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (currentUser != null) {
            return context.getName().toUpperCase().equals(Context.USER.getName()) && (context.getId() == null || currentUser.equals(context.getId())) || currentUser.equals(this.userACL.getSuperUser());
        }
        return false;
    }

    private Scope extractScope(String scopeParams) {
        String scopeName = scopeParams;
        String scopeId = null;
        int scopeIndex = scopeParams.indexOf(",");
        if (scopeIndex > 0) {
            scopeName = scopeParams.substring(0, scopeIndex);
            scopeId = scopeParams.substring(scopeIndex + 1);
        }
        return new Scope(scopeName, scopeId);
    }

    private Context extractContext(String contextParams) {
        String contextName = contextParams;
        String contextId = null;
        int contextIndex = contextParams.indexOf(",");
        if (contextIndex > 0) {
            contextName = contextParams.substring(0, contextIndex);
            contextId = contextParams.substring(contextIndex + 1);
        }
        if (contextName.equals("GLOBAL")) {
            return Context.GLOBAL;
        }
        return new Context(contextName, contextId);
    }
}

