/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.persistence.impl;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.hibernate.TransactionException;

@Aspect
public class ExoTransactionalAspect {
    private static final Log LOG = ExoLogger.getLogger(ExoTransactionalAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ ExoTransactionalAspect ajc$perSingletonInstance;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Around(value="execution(* *(..)) && @annotation(org.exoplatform.commons.api.persistence.ExoTransactional)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.LOG.debug((Object)"Injecting new PersistenceContext");
            entityManager = service.createEntityManager();
            emStarted = true;
        } else {
            ExoTransactionalAspect.LOG.debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.LOG.debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.LOG.debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.LOG.warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    service.closeEntityManager();
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.LOG.warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = service.createEntityManager();
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            Object object = result = point.proceed();
            return object;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.LOG.error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.LOG.debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.LOG.debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.LOG.error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        service.closeEntityManager();
                    }
                }
            }
        }
    }

    static {
        try {
            ExoTransactionalAspect.ajc$perSingletonInstance = new ExoTransactionalAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static ExoTransactionalAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.exoplatform.commons.persistence.impl.ExoTransactionalAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

