/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.user;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.user.UserStateModel;

public class UserStateService {
    private static final Log LOG = ExoLogger.getLogger((String)UserStateService.class.getName());
    public static String DEFAULT_STATUS = "available";
    private static final String USER_STATE_CACHING_NAME = "commons.UserStateService";
    private static final int DEFAULT_OFFLINE_DELAY = 60000;
    private int delay = 60000;
    ExoCache<String, UserStateModel> userStateCache = null;

    public UserStateService(CacheService cacheService) {
        this.userStateCache = cacheService.getCacheInstance(USER_STATE_CACHING_NAME);
        String strDelay = System.getProperty("user.status.offline.delay");
        this.delay = NumberUtils.toInt((String)strDelay, (int)60000);
        this.delay = this.delay > 0 ? this.delay : 60000;
    }

    public int getDelay() {
        return this.delay;
    }

    public void save(UserStateModel model) {
        this.userStateCache.put((Serializable)((Object)model.getUserId()), (Object)model);
    }

    public UserStateModel getUserState(String userId) {
        if (StringUtils.isBlank((String)userId)) {
            throw new IllegalArgumentException("Parameter userId is mandatory");
        }
        UserStateModel model = this.getUserStateFromCache(userId);
        if (model != null) {
            model = model.clone();
        } else {
            ConversationState state = ConversationState.getCurrent();
            if (state == null || state.getIdentity() == null || state.getIdentity().getUserId() == null || !userId.equals(state.getIdentity().getUserId())) {
                return null;
            }
            model = this.ping(userId);
        }
        return model;
    }

    public UserStateModel ping(String userId) {
        if (userId == null || IdentityConstants.ANONIM.equals(userId)) {
            return null;
        }
        UserStateModel model = this.getUserStateFromCache(userId);
        long lastActivity = Calendar.getInstance().getTimeInMillis();
        if (model == null) {
            model = new UserStateModel(userId, lastActivity, DEFAULT_STATUS);
        } else {
            model.setLastActivity(lastActivity);
        }
        this.save(model);
        return model;
    }

    public List<UserStateModel> online() {
        LinkedList<UserStateModel> onlineUsers = new LinkedList<UserStateModel>();
        try {
            List users = this.userStateCache.getCachedObjects();
            Collections.sort(users, new LastActivityComparatorASC());
            for (UserStateModel userStateModel : users) {
                if (!this.isOnline(userStateModel)) continue;
                onlineUsers.add(userStateModel);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception when getting online user: {}", (Throwable)e);
        }
        return onlineUsers;
    }

    public boolean isOnline(String userId) {
        UserStateModel model = this.getUserState(userId);
        if (model != null) {
            return this.isOnline(model);
        }
        return false;
    }

    public UserStateModel lastLogin() {
        List<UserStateModel> online = this.online();
        if (online.size() > 0) {
            return online.get(online.size() - 1);
        }
        return null;
    }

    private UserStateModel getUserStateFromCache(String userId) {
        return (UserStateModel)this.userStateCache.get((Serializable)((Object)userId));
    }

    private boolean isOnline(UserStateModel model) {
        if (model != null) {
            long iDate = Calendar.getInstance().getTimeInMillis();
            if (model.getLastActivity() >= iDate - (long)this.delay) {
                return true;
            }
        }
        return false;
    }

    public static class LastActivityComparatorASC
    implements Comparator<UserStateModel> {
        @Override
        public int compare(UserStateModel u1, UserStateModel u2) {
            Long date1 = u1.getLastActivity();
            Long date2 = u2.getLastActivity();
            return date1.compareTo(date2);
        }
    }
}

