/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.job;

import java.util.concurrent.Callable;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.service.NotificationCompletionService;
import org.exoplatform.commons.notification.impl.NotificationSessionManager;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public abstract class NotificationJob
implements Job {
    protected static final Log LOG = ExoLogger.getLogger(NotificationJob.class);
    public static final ArgumentLiteral<Boolean> JOB_DAILY = new ArgumentLiteral(Boolean.class, "jobDaily");
    public static final ArgumentLiteral<String> DAY_OF_JOB = new ArgumentLiteral(String.class, "dayOfJob");
    public static final ArgumentLiteral<Boolean> JOB_WEEKLY = new ArgumentLiteral(Boolean.class, "jobWeekly");
    private ExoContainer container;

    public NotificationJob() {
        this((ExoContainer)PortalContainer.getInstance());
    }

    public NotificationJob(ExoContainer exoContainer) {
        this.container = exoContainer;
    }

    public void execute(final JobExecutionContext context) throws JobExecutionException {
        if (!this.isValid()) {
            return;
        }
        Callable<Boolean> task = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
                ExoContainerContext.setCurrentContainer((ExoContainer)NotificationJob.this.container);
                boolean created = NotificationSessionManager.createSystemProvider();
                try {
                    NotificationJob.this.processSendNotification(context);
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed to running NotificationJob", (Throwable)e);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    NotificationSessionManager.closeSessionProvider(created);
                    ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
                }
                return true;
            }
        };
        CommonsUtils.getService(NotificationCompletionService.class).addTask((Callable)task);
    }

    protected boolean isValid() {
        try {
            return CommonsUtils.getRepository().getState() != 0 && CommonsUtils.isFeatureActive("notification");
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get current repository", (Throwable)e);
            return false;
        }
    }

    protected void processSendNotification() throws Exception {
    }

    protected void processSendNotification(JobExecutionContext context) throws Exception {
        this.processSendNotification();
    }
}

