/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service.storage.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.notification.impl.service.storage.WebNotificationStorageImpl;
import org.exoplatform.commons.notification.impl.service.storage.cache.CacheKey;
import org.exoplatform.commons.notification.impl.service.storage.cache.CacheLoader;
import org.exoplatform.commons.notification.impl.service.storage.cache.FutureExoCache;
import org.exoplatform.commons.notification.impl.service.storage.cache.ServiceContext;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.IntegerData;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.ListWebNotificationsData;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.ListWebNotificationsKey;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.WebNotifInfoCacheKey;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.WebNotifInfoData;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;

public class CachedWebNotificationStorage
implements WebNotificationStorage {
    private static final String WEB_NOTIFICATION_CACHING_NAME = "commons.WebNotificationCache";
    private static final String LIST_WEB_NOTIFICATION_CACHING_NAME = "commons.WebNotificationsCache";
    private static final String WEB_NOTIFICATION_COUNT_CACHING_NAME = "commons.WebNotificationCountCache";
    private final ExoCache<WebNotifInfoCacheKey, WebNotifInfoData> exoWebNotificationCache;
    private final ExoCache<WebNotifInfoCacheKey, IntegerData> exoWebNotificationCountCache;
    private final ExoCache<ListWebNotificationsKey, ListWebNotificationsData> exoWebNotificationsCache;
    private FutureExoCache<WebNotifInfoCacheKey, WebNotifInfoData, ServiceContext<WebNotifInfoData>> futureWebNotificationCache;
    private FutureExoCache<ListWebNotificationsKey, ListWebNotificationsData, ServiceContext<ListWebNotificationsData>> futureWebNotificationsCache;
    private FutureExoCache<WebNotifInfoCacheKey, IntegerData, ServiceContext<IntegerData>> futureWebNotificationCountCache;
    private WebNotificationStorage storage;

    public CachedWebNotificationStorage(WebNotificationStorageImpl storage, CacheService cacheService) {
        this.storage = storage;
        this.exoWebNotificationCache = cacheService.getCacheInstance(WEB_NOTIFICATION_CACHING_NAME);
        this.exoWebNotificationsCache = cacheService.getCacheInstance(LIST_WEB_NOTIFICATION_CACHING_NAME);
        this.exoWebNotificationCountCache = cacheService.getCacheInstance(WEB_NOTIFICATION_COUNT_CACHING_NAME);
        this.futureWebNotificationCache = this.createFutureCache(this.exoWebNotificationCache);
        this.futureWebNotificationsCache = this.createFutureCache(this.exoWebNotificationsCache);
        this.futureWebNotificationCountCache = this.createFutureCache(this.exoWebNotificationCountCache);
    }

    public void save(NotificationInfo notification) {
        if (notification.isUpdate()) {
            this.storage.update(notification, true);
            WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notification.getId());
            this.exoWebNotificationCache.put((Serializable)key, (Object)new WebNotifInfoData(notification));
            this.clearWebNotificationCountCache(notification.getTo());
        } else {
            this.storage.save(notification);
            WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notification.getTo());
            IntegerData data = (IntegerData)this.exoWebNotificationCountCache.get((Serializable)key);
            if (data != null) {
                Integer current = (Integer)data.build();
                this.exoWebNotificationCountCache.put((Serializable)key, (Object)new IntegerData(current + 1));
            }
            this.exoWebNotificationCache.put((Serializable)WebNotifInfoCacheKey.key(notification.getId()), (Object)new WebNotifInfoData(notification));
        }
        this.clearUserWebNotificationList(notification.getTo());
    }

    public void update(NotificationInfo notification, boolean moveTop) {
        notification.setUpdate(true);
        notification.setResetOnBadge(!moveTop);
        this.storage.update(notification, moveTop);
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notification.getId());
        this.exoWebNotificationCache.put((Serializable)key, (Object)new WebNotifInfoData(notification));
        this.clearWebNotificationCountCache(notification.getTo());
        this.clearUserWebNotificationList(notification.getTo());
    }

    public void markRead(String notificationId) {
        this.storage.markRead(notificationId);
        this.updateRead(notificationId, true);
    }

    public void markAllRead(String userId) {
        this.storage.markAllRead(userId);
        this.updateCacheByUser(userId, true);
    }

    public void hidePopover(String notificationId) {
        this.storage.hidePopover(notificationId);
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notificationId);
        WebNotifInfoData infoData = (WebNotifInfoData)this.exoWebNotificationCache.get((Serializable)key);
        if (infoData != null) {
            infoData.updateShowPopover(false);
            this.exoWebNotificationCache.put((Serializable)key, (Object)infoData);
            this.clearWebNotificationCountCache(infoData.getTo());
            this.clearUserWebNotificationList(infoData.getTo());
        }
    }

    public List<NotificationInfo> get(final WebNotificationFilter filter, final int offset, final int limit) {
        final ListWebNotificationsKey key = ListWebNotificationsKey.key(filter.getUserId(), filter.isOnPopover(), offset, limit);
        ListWebNotificationsData keys = (ListWebNotificationsData)this.futureWebNotificationsCache.get(new ServiceContext<ListWebNotificationsData>(){

            @Override
            public ListWebNotificationsData execute() {
                List got = CachedWebNotificationStorage.this.storage.get(filter, offset, limit);
                return CachedWebNotificationStorage.this.buildWebNotifDataIds(key, got);
            }
        }, key);
        return this.buildNotifications(keys);
    }

    public boolean remove(String notificationId) {
        NotificationInfo notification = this.get(notificationId);
        if (notification == null) {
            return false;
        }
        this.storage.remove(notificationId);
        this.clearWebNotificationCache(notificationId);
        this.clearWebNotificationCountCache(notification.getTo());
        this.clearUserWebNotificationList(notification.getTo());
        return true;
    }

    public NotificationInfo get(final String notificationId) {
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notificationId);
        WebNotifInfoData notificationInfo = (WebNotifInfoData)this.futureWebNotificationCache.get(new ServiceContext<WebNotifInfoData>(){

            @Override
            public WebNotifInfoData execute() {
                try {
                    NotificationInfo got = CachedWebNotificationStorage.this.storage.get(notificationId);
                    if (got != null) {
                        return new WebNotifInfoData(got);
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, key);
        if (notificationInfo == null) {
            return null;
        }
        return notificationInfo.build();
    }

    public NotificationInfo getUnreadNotification(String pluginId, String activityId, String owner) {
        return this.storage.getUnreadNotification(pluginId, activityId, owner);
    }

    public boolean remove(String userId, long seconds) {
        this.clearWebNotificationCountCache(userId);
        this.updateCacheByUser(userId, false);
        return this.storage.remove(userId, seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(long seconds) {
        boolean removed = false;
        try {
            boolean bl = removed = this.storage.remove(seconds);
            return bl;
        }
        finally {
            if (removed) {
                this.exoWebNotificationCache.clearCache();
                this.exoWebNotificationCountCache.clearCache();
            }
        }
    }

    public int getNumberOnBadge(final String userId) {
        if (StringUtils.isNotBlank((String)userId)) {
            WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(userId);
            IntegerData numberOfMessageData = (IntegerData)this.futureWebNotificationCountCache.get(new ServiceContext<IntegerData>(){

                @Override
                public IntegerData execute() {
                    try {
                        int number = CachedWebNotificationStorage.this.storage.getNumberOnBadge(userId);
                        return new IntegerData(number);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, key);
            return (Integer)numberOfMessageData.build();
        }
        return 0;
    }

    public void resetNumberOnBadge(String userId) {
        this.storage.resetNumberOnBadge(userId);
        this.clearWebNotificationCountCache(userId);
    }

    public void setStorage(WebNotificationStorage storage) {
        this.storage = storage;
    }

    public void updateAllRead(String userId) throws Exception {
        this.updateCacheByUser(userId, true);
    }

    private void updateRead(String notificationId, boolean isRead) {
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notificationId);
        WebNotifInfoData infoData = (WebNotifInfoData)this.exoWebNotificationCache.get((Serializable)key);
        if (infoData != null) {
            infoData.updateRead(isRead);
            this.exoWebNotificationCache.put((Serializable)key, (Object)infoData);
        }
    }

    private void updateCacheByUser(String userId, boolean isUpdateRead) {
        if (!isUpdateRead) {
            this.clearUserWebNotificationList(userId);
            this.clearUserWebNotifications(userId);
        } else {
            this.updateReadForUserWebNotifications(userId);
        }
    }

    private void updateReadForUserWebNotifications(final String userId) {
        try {
            this.exoWebNotificationCache.select((CachedObjectSelector)new CachedObjectSelector<WebNotifInfoCacheKey, WebNotifInfoData>(){

                public boolean select(WebNotifInfoCacheKey key, ObjectCacheInfo<? extends WebNotifInfoData> ocinfo) {
                    return ocinfo.get() != null && userId.equals(((WebNotifInfoData)ocinfo.get()).getTo());
                }

                public void onSelect(ExoCache<? extends WebNotifInfoCacheKey, ? extends WebNotifInfoData> cache, WebNotifInfoCacheKey key, ObjectCacheInfo<? extends WebNotifInfoData> ocinfo) throws Exception {
                    ((WebNotifInfoData)ocinfo.get()).updateRead(true);
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't update Notification Cache entries for user " + userId, e);
        }
    }

    private void clearUserWebNotifications(final String userId) {
        try {
            this.exoWebNotificationCache.select((CachedObjectSelector)new CachedObjectSelector<WebNotifInfoCacheKey, WebNotifInfoData>(){

                public boolean select(WebNotifInfoCacheKey key, ObjectCacheInfo<? extends WebNotifInfoData> ocinfo) {
                    return ocinfo.get() != null && userId.equals(((WebNotifInfoData)ocinfo.get()).getTo());
                }

                public void onSelect(ExoCache<? extends WebNotifInfoCacheKey, ? extends WebNotifInfoData> cache, WebNotifInfoCacheKey key, ObjectCacheInfo<? extends WebNotifInfoData> ocinfo) throws Exception {
                    cache.remove((Serializable)key);
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't update Notifications List Cache entries for user " + userId, e);
        }
    }

    private void clearUserWebNotificationList(final String userId) {
        try {
            this.exoWebNotificationsCache.select((CachedObjectSelector)new CachedObjectSelector<ListWebNotificationsKey, ListWebNotificationsData>(){

                public boolean select(ListWebNotificationsKey key, ObjectCacheInfo<? extends ListWebNotificationsData> ocinfo) {
                    return userId.equals(key.getUserId());
                }

                public void onSelect(ExoCache<? extends ListWebNotificationsKey, ? extends ListWebNotificationsData> cache, ListWebNotificationsKey key, ObjectCacheInfo<? extends ListWebNotificationsData> ocinfo) throws Exception {
                    cache.remove((Serializable)key);
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't update Notification Cache entries for user " + userId, e);
        }
    }

    private ListWebNotificationsData getWebNotificationsData(ListWebNotificationsKey key) {
        ListWebNotificationsData data = (ListWebNotificationsData)this.exoWebNotificationsCache.get((Serializable)key);
        if (data == null) {
            data = new ListWebNotificationsData(key);
            this.exoWebNotificationsCache.put((Serializable)key, (Object)data);
        }
        return data;
    }

    private ListWebNotificationsData buildWebNotifDataIds(ListWebNotificationsKey key, List<NotificationInfo> notifications) {
        ListWebNotificationsData data = this.getWebNotificationsData(key);
        int len = notifications.size();
        for (int i = 0; i < len; ++i) {
            NotificationInfo notif = notifications.get(i);
            if (notif == null) continue;
            WebNotifInfoCacheKey webNotifKey = WebNotifInfoCacheKey.key(notif.getId());
            if (this.exoWebNotificationCache.get((Serializable)webNotifKey) == null) {
                this.exoWebNotificationCache.put((Serializable)webNotifKey, (Object)new WebNotifInfoData(notif));
            }
            if (data.contains(notif.getId())) continue;
            data.insertLast(notif.getId());
        }
        return data;
    }

    private List<NotificationInfo> buildNotifications(ListWebNotificationsData data) {
        ArrayList<NotificationInfo> notifications = new ArrayList<NotificationInfo>();
        for (String id : data.getList()) {
            NotificationInfo a = this.get(id);
            if (a == null) continue;
            notifications.add(a);
        }
        return notifications;
    }

    private void clearWebNotificationCountCache(String userId) {
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(userId);
        this.exoWebNotificationCountCache.remove((Serializable)key);
    }

    private void clearWebNotificationCache(String notificationId) {
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notificationId);
        this.exoWebNotificationCache.remove((Serializable)key);
    }

    private <K extends CacheKey, V extends Serializable> FutureExoCache<K, V, ServiceContext<V>> createFutureCache(ExoCache<K, V> cache) {
        return new FutureExoCache(new CacheLoader(), cache);
    }
}

