/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.impl;

import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;
import org.exoplatform.settings.jpa.CacheUserSettingServiceImpl;
import org.exoplatform.settings.jpa.JPAUserSettingServiceImpl;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CacheUserSettingTest {
    private static final String USER_ID = "demo";
    private CacheService cacheService;
    private JPAUserSettingServiceImpl userSettingServiceImpl;
    private CacheUserSettingServiceImpl cacheUserSettingServiceImpl;
    private UserSetting userSetting = new UserSetting();

    @Before
    public void setUp() throws Exception {
        this.cacheService = (CacheService)Mockito.mock(CacheService.class);
        this.userSettingServiceImpl = (JPAUserSettingServiceImpl)Mockito.mock(JPAUserSettingServiceImpl.class);
        this.userSetting.setUserId(USER_ID);
        Mockito.when((Object)this.cacheService.getCacheInstance("commons.UserSettingService")).thenReturn((Object)new ConcurrentFIFOExoCache());
        Mockito.when((Object)this.userSettingServiceImpl.get(USER_ID)).thenReturn((Object)this.userSetting);
        this.cacheUserSettingServiceImpl = new CacheUserSettingServiceImpl(this.cacheService, this.userSettingServiceImpl);
    }

    @Test
    public void testGetUserSetting() {
        this.cacheUserSettingServiceImpl.get(USER_ID);
        ((JPAUserSettingServiceImpl)Mockito.verify((Object)this.userSettingServiceImpl, (VerificationMode)Mockito.times((int)1))).get(USER_ID);
        this.cacheUserSettingServiceImpl.get(USER_ID);
        ((JPAUserSettingServiceImpl)Mockito.verify((Object)this.userSettingServiceImpl, (VerificationMode)Mockito.times((int)1))).get(USER_ID);
    }

    @Test
    public void testGetAndRemoveUserSetting() {
        this.cacheUserSettingServiceImpl.get(USER_ID);
        ((JPAUserSettingServiceImpl)Mockito.verify((Object)this.userSettingServiceImpl, (VerificationMode)Mockito.times((int)1))).get(USER_ID);
        this.cacheUserSettingServiceImpl.setUserEnabled(USER_ID, true);
        this.cacheUserSettingServiceImpl.get(USER_ID);
        ((JPAUserSettingServiceImpl)Mockito.verify((Object)this.userSettingServiceImpl, (VerificationMode)Mockito.times((int)2))).get(USER_ID);
    }

    @Test
    public void testGetAndSaveUserSetting() {
        this.cacheUserSettingServiceImpl.get(USER_ID);
        ((JPAUserSettingServiceImpl)Mockito.verify((Object)this.userSettingServiceImpl, (VerificationMode)Mockito.times((int)1))).get(USER_ID);
        this.cacheUserSettingServiceImpl.save(this.userSetting);
        this.cacheUserSettingServiceImpl.get(USER_ID);
        ((JPAUserSettingServiceImpl)Mockito.verify((Object)this.userSettingServiceImpl, (VerificationMode)Mockito.times((int)2))).get(USER_ID);
    }
}

