/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import org.exoplatform.commons.utils.HTMLSanitizer;
import org.junit.Assert;
import org.junit.Test;

public class HTMLSanitizerTest {
    @Test
    public void testEmpty() throws Exception {
        Assert.assertEquals((Object)"", (Object)HTMLSanitizer.sanitize((String)""));
        Assert.assertEquals((Object)"", (Object)HTMLSanitizer.sanitize(null));
    }

    @Test
    public void testEncodeImg() throws Exception {
        String input1 = "<img alt='crying' height='23' src='http://localhost:8080/CommonsResources/ckeditor/plugins/smiley/images/cry_smile.png' title='crying' width='23' onerror='alert('XSS')' onmousemove='alert('XSS1')'/>";
        Assert.assertEquals((Object)"<img alt=\"crying\" height=\"23\" src=\"http://localhost:8080/CommonsResources/ckeditor/plugins/smiley/images/cry_smile.png\" title=\"crying\" width=\"23\" />", (Object)HTMLSanitizer.sanitize((String)input1));
    }

    @Test
    public void testSanitizeRemovesScripts() throws Exception {
        String input = "<p>Hello World</p><script language=\"text/javascript\">alert(\"bad\");</script>";
        String sanitized = HTMLSanitizer.sanitize((String)input);
        Assert.assertEquals((Object)"<p>Hello World</p>", (Object)sanitized);
    }

    @Test
    public void testSanitizeRemovesOnclick() throws Exception {
        String input = "<p onclick=\"alert(\"bad\");\">Hello World</p>";
        String sanitized = HTMLSanitizer.sanitize((String)input);
        Assert.assertEquals((Object)"<p>Hello World</p>", (Object)sanitized);
    }

    @Test
    public void testTextAllowedInLinks() throws Exception {
        String input = "<a href=\"../good.html\">click here</a>";
        String sanitized = HTMLSanitizer.sanitize((String)input);
        Assert.assertEquals((Object)"<a href=\"../good.html\" rel=\"nofollow\">click here</a>", (Object)sanitized);
    }

    @Test
    public void testStarAllowedInImageLinks() throws Exception {
        String input = "https://cdn-images-1.medium.com/max/800/0*ssnGrTXEfHtQQ-tJ";
        String sanitized = HTMLSanitizer.sanitize((String)input);
        Assert.assertEquals((Object)input, (Object)sanitized);
    }

    @Test
    public void testDailymotionURLAllowedInIFrame() throws Exception {
        String input = "<iframe allow=\"fullscreen\" frameborder=\"0\" src=\"https://www.dailymotion.com/video/x7zyezo?playlist=x6pibu\"></iframe>";
        String sanitized = HTMLSanitizer.sanitize((String)input);
        sanitized = sanitized.replaceAll("&#61;", "=");
        Assert.assertEquals((Object)input, (Object)sanitized);
    }

    @Test
    public void testYouTubeURLAllowedInIFrame() throws Exception {
        String input = "<iframe allow=\"fullscreen\" frameborder=\"0\" src=\"https://www.youtube.com/embed/RLY9uVbuk3Q?autohide=1&amp;controls=1&amp;showinfo=0\"></iframe>";
        String sanitized = HTMLSanitizer.sanitize((String)input);
        sanitized = sanitized.replaceAll("&#61;", "=");
        Assert.assertEquals((Object)input, (Object)sanitized);
    }

    @Test
    public void testVimeoURLAllowedInIFrame() throws Exception {
        String input = "<iframe allow=\"fullscreen\" frameborder=\"0\" src=\"https://player.vimeo.com/video/243244233\"></iframe>";
        String sanitized = HTMLSanitizer.sanitize((String)input);
        sanitized = sanitized.replaceAll("&#61;", "=");
        Assert.assertEquals((Object)input, (Object)sanitized);
    }

    @Test
    public void testNotAllowedURLInIFrame() throws Exception {
        String input = "<iframe allow=\"fullscreen\" frameborder=\"0\" src=\"https://www.udemy.com/course/java-the-complete-java-developer-course/\"></iframe>";
        String sanitized = HTMLSanitizer.sanitize((String)input);
        Assert.assertEquals((Object)"<iframe allow=\"fullscreen\" frameborder=\"0\"></iframe>", (Object)sanitized);
    }
}

