/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.template;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.resources.impl.BaseResourceBundlePlugin;
import org.exoplatform.services.resources.impl.SimpleResourceBundleService;
import org.gatein.wci.WebApp;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppLifeCycleEvent;
import org.gatein.wci.WebAppListener;

public class ResourceBundleConfigDeployer
implements WebAppListener {
    private static final Log LOG = ExoLogger.getLogger(ResourceBundleConfigDeployer.class);
    private final ResourceBundleService bundleService = CommonsUtils.getService(ResourceBundleService.class);
    private static final String CONF_LOCATION = "/WEB-INF/classes/";
    private final Map<String, WebApp> contexts = new HashMap<String, WebApp>();

    public void onEvent(WebAppEvent event) {
        if (event instanceof WebAppLifeCycleEvent) {
            WebAppLifeCycleEvent lifeCycleEvent = (WebAppLifeCycleEvent)event;
            switch (lifeCycleEvent.getType()) {
                case 1: {
                    this.add(event.getWebApp());
                    break;
                }
                case 0: {
                    this.remove(event.getWebApp());
                }
            }
        }
    }

    private void remove(WebApp webApp) {
        this.contexts.remove(webApp.getContextPath());
    }

    private void add(WebApp webApp) {
        this.contexts.put(webApp.getContextPath(), webApp);
    }

    public void initBundlePath(Collection<String> list) {
        try {
            LocaleConfigService localeService_ = CommonsUtils.getService(LocaleConfigService.class);
            Collection locales = localeService_.getLocalConfigs();
            HashSet<String> includedWebApp = new HashSet<String>();
            HashSet<ResourceBundleFile> filePaths = new HashSet<ResourceBundleFile>();
            for (String path : list) {
                if (path == null || path.isEmpty()) continue;
                String string = this.getRealPathFile(path);
                for (LocaleConfig config : locales) {
                    filePaths.addAll(this.buildFilePath(path, string, config.getLocale()));
                }
            }
            HashMap<ResourceBundleFile, StringBuilder> resourceMap = new HashMap<ResourceBundleFile, StringBuilder>();
            for (WebApp webApp : this.contexts.values()) {
                for (ResourceBundleFile bundleFile : filePaths) {
                    String content = this.getResourceBundleContent(bundleFile.filePath, webApp.getServletContext());
                    if (content == null) continue;
                    StringBuilder sb = (StringBuilder)resourceMap.get(bundleFile);
                    if (sb == null) {
                        sb = new StringBuilder();
                        resourceMap.put(bundleFile, sb);
                    }
                    sb.append(content);
                    LOG.debug((Object)("Loading file path = " + bundleFile.filePath));
                }
            }
            for (Map.Entry entry : resourceMap.entrySet()) {
                ResourceBundleFile key = (ResourceBundleFile)entry.getKey();
                ResourceBundleData data = new ResourceBundleData(((StringBuilder)entry.getValue()).toString());
                data.setName(key.resourceName);
                data.setLanguage(key.locale.getLanguage());
                data.setCountry(key.locale.getCountry());
                data.setVariant(key.locale.getVariant());
                this.bundleService.saveResourceBundle(data);
                includedWebApp.add(key.resourceName);
                LOG.debug((Object)("Loading file path = " + key.filePath + " ResourceBundleData's ID = " + data.getId()));
            }
            for (String string : list) {
                if (includedWebApp.contains(string)) continue;
                this.addResourceBundleByPlugin(string);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Error when initializing resource bundle of Notification.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResourceBundleContent(String filePath, ServletContext servletContext) throws Exception {
        block9: {
            String string;
            String fileName = null;
            URL url = servletContext.getResource(filePath);
            if (url == null) break block9;
            InputStream is = url.openStream();
            try {
                byte[] buf = IOUtil.getStreamContentAsBytes((InputStream)is);
                string = new String(buf, "UTF-8");
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Failed close InputStream");
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new Exception("Error while reading the file: " + fileName, ex);
                }
            }
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Failed close InputStream");
            }
            return string;
        }
        return null;
    }

    private List<ResourceBundleFile> buildFilePath(String resourceName, String baseName, Locale locale) {
        ArrayList<ResourceBundleFile> candidateFiles = new ArrayList<ResourceBundleFile>();
        String language = locale.getLanguage();
        String country = locale.getCountry().toUpperCase();
        String variant = locale.getVariant();
        if (variant != null && variant.length() > 0) {
            candidateFiles.add(new ResourceBundleFile(resourceName, baseName + "_" + language + "_" + country + "_" + variant + ".properties", locale));
        }
        if (country != null && country.length() > 0) {
            candidateFiles.add(new ResourceBundleFile(resourceName, baseName + "_" + language + "_" + country + ".properties", locale));
        }
        if (language != null && language.length() > 0) {
            candidateFiles.add(new ResourceBundleFile(resourceName, baseName + "_" + language + ".properties", locale));
        }
        return candidateFiles;
    }

    private void addResourceBundleByPlugin(String path) {
        InitParams params = new InitParams();
        ValuesParam classPathParam = new ValuesParam();
        classPathParam.setName("classpath.resources");
        classPathParam.setValues(new ArrayList<String>(Arrays.asList(path)));
        params.addParameter((Parameter)classPathParam);
        ValuesParam portalParam = new ValuesParam();
        portalParam.setName("portal.resource.names");
        portalParam.setValues(new ArrayList<String>(Arrays.asList(path)));
        params.addParameter((Parameter)portalParam);
        BaseResourceBundlePlugin bundlePlugin = new BaseResourceBundlePlugin(params);
        ((SimpleResourceBundleService)this.bundleService).addResourceBundle(bundlePlugin);
    }

    private String getRealPathFile(String path) {
        return new StringBuffer(CONF_LOCATION).append(path.replace(".", "/")).toString();
    }

    private class ResourceBundleFile {
        final String resourceName;
        final String filePath;
        final Locale locale;

        public ResourceBundleFile(String resourceName, String filePath, Locale locale) {
            this.resourceName = resourceName;
            this.filePath = filePath;
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResourceBundleFile)) {
                return false;
            }
            ResourceBundleFile that = (ResourceBundleFile)o;
            return !(this.filePath != null ? !this.filePath.equals(that.filePath) : that.filePath != null);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.filePath != null ? this.filePath.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "filePath: " + this.filePath + ", resourceName: " + this.resourceName;
        }
    }
}

