/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.template;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.api.notification.template.Element;
import org.exoplatform.commons.api.notification.template.ElementVisitor;
import org.exoplatform.commons.api.notification.template.TemplateTransformer;
import org.exoplatform.commons.notification.template.SimpleTemplateTransformer;

public class SimpleElementVistior
implements ElementVisitor {
    private static final String BREAK_LINE = "<br/>";
    private final TemplateTransformer transformer = new SimpleTemplateTransformer();
    private final Writer writer = new StringWriter();
    private TemplateContext ctx;

    public static ElementVisitor instance() {
        return new SimpleElementVistior();
    }

    private SimpleElementVistior() {
    }

    public ElementVisitor visit(Element element) {
        String value = this.transformer.from(element.getTemplate()).transform(this.ctx);
        try {
            this.writer.append(value);
            if (element.isNewLine()) {
                this.writer.append(BREAK_LINE);
            }
        }
        catch (IOException e) {
            this.ctx.setException((Throwable)e);
        }
        return this;
    }

    public String out() {
        return this.writer.toString();
    }

    public ElementVisitor with(TemplateContext ctx) {
        this.ctx = ctx;
        return this;
    }

    public String toString() {
        return this.writer.toString();
    }

    public TemplateContext getTemplateContext() {
        return this.ctx;
    }

    public Writer getWriter() {
        return this.writer;
    }
}

