/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.Locale;
import java.util.TimeZone;
import org.exoplatform.commons.testing.BaseCommonsTestCase;
import org.exoplatform.commons.utils.DateUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.junit.Test;

public class DateUtilsTest
extends BaseCommonsTestCase {
    ExoContainer container = new ExoContainer();

    public void testGetTimeZone() {
        DateUtilsTest.assertEquals((Object)TimeZone.getTimeZone("GMT"), (Object)DateUtils.getTimeZone((String)"GMT"));
        DateUtilsTest.assertEquals((Object)TimeZone.getTimeZone("Africa/Tunis"), (Object)DateUtils.getTimeZone((String)"Africa/Tunis"));
        DateUtilsTest.assertEquals((Object)TimeZone.getTimeZone(""), (Object)DateUtils.getTimeZone((String)""));
        try {
            DateUtils.getTimeZone(null);
            DateUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetRelativeTimeLabel() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        try {
            DateUtilsTest.assertEquals((String)"less than a minute ago", (String)DateUtils.getRelativeTimeLabel((Locale)Locale.ENGLISH, (long)(System.currentTimeMillis() - 30L)));
            DateUtilsTest.assertEquals((String)"about a month ago", (String)DateUtils.getRelativeTimeLabel((Locale)Locale.ENGLISH, (long)(System.currentTimeMillis() - 3000000000L)));
            DateUtilsTest.assertEquals((String)"about 2 months ago", (String)DateUtils.getRelativeTimeLabel((Locale)Locale.ENGLISH, (long)(System.currentTimeMillis() - 7000000000L)));
            DateUtilsTest.assertEquals((String)"about 3 months ago", (String)DateUtils.getRelativeTimeLabel((Locale)Locale.ENGLISH, (long)(System.currentTimeMillis() - 10000000000L)));
        }
        catch (Exception e) {
            DateUtilsTest.fail((String)e.getMessage());
        }
    }
}

