/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.storage;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.notification.BaseNotificationTestCase;
import org.exoplatform.commons.notification.impl.service.storage.cache.CachedWebNotificationStorage;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.IntegerData;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.ListWebNotificationsData;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.ListWebNotificationsKey;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.WebNotifInfoCacheKey;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.WebNotifInfoData;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class CachedWebNotificationStorageTest
extends BaseNotificationTestCase {
    protected WebNotificationStorage cachedStorage;
    private static final String WEB_NOTIFICATION_CACHING_NAME = "commons.WebNotificationCache";
    private static final String LIST_WEB_NOTIFICATION_CACHING_NAME = "commons.WebNotificationsCache";
    private static final String WEB_NOTIFICATION_COUNT_CACHING_NAME = "commons.WebNotificationsCache";
    private CacheService cacheService;
    private ExoCache<ListWebNotificationsKey, ListWebNotificationsData> exoWebNotificationsCache;
    private ExoCache<WebNotifInfoCacheKey, WebNotifInfoData> exoWebNotificationCache;
    private ExoCache<WebNotifInfoCacheKey, IntegerData> exoWebNotificationCountCache;

    public CachedWebNotificationStorageTest() {
        this.setForceContainerReload(true);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.cachedStorage = (WebNotificationStorage)this.getService(WebNotificationStorage.class);
        this.cacheService = (CacheService)this.getService(CacheService.class);
        this.cacheService.getCacheInstance(WEB_NOTIFICATION_CACHING_NAME);
        this.exoWebNotificationCache = this.cacheService.getCacheInstance(WEB_NOTIFICATION_CACHING_NAME);
        this.exoWebNotificationsCache = this.cacheService.getCacheInstance("commons.WebNotificationsCache");
        this.exoWebNotificationCountCache = this.cacheService.getCacheInstance("commons.WebNotificationsCache");
        CachedWebNotificationStorageTest.assertTrue((boolean)(this.cachedStorage instanceof CachedWebNotificationStorage));
    }

    public void tearDown() throws Exception {
        this.exoWebNotificationCache.clearCache();
        this.exoWebNotificationsCache.clearCache();
        this.exoWebNotificationCountCache.clearCache();
        super.tearDown();
    }

    public void testSave() throws Exception {
        String userId = "demo";
        this.userIds.add(userId);
        NotificationInfo info = this.makeWebNotificationInfo(userId);
        this.cachedStorage.save(info);
        NotificationInfo notifInfo = this.cachedStorage.get(info.getId());
        CachedWebNotificationStorageTest.assertNotNull((Object)notifInfo);
        CachedWebNotificationStorageTest.assertEquals((int)1, (int)this.cachedStorage.get(new WebNotificationFilter(userId, false), 0, 10).size());
    }

    public void testGetNotifications() {
        int i;
        String userId = "demo";
        this.userIds.add(userId);
        List onPopoverInfos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 0, 10);
        onPopoverInfos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 0, 10);
        CachedWebNotificationStorageTest.assertEquals((int)0, (int)onPopoverInfos.size());
        for (i = 0; i < 2; ++i) {
            try {
                this.cachedStorage.save(this.makeWebNotificationInfo(userId));
                continue;
            }
            catch (Exception e) {
                CachedWebNotificationStorageTest.fail((Throwable)e);
            }
        }
        onPopoverInfos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 0, 10);
        onPopoverInfos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 0, 10);
        CachedWebNotificationStorageTest.assertEquals((int)2, (int)onPopoverInfos.size());
        for (i = 0; i < 20; ++i) {
            try {
                this.cachedStorage.save(this.makeWebNotificationInfo(userId));
                continue;
            }
            catch (Exception e) {
                CachedWebNotificationStorageTest.fail((Throwable)e);
            }
        }
        this.end();
        this.begin();
        onPopoverInfos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 5, 10);
        onPopoverInfos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 5, 10);
        CachedWebNotificationStorageTest.assertEquals((int)10, (int)onPopoverInfos.size());
        onPopoverInfos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 5, 15);
        onPopoverInfos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 5, 15);
        CachedWebNotificationStorageTest.assertEquals((int)15, (int)onPopoverInfos.size());
        onPopoverInfos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 0, 30);
        onPopoverInfos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 0, 30);
        CachedWebNotificationStorageTest.assertEquals((int)22, (int)onPopoverInfos.size());
    }

    public void testRemove() throws Exception {
        String userId = "demo";
        this.userIds.add(userId);
        NotificationInfo info = this.makeWebNotificationInfo(userId);
        this.cachedStorage.save(info);
        NotificationInfo notifInfo = this.cachedStorage.get(info.getId());
        CachedWebNotificationStorageTest.assertEquals((int)1, (int)this.cachedStorage.get(new WebNotificationFilter(userId, false), 0, 10).size());
        NotificationInfo info1 = this.makeWebNotificationInfo(userId);
        this.cachedStorage.save(info1);
        notifInfo = this.cachedStorage.get(info1.getId());
        CachedWebNotificationStorageTest.assertNotNull((Object)notifInfo);
        CachedWebNotificationStorageTest.assertEquals((int)2, (int)this.cachedStorage.get(new WebNotificationFilter(userId, false), 0, 10).size());
        CachedWebNotificationStorageTest.assertEquals((int)2, (int)this.cachedStorage.get(new WebNotificationFilter(userId, true), 0, 10).size());
        this.cachedStorage.remove(info1.getId());
        CachedWebNotificationStorageTest.assertNull((Object)this.cachedStorage.get(info1.getId()));
        CachedWebNotificationStorageTest.assertEquals((int)1, (int)this.cachedStorage.get(new WebNotificationFilter(userId, false), 0, 10).size());
        CachedWebNotificationStorageTest.assertEquals((int)1, (int)this.cachedStorage.get(new WebNotificationFilter(userId, true), 0, 10).size());
    }

    public void testRead() throws Exception {
        String userId = "demo";
        this.userIds.add(userId);
        NotificationInfo info = this.makeWebNotificationInfo(userId);
        this.cachedStorage.save(info);
        NotificationInfo notifInfo = this.cachedStorage.get(info.getId());
        CachedWebNotificationStorageTest.assertFalse((boolean)Boolean.valueOf(notifInfo.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())));
        this.cachedStorage.markRead(notifInfo.getId());
        notifInfo = this.cachedStorage.get(info.getId());
        CachedWebNotificationStorageTest.assertTrue((boolean)Boolean.valueOf(notifInfo.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())));
    }

    public void testMarkAllRead() throws Exception {
        String userId = "demo";
        this.userIds.add(userId);
        for (int i = 0; i < 10; ++i) {
            this.cachedStorage.save(this.makeWebNotificationInfo(userId));
        }
        List onPopoverInfos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 0, 10);
        CachedWebNotificationStorageTest.assertEquals((int)10, (int)onPopoverInfos.size());
        for (NotificationInfo notifInfo : onPopoverInfos) {
            CachedWebNotificationStorageTest.assertFalse((boolean)Boolean.valueOf(notifInfo.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())));
        }
        List viewAllInfos = this.cachedStorage.get(new WebNotificationFilter(userId, false), 0, 10);
        CachedWebNotificationStorageTest.assertEquals((int)10, (int)viewAllInfos.size());
        for (NotificationInfo notifInfo : viewAllInfos) {
            CachedWebNotificationStorageTest.assertFalse((boolean)Boolean.valueOf(notifInfo.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())));
        }
        this.cachedStorage.markAllRead(userId);
        onPopoverInfos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 0, 10);
        CachedWebNotificationStorageTest.assertEquals((int)10, (int)onPopoverInfos.size());
        for (NotificationInfo notifInfo : onPopoverInfos) {
            CachedWebNotificationStorageTest.assertTrue((boolean)Boolean.valueOf(notifInfo.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())));
        }
        viewAllInfos = this.cachedStorage.get(new WebNotificationFilter(userId, false), 0, 10);
        CachedWebNotificationStorageTest.assertEquals((int)10, (int)viewAllInfos.size());
        for (NotificationInfo notifInfo : viewAllInfos) {
            CachedWebNotificationStorageTest.assertTrue((boolean)Boolean.valueOf(notifInfo.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())));
        }
        for (NotificationInfo info : viewAllInfos) {
            WebNotifInfoCacheKey notifKey = WebNotifInfoCacheKey.key((String)info.getId());
            WebNotifInfoData notifData = (WebNotifInfoData)this.exoWebNotificationCache.get((Serializable)notifKey);
            NotificationInfo notifInfo = notifData.build();
            CachedWebNotificationStorageTest.assertTrue((boolean)Boolean.valueOf(notifInfo.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())));
        }
    }

    public void testHidePopover() {
        String userId = "demo";
        this.userIds.add(userId);
        NotificationInfo info = this.makeWebNotificationInfo(userId);
        try {
            this.cachedStorage.save(info);
        }
        catch (Exception e) {
            CachedWebNotificationStorageTest.fail((Throwable)e);
        }
        NotificationInfo notifInfo = this.cachedStorage.get(info.getId());
        CachedWebNotificationStorageTest.assertTrue((boolean)notifInfo.isOnPopOver());
        List infos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 0, 10);
        ListWebNotificationsKey key = ListWebNotificationsKey.key((String)userId, (boolean)true, (int)0, (int)10);
        ListWebNotificationsData listData = (ListWebNotificationsData)this.exoWebNotificationsCache.get((Serializable)key);
        CachedWebNotificationStorageTest.assertNotNull((Object)listData);
        CachedWebNotificationStorageTest.assertEquals((int)1, (int)listData.size());
        infos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 0, 10);
        CachedWebNotificationStorageTest.assertEquals(infos.get(0), (Object)notifInfo);
        CachedWebNotificationStorageTest.assertTrue((boolean)((NotificationInfo)infos.get(0)).isOnPopOver());
        this.cachedStorage.hidePopover(notifInfo.getId());
        WebNotifInfoCacheKey notifKey = WebNotifInfoCacheKey.key((String)notifInfo.getId());
        WebNotifInfoData notifData = (WebNotifInfoData)this.exoWebNotificationCache.get((Serializable)notifKey);
        notifInfo = notifData.build();
        CachedWebNotificationStorageTest.assertFalse((boolean)notifInfo.isOnPopOver());
    }

    public void testUpdate() throws Exception {
        String userId = "mary";
        this.userIds.add(userId);
        NotificationInfo info = this.makeWebNotificationInfo(userId);
        this.cachedStorage.save(info);
        NotificationInfo createdFirstInfo = this.cachedStorage.get(info.getId());
        CachedWebNotificationStorageTest.assertEquals((String)info.getTitle(), (String)createdFirstInfo.getTitle());
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(1L);
            this.cachedStorage.save(this.makeWebNotificationInfo(userId));
        }
        this.end();
        this.begin();
        List onPopoverInfos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 0, 10);
        CachedWebNotificationStorageTest.assertEquals((int)6, (int)onPopoverInfos.size());
        List viewAllInfos = this.cachedStorage.get(new WebNotificationFilter(userId, false), 0, 10);
        CachedWebNotificationStorageTest.assertEquals((int)6, (int)viewAllInfos.size());
        NotificationInfo lastOnPopoverInfo = (NotificationInfo)onPopoverInfos.get(onPopoverInfos.size() - 1);
        CachedWebNotificationStorageTest.assertEquals((String)createdFirstInfo.getId(), (String)lastOnPopoverInfo.getId());
        NotificationInfo lastViewAllInfos = (NotificationInfo)viewAllInfos.get(viewAllInfos.size() - 1);
        CachedWebNotificationStorageTest.assertEquals((String)createdFirstInfo.getId(), (String)lastViewAllInfos.getId());
        String newTitle = "The new title";
        createdFirstInfo.setTitle(newTitle);
        this.cachedStorage.update(createdFirstInfo, true);
        this.end();
        this.begin();
        createdFirstInfo = this.cachedStorage.get(info.getId());
        CachedWebNotificationStorageTest.assertEquals((String)newTitle, (String)createdFirstInfo.getTitle());
        onPopoverInfos = this.cachedStorage.get(new WebNotificationFilter(userId, true), 0, 10);
        viewAllInfos = this.cachedStorage.get(new WebNotificationFilter(userId, false), 0, 10);
        NotificationInfo firstOnPopoverInfo = (NotificationInfo)onPopoverInfos.get(0);
        CachedWebNotificationStorageTest.assertEquals((String)newTitle, (String)firstOnPopoverInfo.getTitle());
        NotificationInfo firstViewAllInfos = (NotificationInfo)viewAllInfos.get(0);
        CachedWebNotificationStorageTest.assertEquals((String)newTitle, (String)firstViewAllInfos.getTitle());
        this.cachedStorage.resetNumberOnBadge(userId);
        int num = this.cachedStorage.getNumberOnBadge(userId);
        CachedWebNotificationStorageTest.assertEquals((int)0, (int)num);
        this.cachedStorage.update(createdFirstInfo, false);
        num = this.cachedStorage.getNumberOnBadge(userId);
        CachedWebNotificationStorageTest.assertEquals((int)0, (int)num);
        this.cachedStorage.update(createdFirstInfo, true);
        num = this.cachedStorage.getNumberOnBadge(userId);
        CachedWebNotificationStorageTest.assertEquals((int)1, (int)num);
    }

    public void testRemoveByJob() throws Exception {
        int daySeconds = 86400;
        String userId = "demo";
        Calendar cal = Calendar.getInstance();
        long t = (long)daySeconds * 1000L;
        long current = cal.getTimeInMillis();
        for (int i = 12; i > 3; i -= 2) {
            cal.setTimeInMillis(current - (long)i * t);
            for (int j = 0; j < 10; ++j) {
                NotificationInfo notifInfi = this.makeWebNotificationInfo(userId);
                NotificationInfo info = notifInfi.setDateCreated(cal);
                notifInfi.setLastModifiedDate(cal);
                this.cachedStorage.save(info);
            }
        }
        List info = this.cachedStorage.get(new WebNotificationFilter(userId, false), 0, 60);
        CachedWebNotificationStorageTest.assertEquals((int)50, (int)info.size());
        this.cachedStorage.remove(userId, (long)(9 * daySeconds));
        info = this.cachedStorage.get(new WebNotificationFilter(userId, false), 0, 60);
        CachedWebNotificationStorageTest.assertEquals((int)30, (int)info.size());
        this.cachedStorage.remove(userId, (long)(3 * daySeconds));
        info = this.cachedStorage.get(new WebNotificationFilter(userId, false), 0, 60);
        CachedWebNotificationStorageTest.assertEquals((int)0, (int)info.size());
    }

    public void testGetNewMessage() throws Exception {
        CachedWebNotificationStorageTest.assertEquals((int)8, (int)NotificationMessageUtils.getMaxItemsInPopover());
        String userId = "root";
        this.userIds.add(userId);
        CachedWebNotificationStorageTest.assertEquals((int)0, (int)this.cachedStorage.getNumberOnBadge(userId));
        this.cachedStorage.save(this.makeWebNotificationInfo(userId));
        CachedWebNotificationStorageTest.assertEquals((int)1, (int)this.cachedStorage.getNumberOnBadge(userId));
        this.cachedStorage.save(this.makeWebNotificationInfo(userId));
        CachedWebNotificationStorageTest.assertEquals((int)2, (int)this.cachedStorage.getNumberOnBadge(userId));
        for (int i = 0; i < 10; ++i) {
            this.cachedStorage.save(this.makeWebNotificationInfo(userId));
        }
        List list = this.cachedStorage.get(new WebNotificationFilter(userId), 0, 15);
        CachedWebNotificationStorageTest.assertEquals((int)12, (int)list.size());
        CachedWebNotificationStorageTest.assertEquals((int)12, (int)this.cachedStorage.getNumberOnBadge(userId));
        this.cachedStorage.resetNumberOnBadge(userId);
        CachedWebNotificationStorageTest.assertEquals((int)0, (int)this.cachedStorage.getNumberOnBadge(userId));
    }
}

