/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import org.exoplatform.commons.testing.BaseCommonsTestCase;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.mockito.Mockito;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

public class UserStateServiceTest
extends BaseCommonsTestCase {
    private String SUPER_USER = "root";
    private EXoContinuationBayeux eXoContinuationBayeux;
    private UserStateService userStateService;

    public void setUp() throws Exception {
        super.setUp();
        this.loginUser(this.SUPER_USER, false);
        this.eXoContinuationBayeux = (EXoContinuationBayeux)Mockito.mock(EXoContinuationBayeux.class);
        this.userStateService = new UserStateService(this.eXoContinuationBayeux, (CacheService)this.getService(CacheService.class));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.userStateService.clearCache();
    }

    public void testGetUserState() throws Exception {
        this.loginUser("mary", true);
        Mockito.when((Object)this.eXoContinuationBayeux.isPresent("mary")).thenReturn((Object)true);
        UserStateServiceTest.assertEquals((String)"available", (String)this.userStateService.getUserState("mary").getStatus());
        this.loginUser("demo", false);
        Mockito.when((Object)this.eXoContinuationBayeux.isPresent("demo")).thenReturn((Object)true);
        UserStateServiceTest.assertEquals((String)"available", (String)this.userStateService.getUserState("demo").getStatus());
        UserStateServiceTest.assertEquals((String)"available", (String)this.userStateService.getUserState("mary").getStatus());
        Mockito.when((Object)this.eXoContinuationBayeux.isPresent("demo")).thenReturn((Object)false);
        UserStateServiceTest.assertEquals((String)"offline", (String)this.userStateService.getUserState("demo").getStatus());
    }

    public void testOnline() throws Exception {
        long date = new Date().getTime();
        UserStateModel userModel = new UserStateModel(this.SUPER_USER, date, "offline");
        this.userStateService.save(userModel);
        Mockito.when((Object)this.eXoContinuationBayeux.getConnectedUserIds()).thenReturn(Collections.singleton(this.SUPER_USER));
        List onlines = this.userStateService.online();
        UserStateServiceTest.assertEquals((int)0, (int)onlines.size());
        String status = "doNotDisturb";
        this.userStateService.saveStatus(this.SUPER_USER, status);
        onlines = this.userStateService.online();
        UserStateServiceTest.assertEquals((int)1, (int)onlines.size());
        UserStateServiceTest.assertEquals((String)this.SUPER_USER, (String)((UserStateModel)onlines.get(0)).getUserId());
        UserStateServiceTest.assertNotNull((Object)((UserStateModel)onlines.get(0)).getLastActivity());
        UserStateServiceTest.assertEquals((String)status, (String)((UserStateModel)onlines.get(0)).getStatus());
    }

    public void testLastLogin() {
        UserStateServiceTest.assertNull((Object)this.userStateService.lastLogin());
        this.loginUser("user1", true);
        Mockito.when((Object)this.eXoContinuationBayeux.getConnectedUserIds()).thenReturn(Collections.singleton("user1"));
        UserStateServiceTest.assertEquals((String)"user1", (String)this.userStateService.lastLogin().getUserId());
        this.loginUser("user2", true);
        Mockito.when((Object)this.eXoContinuationBayeux.getConnectedUserIds()).thenReturn(new LinkedHashSet<String>(Arrays.asList("user1", "user2")));
        UserStateServiceTest.assertEquals((String)"user2", (String)this.userStateService.lastLogin().getUserId());
    }

    public void testIsOnline() throws Exception {
        Mockito.when((Object)this.eXoContinuationBayeux.isPresent(this.SUPER_USER)).thenReturn((Object)true);
        UserStateServiceTest.assertTrue((boolean)this.userStateService.isOnline(this.SUPER_USER));
        UserStateServiceTest.assertFalse((boolean)this.userStateService.isOnline("demo"));
        Mockito.when((Object)this.eXoContinuationBayeux.isPresent("demo")).thenReturn((Object)true);
        UserStateServiceTest.assertTrue((boolean)this.userStateService.isOnline("demo"));
    }

    private void loginUser(String userId, boolean hasPing) {
        ArrayList<MembershipEntry> membershipEntries = new ArrayList<MembershipEntry>();
        MembershipEntry membershipEntry = new MembershipEntry("/platform/administrators", "*");
        membershipEntries.add(membershipEntry);
        Identity identity = new Identity(userId, membershipEntries);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
        if (hasPing) {
            this.userStateService.saveStatus(userId, "available");
        }
    }
}

