/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.template;

import groovy.lang.Writable;
import groovy.text.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationChildPlugin;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationPlugin;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.service.setting.PluginContainer;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.api.notification.template.Element;
import org.exoplatform.commons.api.notification.template.ElementVisitor;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GroovyElementVisitor
implements ElementVisitor {
    private static final Log LOG = ExoLogger.getLogger(GroovyElementVisitor.class);
    private final Writer writer = new StringWriter();
    private TemplateContext ctx;

    public ElementVisitor visit(Element element) {
        try {
            Template engine = null;
            PluginKey pluginKey = new PluginKey(this.ctx.getPluginId());
            BaseNotificationPlugin plugin = CommonsUtils.getService(PluginContainer.class).getPlugin(pluginKey);
            if (plugin instanceof AbstractNotificationChildPlugin) {
                engine = ((AbstractNotificationChildPlugin)plugin).getTemplateEngine();
            } else if (plugin.isOldPlugin()) {
                engine = ((AbstractNotificationPlugin)plugin).getTemplateEngine();
            } else {
                AbstractChannel channel = CommonsUtils.getService(ChannelManager.class).getChannel(this.ctx.getChannelKey());
                AbstractTemplateBuilder builder = channel.getTemplateBuilder(pluginKey);
                if (builder != null) {
                    engine = builder.getTemplateEngine();
                }
            }
            if (engine != null) {
                this.ctx.put((Object)"_ctx", (Object)element);
                this.ctx.put((Object)"_writer", (Object)this.writer);
                this.ctx.put((Object)"_templateContext", (Object)this.ctx);
                Writable writable = engine.make((Map)this.getTemplateContext());
                writable.writeTo(this.writer);
            }
        }
        catch (Exception e) {
            this.ctx.setException((Throwable)e);
            LOG.error((Object)"Failed at visit().", (Throwable)e);
        }
        return this;
    }

    public String out() {
        return this.writer.toString();
    }

    public TemplateContext getTemplateContext() {
        return this.ctx;
    }

    public ElementVisitor with(TemplateContext ctx) {
        this.ctx = ctx;
        return this;
    }

    public Writer getWriter() {
        return this.writer;
    }
}

