/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jpa.settings.impl;

import java.util.List;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.jpa.BaseTest;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.settings.jpa.JPAUserSettingServiceImpl;

public class JPAUserSettingServiceTest
extends BaseTest {
    protected static JPAUserSettingServiceImpl userSettingService;
    protected static OrganizationService organizationService;

    @Override
    public void setUp() {
        super.setUp();
        userSettingService = this.getService(JPAUserSettingServiceImpl.class);
        organizationService = this.getService(OrganizationService.class);
    }

    @Override
    protected void tearDown() {
        for (int i = 0; i < 10; ++i) {
            try {
                organizationService.getUserHandler().removeUser("userTest_" + i, false);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.tearDown();
    }

    public void test_1_GetDefautSetting() throws Exception {
        List list = userSettingService.getDigestDefaultSettingForAllUser(0, 0);
        int originalSize = list.size();
        for (int i = 0; i < 10; ++i) {
            UserImpl user = new UserImpl("userTest_" + i);
            organizationService.getUserHandler().createUser((User)user, false);
            userSettingService.initDefaultSettings(user.getUserName());
        }
        list = userSettingService.getDigestDefaultSettingForAllUser(0, 5);
        JPAUserSettingServiceTest.assertEquals((int)5, (int)list.size());
        list = userSettingService.getDigestDefaultSettingForAllUser(0, 0);
        JPAUserSettingServiceTest.assertEquals((int)(10 + originalSize), (int)list.size());
    }

    public void testDisabledUser() throws Exception {
        User u = ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler().createUserInstance("binh");
        u.setEmail("email@test");
        u.setFirstName("first");
        u.setLastName("last");
        u.setPassword("pwdADDSomeSaltToBeCompliantWithSomeIS00");
        ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler().createUser(u, true);
        userSettingService.save(this.createUserSetting("binh", null, null, null));
        UserSetting userSetting = userSettingService.get("binh");
        JPAUserSettingServiceTest.assertTrue((boolean)userSetting.isEnabled());
        JPAUserSettingServiceTest.assertTrue((boolean)userSetting.isChannelActive("MAIL_CHANNEL"));
        ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler().setEnabled("binh", false, true);
        userSetting = userSettingService.get("binh");
        JPAUserSettingServiceTest.assertTrue((boolean)userSetting.isChannelActive("MAIL_CHANNEL"));
        JPAUserSettingServiceTest.assertFalse((boolean)userSetting.isEnabled());
        ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler().setEnabled("binh", true, true);
        userSetting = userSettingService.get("binh");
        JPAUserSettingServiceTest.assertTrue((boolean)userSetting.isChannelActive("MAIL_CHANNEL"));
        JPAUserSettingServiceTest.assertTrue((boolean)userSetting.isEnabled());
        ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler().removeUser("binh", false);
        JPAUserSettingServiceTest.assertNull((Object)((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler().findUserByName("binh"));
    }

    private UserSetting createUserSetting(String userId, List<String> instantly, List<String> daily, List<String> weekly) {
        UserSetting model = new UserSetting();
        model.setUserId(userId);
        model.setChannelActive(UserSetting.EMAIL_CHANNEL);
        model.setDailyPlugins(daily);
        model.setChannelPlugins(UserSetting.EMAIL_CHANNEL, instantly);
        model.setWeeklyPlugins(weekly);
        return model;
    }
}

