/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jpa.notifications.web.dao;

import java.util.Calendar;
import org.exoplatform.commons.notification.impl.jpa.web.entity.WebNotifEntity;
import org.exoplatform.commons.notification.impl.jpa.web.entity.WebParamsEntity;
import org.exoplatform.commons.notification.impl.jpa.web.entity.WebUsersEntity;
import org.exoplatform.commons.persistence.impl.EntityManagerHolder;
import org.exoplatform.jpa.CommonsDAOJPAImplTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class WebUsersDAOTest
extends CommonsDAOJPAImplTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.webUsersDAO.deleteAll();
        this.webParamsDAO.deleteAll();
        this.webNotifDAO.deleteAll();
    }

    @Override
    @After
    public void tearDown() {
        this.webUsersDAO.deleteAll();
        this.webParamsDAO.deleteAll();
        this.webNotifDAO.deleteAll();
    }

    @Test
    public void testFindWebNotifsByFilter() {
        WebNotifEntity webNotifEntity1 = new WebNotifEntity();
        webNotifEntity1.setType("plugin1");
        webNotifEntity1.setCreationDate(Calendar.getInstance());
        webNotifEntity1 = (WebNotifEntity)this.webNotifDAO.create((Object)webNotifEntity1);
        WebUsersEntity webUsersEntity1 = new WebUsersEntity();
        webUsersEntity1.setShowPopover(true);
        webUsersEntity1.setRead(false);
        webUsersEntity1.setReceiver("user1");
        webUsersEntity1.setNotification(webNotifEntity1);
        webUsersEntity1.setUpdateDate(Calendar.getInstance());
        webUsersEntity1 = (WebUsersEntity)this.webUsersDAO.create((Object)webUsersEntity1);
        EntityManagerHolder.get().clear();
        WebUsersDAOTest.assertEquals((int)1, (int)this.webUsersDAO.findWebNotifsByFilter("plugin1", "user1", Boolean.valueOf(true), 0, 10).size());
        WebUsersDAOTest.assertEquals((int)0, (int)this.webUsersDAO.findWebNotifsByFilter("plugin2", "user1", Boolean.valueOf(true), 0, 10).size());
        WebNotifEntity webNotifEntity2 = new WebNotifEntity();
        webNotifEntity2.setType("plugin2");
        webNotifEntity2.setCreationDate(Calendar.getInstance());
        webNotifEntity2 = (WebNotifEntity)this.webNotifDAO.create((Object)webNotifEntity2);
        WebUsersEntity webUsersEntity2 = new WebUsersEntity();
        webUsersEntity2.setShowPopover(true);
        webUsersEntity2.setRead(true);
        webUsersEntity2.setReceiver("user1");
        webUsersEntity2.setNotification(webNotifEntity2);
        webUsersEntity2.setUpdateDate(Calendar.getInstance());
        webUsersEntity2 = (WebUsersEntity)this.webUsersDAO.create((Object)webUsersEntity2);
        EntityManagerHolder.get().clear();
        WebUsersDAOTest.assertEquals((int)1, (int)this.webUsersDAO.findWebNotifsByFilter("plugin2", "user1", Boolean.valueOf(true), 0, 10).size());
        WebUsersDAOTest.assertEquals((int)0, (int)this.webUsersDAO.findWebNotifsByFilter("plugin1", "user2", Boolean.valueOf(true), 0, 10).size());
        WebUsersDAOTest.assertEquals((int)0, (int)this.webUsersDAO.findWebNotifsByFilter("plugin1", "user2", Boolean.valueOf(false), 0, 10).size());
        WebUsersDAOTest.assertEquals((int)2, (int)this.webUsersDAO.findWebNotifsByFilter("user1", 0, 10).size());
        WebUsersDAOTest.assertEquals((int)2, (int)this.webUsersDAO.findWebNotifsByFilter("user1", true, 0, 10).size());
        webUsersEntity2.setShowPopover(false);
        this.webUsersDAO.update((Object)webUsersEntity2);
        EntityManagerHolder.get().clear();
        WebUsersDAOTest.assertEquals((int)1, (int)this.webUsersDAO.findWebNotifsByFilter("user1", false, 0, 10).size());
    }

    @Test
    public void testgetNotificationsByTypeAndParams() {
        WebNotifEntity webNotifEntity1 = new WebNotifEntity();
        webNotifEntity1.setType("plugin1");
        webNotifEntity1.setCreationDate(Calendar.getInstance());
        webNotifEntity1 = (WebNotifEntity)this.webNotifDAO.create((Object)webNotifEntity1);
        WebUsersEntity webUsersEntity1 = new WebUsersEntity();
        webUsersEntity1.setReceiver("user1");
        webUsersEntity1.setNotification(webNotifEntity1);
        webUsersEntity1.setUpdateDate(Calendar.getInstance());
        this.webUsersDAO.create((Object)webUsersEntity1);
        WebParamsEntity webParamsEntity1 = new WebParamsEntity();
        webParamsEntity1.setName("toto");
        webParamsEntity1.setValue("titi");
        webParamsEntity1.setNotification(webNotifEntity1);
        this.webParamsDAO.create((Object)webParamsEntity1);
        EntityManagerHolder.get().clear();
        WebUsersDAOTest.assertEquals((int)1, (int)this.webUsersDAO.findNotificationsByTypeAndParams("plugin1", "toto", "titi", "user1", 0, 10).size());
        WebUsersDAOTest.assertEquals((int)0, (int)this.webUsersDAO.findNotificationsByTypeAndParams("plugin2", "toto", "titi", "user1", 0, 10).size());
        WebUsersDAOTest.assertEquals((int)0, (int)this.webUsersDAO.findNotificationsByTypeAndParams("plugin1", "toto", "tata", "user1", 0, 10).size());
        WebUsersDAOTest.assertEquals((int)0, (int)this.webUsersDAO.findNotificationsByTypeAndParams("plugin1", "tata", "titi", "user1", 0, 10).size());
        WebUsersDAOTest.assertEquals((int)0, (int)this.webUsersDAO.findNotificationsByTypeAndParams("plugin1", "toto", "titi", "user2", 0, 10).size());
    }

    @Test
    public void testFindWebNotifsByLastUpdatedDate() {
        Calendar today = Calendar.getInstance();
        Calendar yesterday = (Calendar)today.clone();
        yesterday.add(5, -1);
        Calendar fourDaysAgo = (Calendar)today.clone();
        fourDaysAgo.add(5, -4);
        Calendar fiveDaysAgo = (Calendar)today.clone();
        fiveDaysAgo.add(5, -5);
        WebNotifEntity webNotifEntity1 = new WebNotifEntity();
        webNotifEntity1.setType("");
        webNotifEntity1.setCreationDate(today);
        webNotifEntity1 = (WebNotifEntity)this.webNotifDAO.create((Object)webNotifEntity1);
        WebNotifEntity webNotifEntity2 = new WebNotifEntity();
        webNotifEntity2.setType("");
        webNotifEntity2.setCreationDate(yesterday);
        webNotifEntity2 = (WebNotifEntity)this.webNotifDAO.create((Object)webNotifEntity2);
        WebNotifEntity webNotifEntity3 = new WebNotifEntity();
        webNotifEntity3.setType("");
        webNotifEntity3.setCreationDate(fourDaysAgo);
        webNotifEntity3 = (WebNotifEntity)this.webNotifDAO.create((Object)webNotifEntity3);
        WebUsersEntity webUsersEntity1 = new WebUsersEntity();
        webUsersEntity1.setUpdateDate(today);
        webUsersEntity1.setReceiver("user1");
        webUsersEntity1.setNotification(webNotifEntity1);
        webUsersEntity1 = (WebUsersEntity)this.webUsersDAO.create((Object)webUsersEntity1);
        WebUsersEntity webUsersEntity2 = new WebUsersEntity();
        webUsersEntity2.setUpdateDate(yesterday);
        webUsersEntity2.setReceiver("user1");
        webUsersEntity2.setNotification(webNotifEntity2);
        webUsersEntity2 = (WebUsersEntity)this.webUsersDAO.create((Object)webUsersEntity2);
        WebUsersEntity webUsersEntity3 = new WebUsersEntity();
        webUsersEntity3.setUpdateDate(fourDaysAgo);
        webUsersEntity3.setReceiver("user1");
        webUsersEntity3.setNotification(webNotifEntity3);
        webUsersEntity3 = (WebUsersEntity)this.webUsersDAO.create((Object)webUsersEntity3);
        this.end();
        this.begin();
        EntityManagerHolder.get().clear();
        WebUsersDAOTest.assertEquals((int)0, (int)this.webUsersDAO.findWebNotifsByLastUpdatedDate(fiveDaysAgo).size());
        WebUsersDAOTest.assertEquals((int)3, (int)this.webUsersDAO.findWebNotifsByLastUpdatedDate(Calendar.getInstance()).size());
        WebUsersDAOTest.assertEquals((int)1, (int)this.webUsersDAO.findWebNotifsByLastUpdatedDate(yesterday).size());
        WebUsersDAOTest.assertEquals((int)3, (int)this.webUsersDAO.findWebNotifsOfUserByLastUpdatedDate("user1", Calendar.getInstance()).size());
        WebUsersDAOTest.assertEquals((int)0, (int)this.webUsersDAO.findWebNotifsOfUserByLastUpdatedDate("user2", Calendar.getInstance()).size());
        WebUsersDAOTest.assertEquals((int)1, (int)this.webUsersDAO.findWebNotifsOfUserByLastUpdatedDate("user1", yesterday).size());
        WebUsersDAOTest.assertEquals((int)0, (int)this.webUsersDAO.findWebNotifsOfUserByLastUpdatedDate("user2", yesterday).size());
        WebUsersDAOTest.assertEquals((int)0, (int)this.webUsersDAO.findWebNotifsOfUserByLastUpdatedDate("user1", fiveDaysAgo).size());
    }

    @Test
    public void testFindUnreadNotification() {
        WebNotifEntity webNotifEntity1 = new WebNotifEntity();
        webNotifEntity1.setCreationDate(Calendar.getInstance());
        webNotifEntity1.setType("plugin1");
        webNotifEntity1 = (WebNotifEntity)this.webNotifDAO.create((Object)webNotifEntity1);
        WebNotifEntity webNotifEntity2 = new WebNotifEntity();
        webNotifEntity2.setCreationDate(Calendar.getInstance());
        webNotifEntity2.setType("plugin1");
        webNotifEntity2 = (WebNotifEntity)this.webNotifDAO.create((Object)webNotifEntity2);
        WebNotifEntity webNotifEntity3 = new WebNotifEntity();
        webNotifEntity3.setCreationDate(Calendar.getInstance());
        webNotifEntity3.setType("plugin1");
        webNotifEntity3 = (WebNotifEntity)this.webNotifDAO.create((Object)webNotifEntity3);
        WebNotifEntity webNotifEntity4 = new WebNotifEntity();
        webNotifEntity4.setCreationDate(Calendar.getInstance());
        webNotifEntity4.setType("plugin2");
        webNotifEntity4 = (WebNotifEntity)this.webNotifDAO.create((Object)webNotifEntity4);
        WebParamsEntity webParamsEntity1 = new WebParamsEntity();
        webParamsEntity1.setName("activityId");
        webParamsEntity1.setValue("1");
        webParamsEntity1.setNotification(webNotifEntity1);
        webParamsEntity1 = (WebParamsEntity)this.webParamsDAO.create((Object)webParamsEntity1);
        WebUsersEntity webUsersEntity1 = new WebUsersEntity();
        webUsersEntity1.setRead(false);
        webUsersEntity1.setReceiver("user1");
        webUsersEntity1.setUpdateDate(Calendar.getInstance());
        webUsersEntity1.setNotification(webNotifEntity1);
        webUsersEntity1 = (WebUsersEntity)this.webUsersDAO.create((Object)webUsersEntity1);
        WebParamsEntity webParamsEntity2 = new WebParamsEntity();
        webParamsEntity2.setName("activityId");
        webParamsEntity2.setValue("1");
        webParamsEntity2.setNotification(webNotifEntity2);
        webParamsEntity2 = (WebParamsEntity)this.webParamsDAO.create((Object)webParamsEntity2);
        WebUsersEntity webUsersEntity2 = new WebUsersEntity();
        webUsersEntity2.setRead(true);
        webUsersEntity2.setReceiver("user1");
        webUsersEntity2.setUpdateDate(Calendar.getInstance());
        webUsersEntity2.setNotification(webNotifEntity2);
        webUsersEntity2 = (WebUsersEntity)this.webUsersDAO.create((Object)webUsersEntity2);
        WebParamsEntity webParamsEntity3 = new WebParamsEntity();
        webParamsEntity3.setName("activityId");
        webParamsEntity3.setValue("1");
        webParamsEntity3.setNotification(webNotifEntity3);
        webParamsEntity3 = (WebParamsEntity)this.webParamsDAO.create((Object)webParamsEntity3);
        WebUsersEntity webUsersEntity3 = new WebUsersEntity();
        webUsersEntity3.setRead(false);
        webUsersEntity3.setReceiver("user2");
        webUsersEntity3.setUpdateDate(Calendar.getInstance());
        webUsersEntity3.setNotification(webNotifEntity3);
        webUsersEntity3 = (WebUsersEntity)this.webUsersDAO.create((Object)webUsersEntity3);
        WebParamsEntity webParamsEntity4 = new WebParamsEntity();
        webParamsEntity4.setName("activityId");
        webParamsEntity4.setValue("1");
        webParamsEntity4.setNotification(webNotifEntity4);
        webParamsEntity4 = (WebParamsEntity)this.webParamsDAO.create((Object)webParamsEntity4);
        WebUsersEntity webUsersEntity4 = new WebUsersEntity();
        webUsersEntity4.setRead(false);
        webUsersEntity4.setReceiver("user1");
        webUsersEntity4.setUpdateDate(Calendar.getInstance());
        webUsersEntity4.setNotification(webNotifEntity4);
        webUsersEntity4 = (WebUsersEntity)this.webUsersDAO.create((Object)webUsersEntity4);
        Calendar yesterday = Calendar.getInstance();
        yesterday.add(5, -1);
        WebUsersDAOTest.assertEquals((int)1, (int)this.webUsersDAO.findUnreadNotification("plugin1", "user2", "activityId", "1").size());
        WebUsersDAOTest.assertEquals((int)1, (int)this.webUsersDAO.findUnreadNotification("plugin2", "user1", "activityId", "1").size());
        WebUsersDAOTest.assertEquals((int)1, (int)this.webUsersDAO.findUnreadNotification("plugin1", "user2", "activityId", "1").size());
        WebUsersDAOTest.assertEquals((int)0, (int)this.webUsersDAO.findUnreadNotification("plugin1", "user2", "activityId", "2").size());
    }
}

