/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.lifecycle;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.PluginTemplateBuilderAdapter;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.notification.channel.WebChannel;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebNotifDAO;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebParamsDAO;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO;
import org.exoplatform.commons.notification.lifecycle.WebLifecycle;
import org.exoplatform.commons.testing.BaseCommonsTestCase;
import org.mockito.Mockito;

public class WebLifecycleTest
extends BaseCommonsTestCase {
    private WebNotificationService webNotificationService;
    private UserSettingService userSettingService;
    private WebNotifDAO webNotifDAO;
    private WebParamsDAO webParamsDAO;
    private WebUsersDAO webUsersDAO;

    public void setUp() throws Exception {
        super.setUp();
        this.webNotificationService = (WebNotificationService)this.getService(WebNotificationService.class);
        this.userSettingService = (UserSettingService)this.getService(UserSettingService.class);
        this.webNotifDAO = (WebNotifDAO)this.getService(WebNotifDAO.class);
        this.webParamsDAO = (WebParamsDAO)this.getService(WebParamsDAO.class);
        this.webUsersDAO = (WebUsersDAO)this.getService(WebUsersDAO.class);
        this.cleanData();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.cleanData();
    }

    public void testReceiveOneNotificationWhenUsersHaveDefaultSettings() {
        NotificationInfo notificationInfo = new NotificationInfo().key("TestPlugin");
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(notificationInfo);
        WebChannel webChannel = new WebChannel();
        WebLifecycle webLifecycle = (WebLifecycle)webChannel.getLifecycle();
        webLifecycle.process(ctx, new String[]{"john", "demo"});
        WebNotificationFilter filterJohn = new WebNotificationFilter("john", true);
        List webNotificationsJohn = this.webNotificationService.getNotificationInfos(filterJohn, 0, 10);
        WebLifecycleTest.assertNotNull((Object)webNotificationsJohn);
        WebLifecycleTest.assertEquals((int)1, (int)webNotificationsJohn.size());
        WebNotificationFilter filterDemo = new WebNotificationFilter("demo", true);
        List webNotificationsDemo = this.webNotificationService.getNotificationInfos(filterDemo, 0, 10);
        WebLifecycleTest.assertNotNull((Object)webNotificationsDemo);
        WebLifecycleTest.assertEquals((int)1, (int)webNotificationsDemo.size());
    }

    public void testReceiveOneNotificationWhenUsersHaveChannelDisabled() {
        NotificationInfo notificationInfo = new NotificationInfo().key("TestPlugin");
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(notificationInfo);
        UserSetting johnSettings = this.userSettingService.get("john");
        johnSettings.removeChannelActive("WEB_CHANNEL");
        this.userSettingService.save(johnSettings);
        WebChannel webChannel = new WebChannel();
        WebLifecycle webLifecycle = (WebLifecycle)webChannel.getLifecycle();
        webLifecycle.process(ctx, new String[]{"john", "demo"});
        WebNotificationFilter filterJohn = new WebNotificationFilter("john");
        List webNotificationsJohn = this.webNotificationService.getNotificationInfos(filterJohn, 0, 10);
        WebLifecycleTest.assertNotNull((Object)webNotificationsJohn);
        WebLifecycleTest.assertEquals((int)0, (int)webNotificationsJohn.size());
        WebNotificationFilter filterDemo = new WebNotificationFilter("demo");
        List webNotificationsDemo = this.webNotificationService.getNotificationInfos(filterDemo, 0, 10);
        WebLifecycleTest.assertNotNull((Object)webNotificationsDemo);
        WebLifecycleTest.assertEquals((int)1, (int)webNotificationsDemo.size());
    }

    public void testReceiveOneNotificationWhenUsersHavePluginDisabled() {
        NotificationInfo notificationInfo = new NotificationInfo().key("TestPlugin");
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(notificationInfo);
        UserSettingService userSettingService = (UserSettingService)this.getService(UserSettingService.class);
        UserSetting marySettings = userSettingService.get("mary");
        marySettings.removeChannelPlugin("WEB_CHANNEL", "TestPlugin");
        userSettingService.save(marySettings);
        WebChannel webChannel = new WebChannel();
        WebLifecycle webLifecycle = (WebLifecycle)webChannel.getLifecycle();
        webLifecycle.process(ctx, new String[]{"john", "mary"});
        WebNotificationFilter filterJohn = new WebNotificationFilter("john");
        List webNotificationsJohn = this.webNotificationService.getNotificationInfos(filterJohn, 0, 10);
        WebLifecycleTest.assertNotNull((Object)webNotificationsJohn);
        WebLifecycleTest.assertEquals((int)1, (int)webNotificationsJohn.size());
        WebNotificationFilter filterMary = new WebNotificationFilter("mary");
        List webNotificationsMary = this.webNotificationService.getNotificationInfos(filterMary, 0, 10);
        WebLifecycleTest.assertNotNull((Object)webNotificationsMary);
        WebLifecycleTest.assertEquals((int)0, (int)webNotificationsMary.size());
    }

    public void testReceiveAnUpdatedNotifWhenItWasPreviouslyRemovedFromPopover() {
        NotificationInfo notificationInfo = new NotificationInfo().key("TestPlugin");
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(notificationInfo);
        WebChannel webChannel = (WebChannel)Mockito.spy(WebChannel.class);
        WebLifecycle webLifecycle = (WebLifecycle)webChannel.getLifecycle();
        webLifecycle.process(ctx, new String[]{"john", "mary"});
        WebNotificationFilter filterJohn = new WebNotificationFilter("john", true);
        List webNotificationsJohn = this.webNotificationService.getNotificationInfos(filterJohn, 0, 10);
        WebLifecycleTest.assertNotNull((Object)webNotificationsJohn);
        WebLifecycleTest.assertEquals((int)1, (int)webNotificationsJohn.size());
        NotificationInfo notificationInfoJohn = (NotificationInfo)webNotificationsJohn.get(0);
        notificationInfoJohn.setOnPopOver(false);
        this.webNotificationService.save(notificationInfoJohn);
        Mockito.when((Object)webChannel.getTemplateBuilder(PluginKey.key((String)"TestPlugin"))).thenReturn((Object)new TemplateBuilderUpdate());
        NotificationContext ctxUpdate = NotificationContextImpl.cloneInstance();
        notificationInfoJohn.getOwnerParameter().put("ID_FOR_TEST", notificationInfoJohn.getId());
        ctxUpdate.setNotificationInfo(notificationInfoJohn);
        webLifecycle.process(ctxUpdate, new String[]{"john", "mary"});
        webNotificationsJohn = this.webNotificationService.getNotificationInfos(filterJohn, 0, 10);
        WebLifecycleTest.assertNotNull((Object)webNotificationsJohn);
        WebLifecycleTest.assertEquals((int)1, (int)webNotificationsJohn.size());
        WebLifecycleTest.assertTrue((boolean)((NotificationInfo)webNotificationsJohn.get(0)).isOnPopOver());
    }

    private void cleanData() {
        this.webUsersDAO.deleteAll();
        this.webParamsDAO.deleteAll();
        this.webNotifDAO.deleteAll();
        UserSetting userSetting = new UserSetting();
        userSetting.setUserId("john");
        userSetting.setChannelActive("MAIL_CHANNEL");
        userSetting.setChannelActive("WEB_CHANNEL");
        userSetting.setChannelPlugins("WEB_CHANNEL", Arrays.asList("TestPlugin"));
        this.userSettingService.save(userSetting);
        userSetting.setUserId("mary");
        this.userSettingService.save(userSetting);
    }

    class TemplateBuilderUpdate
    extends PluginTemplateBuilderAdapter {
        TemplateBuilderUpdate() {
        }

        public NotificationInfo getNotificationToStore(NotificationInfo notificationInfo) {
            NotificationInfo notificationToStore = super.getNotificationToStore(notificationInfo);
            if (notificationInfo.getTo().equals("john")) {
                notificationToStore.setId((String)notificationInfo.getOwnerParameter().get("ID_FOR_TEST"));
                notificationToStore.setOnPopOver(false);
                notificationToStore.setUpdate(true);
            }
            return notificationToStore;
        }
    }
}

