/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.user;

import java.util.Date;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.testing.BaseResourceTestCase;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.wadl.research.HTTPMethods;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.services.user.UserStateServiceREST;
import org.junit.Ignore;

@Ignore
public class RESTUserServiceTest
extends BaseResourceTestCase {
    private static final String USERNAME = "root";
    private UserStateService userStateService;

    public void setUp() throws Exception {
        super.setUp();
        UserStateServiceREST restUserService = (UserStateServiceREST)this.getService(UserStateServiceREST.class);
        this.resourceBinder.addResource((Object)restUserService, null);
        this.userStateService = (UserStateService)this.getService(UserStateService.class);
        ConversationState c = new ConversationState(new Identity(USERNAME));
        ConversationState.setCurrent((ConversationState)c);
    }

    public void tearDown() throws Exception {
        ExoCache cache = ((CacheService)this.getService(CacheService.class)).getCacheInstance("commons.UserStateService");
        cache.clearCache();
    }

    public void testUpdateState() throws Exception {
        String restPath = "/state/ping";
        UserStateModel userModel = new UserStateModel(USERNAME, new Date().getTime(), "available");
        this.userStateService.save(userModel);
        ContainerResponse response = this.service(HTTPMethods.GET.toString(), restPath, "", null, null);
        RESTUserServiceTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        RESTUserServiceTest.assertTrue((userModel.getLastActivity() != this.userStateService.getUserState(USERNAME).getLastActivity() ? 1 : 0) != 0);
    }

    public void testOnline() throws Exception {
        String restPath = "/state/status";
        UserStateModel userModel = new UserStateModel(USERNAME, new Date().getTime(), "available");
        this.userStateService.save(userModel);
        this.userStateService.ping(userModel.getUserId());
        ContainerResponse response = this.service(HTTPMethods.GET.toString(), restPath, "", null, null);
        RESTUserServiceTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        RESTUserServiceTest.assertTrue((boolean)response.getEntity().toString().contains("\"activity\":\"online\""));
        RESTUserServiceTest.assertTrue((boolean)response.getEntity().toString().contains("\"status\":\"" + userModel.getStatus() + "\""));
        RESTUserServiceTest.assertTrue((boolean)response.getEntity().toString().contains("\"userId\":\"" + userModel.getUserId() + "\""));
        RESTUserServiceTest.assertFalse((boolean)response.getEntity().toString().contains("\"userId\":\"" + userModel.getUserId() + "temp\""));
    }

    public void testGetStatus() throws Exception {
        String restPath = "/state/status/root";
        UserStateModel userModel = new UserStateModel(USERNAME, new Date().getTime(), "offline");
        this.userStateService.save(userModel);
        this.userStateService.ping(userModel.getUserId());
        ContainerResponse response = this.service(HTTPMethods.GET.toString(), restPath, "", null, null);
        RESTUserServiceTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        RESTUserServiceTest.assertTrue((boolean)response.getEntity().toString().contains("\"activity\":\"online\""));
        RESTUserServiceTest.assertTrue((boolean)response.getEntity().toString().contains("\"status\":\"" + userModel.getStatus() + "\""));
        RESTUserServiceTest.assertTrue((boolean)response.getEntity().toString().contains("\"userId\":\"" + userModel.getUserId() + "\""));
        RESTUserServiceTest.assertFalse((boolean)response.getEntity().toString().contains("\"userId\":\"" + userModel.getUserId() + "temp\""));
    }

    public void testSetStatus() throws Exception {
        String restPath = "/state/status/root?status=offline";
        UserStateModel userModel = new UserStateModel(USERNAME, new Date().getTime(), "available");
        this.userStateService.save(userModel);
        this.userStateService.ping(userModel.getUserId());
        RESTUserServiceTest.assertTrue((boolean)this.userStateService.getUserState(USERNAME).getStatus().equals("available"));
        ContainerResponse response = this.service(HTTPMethods.PUT.toString(), restPath, "", null, null);
        RESTUserServiceTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        RESTUserServiceTest.assertTrue((boolean)this.userStateService.getUserState(userModel.getUserId()).getStatus().equals("offline"));
    }
}

