/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.template;

import junit.framework.TestCase;
import org.exoplatform.commons.notification.template.TemplateUtils;

public class TemplateUtilsTestCase
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCleanHtmlTags() {
        String input = null;
        String expected = "";
        TemplateUtilsTestCase.assertEquals((String)expected, (String)TemplateUtils.cleanHtmlTags(input));
        expected = "test clean html test";
        input = "   test  clean   html  test  ";
        TemplateUtilsTestCase.assertEquals((String)expected, (String)TemplateUtils.cleanHtmlTags((String)input));
        input = "\n\n\n test \nclean html \n test \n\n\n";
        TemplateUtilsTestCase.assertEquals((String)expected, (String)TemplateUtils.cleanHtmlTags((String)input));
        input = "\n\n\n test \nclean<script type=\"text/javascript\"> alert(1); </script> <style type=\"text/css\" languge=\"en\">body {padding: 0px} .menu { color: #fff}</style> html\n test \n\n\n";
        TemplateUtilsTestCase.assertEquals((String)expected, (String)TemplateUtils.cleanHtmlTags((String)input));
        input = "\n\n\n test \nclean<script type=\"text/javascript\"> alert(1); </script> <style type=\"text/css\" languge=\"en\">body {padding: 0px} .menu { color: #fff}</style>  <br> <br ><br/> <br />html\n <b>test</b> \n\n\n";
        TemplateUtilsTestCase.assertEquals((String)expected, (String)TemplateUtils.cleanHtmlTags((String)input));
    }

    public void testGetExcerptSubject() {
        String input = null;
        String expected = "";
        TemplateUtilsTestCase.assertEquals((String)expected, (String)TemplateUtils.getExcerptSubject(input));
        input = "lorem ipsum dolor sit.";
        expected = "lorem ipsum dolor sit.";
        TemplateUtilsTestCase.assertEquals((String)expected, (String)TemplateUtils.getExcerptSubject((String)input));
        input = "&#21487; &#20197; &#21578; &#35785; &#25105;";
        expected = "\u53ef \u4ee5 \u544a \u8bc9 \u6211";
        TemplateUtilsTestCase.assertEquals((String)expected, (String)TemplateUtils.getExcerptSubject((String)input));
        input = "Lorem ipsum dolor sit amet, consectetuer elit adipiscing, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit";
        expected = "Lorem ipsum dolor sit amet, consectetuer elit...";
        TemplateUtilsTestCase.assertEquals((String)expected, (String)TemplateUtils.getExcerptSubject((String)input));
        input = "File-Uploaded-To-Space-Document-And-Long-Name-With-More-Than-50-characters.pdf";
        expected = "File-Uploaded-To-Space-Document-And-Long-Name-With...";
        TemplateUtilsTestCase.assertEquals((String)expected, (String)TemplateUtils.getExcerptSubject((String)input));
    }
}

