/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jpa.notifications.web.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.notification.BaseNotificationTestCase;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebNotifDAO;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebParamsDAO;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO;
import org.exoplatform.commons.persistence.impl.EntityManagerHolder;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

public class JPAWebNotificationStorageTest
extends BaseNotificationTestCase {
    private JPAWebNotificationStorage webNotificationStorage;
    private WebNotifDAO webNotifDAO;
    private WebUsersDAO webUsersDAO;
    private WebParamsDAO webParamsDAO;
    protected List<String> userIds;

    public JPAWebNotificationStorageTest() {
        this.setForceContainerReload(true);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.webNotificationStorage = (JPAWebNotificationStorage)this.getService(JPAWebNotificationStorage.class);
        this.webNotifDAO = (WebNotifDAO)this.getService(WebNotifDAO.class);
        this.webUsersDAO = (WebUsersDAO)this.getService(WebUsersDAO.class);
        this.webParamsDAO = (WebParamsDAO)this.getService(WebParamsDAO.class);
        this.userIds = new ArrayList<String>();
    }

    public void tearDown() throws Exception {
        this.webParamsDAO.deleteAll();
        this.webUsersDAO.deleteAll();
        this.webNotifDAO.deleteAll();
        super.tearDown();
    }

    public void testSaveWebNotification() throws Exception {
        String userId = "root";
        this.userIds.add(userId);
        NotificationInfo info = this.makeWebNotificationInfo(userId);
        this.webNotificationStorage.save(info);
        JPAWebNotificationStorageTest.assertEquals((int)1, (int)this.webNotificationStorage.get(new WebNotificationFilter(userId), 0, 10).size());
    }

    public void testMarkRead() throws Exception {
        String userId = "root";
        this.userIds.add(userId);
        NotificationInfo info = this.makeWebNotificationInfo(userId);
        this.webNotificationStorage.save(info);
        List list = this.webNotificationStorage.get(new WebNotificationFilter(userId), 0, 10);
        JPAWebNotificationStorageTest.assertEquals((int)1, (int)list.size());
        NotificationInfo notif = (NotificationInfo)list.get(0);
        JPAWebNotificationStorageTest.assertFalse((boolean)Boolean.valueOf((String)notif.getOwnerParameter().get(NotificationMessageUtils.READ_PORPERTY.getKey())));
        this.webNotificationStorage.markRead(notif.getId());
        notif = this.webNotificationStorage.get(notif.getId());
        JPAWebNotificationStorageTest.assertTrue((boolean)Boolean.valueOf((String)notif.getOwnerParameter().get(NotificationMessageUtils.READ_PORPERTY.getKey())));
    }

    public void testMarkReadAll() throws Exception {
        String userId = "demo";
        this.userIds.add(userId);
        for (int i = 0; i < 10; ++i) {
            NotificationInfo info = this.makeWebNotificationInfo(userId);
            this.webNotificationStorage.save(info);
        }
        List list = this.webNotificationStorage.get(new WebNotificationFilter(userId), 0, 10);
        JPAWebNotificationStorageTest.assertEquals((int)10, (int)list.size());
        for (NotificationInfo notif : list) {
            JPAWebNotificationStorageTest.assertFalse((boolean)Boolean.valueOf((String)notif.getOwnerParameter().get(NotificationMessageUtils.READ_PORPERTY.getKey())));
        }
        ConversationState.setCurrent((ConversationState)new ConversationState(new Identity(userId)));
        this.webNotificationStorage.markAllRead(userId);
        EntityManagerHolder.get().clear();
        list = this.webNotificationStorage.get(new WebNotificationFilter(userId), 0, 10);
        JPAWebNotificationStorageTest.assertEquals((int)10, (int)list.size());
        for (NotificationInfo notif : list) {
            JPAWebNotificationStorageTest.assertTrue((boolean)Boolean.valueOf(notif.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())));
        }
    }

    public void testUpdateJPANotification() throws Exception {
        String userId = "john";
        NotificationInfo info = this.makeWebNotificationInfo(userId);
        this.webNotificationStorage.save(info);
        NotificationInfo got = this.webNotificationStorage.get(info.getId());
        JPAWebNotificationStorageTest.assertEquals((String)"The title", (String)got.getTitle());
        long lastUpdatedTime = got.getLastModifiedDate();
        got = this.makeWebNotificationInfo(userId);
        got.setTitle("new title");
        got.setId(info.getId());
        Thread.sleep(1L);
        this.webNotificationStorage.update(got, true);
        this.restartTransaction();
        got = this.webNotificationStorage.get(got.getId());
        JPAWebNotificationStorageTest.assertEquals((String)"new title", (String)got.getTitle());
        JPAWebNotificationStorageTest.assertFalse((String)(got.getLastModifiedDate() + " should have been modified and not equal anymore to " + lastUpdatedTime), (lastUpdatedTime == got.getLastModifiedDate() ? 1 : 0) != 0);
        lastUpdatedTime = got.getLastModifiedDate();
        got.setTitle("new new title");
        this.webNotificationStorage.update(got, false);
        got = this.webNotificationStorage.get(got.getId());
        JPAWebNotificationStorageTest.assertEquals((String)"new new title", (String)got.getTitle());
        JPAWebNotificationStorageTest.assertTrue((String)(got.getLastModifiedDate() + " should equal to " + lastUpdatedTime), (lastUpdatedTime == got.getLastModifiedDate() ? 1 : 0) != 0);
    }

    public void testRemoveByJob() throws Exception {
        String userId = "demo";
        Calendar cal = Calendar.getInstance();
        long t = 86400000L;
        long current = cal.getTimeInMillis();
        for (int i = 12; i > 3; i -= 2) {
            cal.setTimeInMillis(current - (long)i * t);
            for (int j = 0; j < 10; ++j) {
                NotificationInfo info = this.makeWebNotificationInfo(userId).setDateCreated(cal);
                this.webNotificationStorage.save(info);
            }
        }
        this.webNotifDAO.findAll();
    }

    public void testGetNewMessage() throws Exception {
        JPAWebNotificationStorageTest.assertEquals((int)8, (int)NotificationMessageUtils.getMaxItemsInPopover());
        String userId = "root";
        this.userIds.add(userId);
        this.webNotificationStorage.save(this.makeWebNotificationInfo(userId));
        JPAWebNotificationStorageTest.assertEquals((int)1, (int)this.webNotificationStorage.getNumberOnBadge(userId));
        this.webNotificationStorage.save(this.makeWebNotificationInfo(userId));
        JPAWebNotificationStorageTest.assertEquals((int)2, (int)this.webNotificationStorage.getNumberOnBadge(userId));
        for (int i = 0; i < 10; ++i) {
            this.webNotificationStorage.save(this.makeWebNotificationInfo(userId));
        }
        List list = this.webNotificationStorage.get(new WebNotificationFilter(userId), 0, 15);
        JPAWebNotificationStorageTest.assertEquals((int)12, (int)list.size());
        JPAWebNotificationStorageTest.assertEquals((int)12, (int)this.webNotificationStorage.getNumberOnBadge(userId));
        this.webNotificationStorage.resetNumberOnBadge(userId);
        JPAWebNotificationStorageTest.assertEquals((int)0, (int)this.webNotificationStorage.getNumberOnBadge(userId));
    }

    public void testSpecialUserNameToGetMessage() throws Exception {
        String userId = "don't_blink_polarity";
        this.userIds.add(userId);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(cal.getTimeInMillis() - 259200000L);
        this.webNotificationStorage.save(this.makeWebNotificationInfo(userId).setDateCreated(cal).setLastModifiedDate(cal));
        EntityManagerHolder.get().clear();
        NotificationInfo unreadNotification = this.webNotificationStorage.getUnreadNotification("TestPlugin", "TheActivityId", userId);
        JPAWebNotificationStorageTest.assertNotNull((Object)unreadNotification);
        JPAWebNotificationStorageTest.assertEquals((String)"TestPlugin", (String)unreadNotification.getKey().getId());
        JPAWebNotificationStorageTest.assertEquals((int)1, (int)this.webNotificationStorage.getNumberOnBadge(userId));
        JPAWebNotificationStorageTest.assertTrue((boolean)this.webNotificationStorage.remove(userId, 86400L));
        JPAWebNotificationStorageTest.assertEquals((int)0, (int)this.webNotificationStorage.getNumberOnBadge(userId));
    }

    public void testRemoveByLiveTime() throws Exception {
        String userId = "demo";
        Calendar cal = Calendar.getInstance();
        long t = 86400000L;
        long current = cal.getTimeInMillis();
        for (int i = 12; i > 3; i -= 2) {
            cal.setTimeInMillis(current - (long)i * t);
            for (int j = 0; j < 10; ++j) {
                NotificationInfo info = this.makeWebNotificationInfo(userId).setDateCreated(cal);
                this.webNotificationStorage.save(info);
            }
        }
        this.webNotifDAO.findAll();
    }

    public void testGetNotificationsByTypeAndParams() {
        String userId = "toto";
        this.userIds.add(userId);
        NotificationInfo info = this.makeWebNotificationInfo(userId);
        this.webNotificationStorage.save(info);
        WebNotificationFilter referenceFilter = new WebNotificationFilter(userId);
        referenceFilter.setParameter("activityId", "TheActivityId");
        referenceFilter.setPluginKey(new PluginKey("TestPlugin"));
        List gotList = this.webNotificationStorage.get(referenceFilter, 0, 10);
        WebNotificationFilter fakeParameterFilter = new WebNotificationFilter(userId);
        fakeParameterFilter.setParameter("activityId", "fake");
        PluginKey pluginKey = new PluginKey("TestPlugin");
        fakeParameterFilter.setPluginKey(pluginKey);
        WebNotificationFilter fakePluginFilter = new WebNotificationFilter(userId);
        fakePluginFilter.setParameter("activityId", "TheActivityId");
        fakePluginFilter.setPluginKey(new PluginKey("FakePluginId"));
        JPAWebNotificationStorageTest.assertEquals((int)0, (int)this.webNotificationStorage.get(fakePluginFilter, 0, 10).size());
        JPAWebNotificationStorageTest.assertEquals((int)0, (int)this.webNotificationStorage.get(fakeParameterFilter, 0, 10).size());
        JPAWebNotificationStorageTest.assertEquals((int)1, (int)this.webNotificationStorage.get(referenceFilter, 0, 10).size());
        JPAWebNotificationStorageTest.assertEquals((String)info.getId(), (String)((NotificationInfo)gotList.get(0)).getId());
    }
}

