/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.template;

import org.exoplatform.commons.api.notification.template.Element;
import org.exoplatform.commons.api.notification.template.ElementVisitor;
import org.exoplatform.commons.notification.template.SimpleElement;

public class DigestTemplate
extends SimpleElement {
    private final Element digestOne = new SimpleElement().addNewLine(false);
    private final Element digestThree = new SimpleElement().addNewLine(false);
    private final Element digestMore = new SimpleElement().addNewLine(false);

    public DigestTemplate digestOne(String template) {
        this.digestOne.template(template);
        return this;
    }

    public DigestTemplate digestThree(String template) {
        this.digestThree.template(template);
        return this;
    }

    public DigestTemplate digestMore(String template) {
        this.digestMore.template(template);
        return this;
    }

    @Override
    public ElementVisitor accept(ElementVisitor visitor) {
        if (visitor.getTemplateContext().getDigestSize() == ElementType.DIGEST_ONE.getValue()) {
            visitor.visit(this.digestOne);
        } else if (visitor.getTemplateContext().getDigestSize() <= ElementType.DIGEST_THREE.getValue()) {
            visitor.visit(this.digestThree);
        } else if (visitor.getTemplateContext().getDigestSize() >= ElementType.DIGEST_MORE.getValue()) {
            visitor.visit(this.digestMore);
        }
        return visitor;
    }

    public static enum ElementType {
        DIGEST_ONE(1),
        DIGEST_THREE(3),
        DIGEST_MORE(4);

        private int value = 0;

        private ElementType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

