/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.storage;

import java.util.Calendar;
import java.util.List;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.notification.BaseNotificationTestCase;

public class WebNotificationStorageTest
extends BaseNotificationTestCase {
    public void testSaveWebNotification() throws Exception {
        String userId = "root1";
        this.userIds.add(userId);
        NotificationInfo info = this.makeWebNotificationInfo(userId);
        this.storage.save(info);
        WebNotificationStorageTest.assertEquals((int)1, (int)this.storage.get(new WebNotificationFilter(userId), 0, 10).size());
    }

    public void testMarkRead() throws Exception {
        String userId = "root2";
        this.userIds.add(userId);
        NotificationInfo info = this.makeWebNotificationInfo(userId);
        this.storage.save(info);
        List list = this.storage.get(new WebNotificationFilter(userId), 0, 10);
        WebNotificationStorageTest.assertEquals((int)1, (int)list.size());
        NotificationInfo notif = (NotificationInfo)list.get(0);
        WebNotificationStorageTest.assertFalse((boolean)notif.isRead());
        this.storage.markRead(notif.getId());
        notif = this.storage.get(notif.getId());
        WebNotificationStorageTest.assertTrue((boolean)notif.isRead());
    }

    public void testMarkReadAll() throws Exception {
        String userId = "demo18";
        this.userIds.add(userId);
        for (int i = 0; i < 10; ++i) {
            NotificationInfo info = this.makeWebNotificationInfo(userId);
            this.storage.save(info);
        }
        List list = this.storage.get(new WebNotificationFilter(userId), 0, 10);
        WebNotificationStorageTest.assertEquals((int)10, (int)list.size());
        for (NotificationInfo notif : list) {
            WebNotificationStorageTest.assertFalse((boolean)notif.isRead());
        }
        this.storage.markAllRead(userId);
        this.restartTransaction();
        list = this.storage.get(new WebNotificationFilter(userId), 0, 10);
        WebNotificationStorageTest.assertEquals((int)10, (int)list.size());
        for (NotificationInfo notif : list) {
            WebNotificationStorageTest.assertTrue((boolean)notif.isRead());
        }
    }

    public void testUpdateNotification() throws Exception {
        String userId = "john5";
        NotificationInfo info = this.makeWebNotificationInfo(userId);
        this.storage.save(info);
        String notifId = info.getId();
        NotificationInfo got = this.storage.get(notifId);
        WebNotificationStorageTest.assertNotNull((Object)got);
        WebNotificationStorageTest.assertEquals((String)"The title", (String)got.getTitle());
        long lastUpdatedTime = got.getLastModifiedDate();
        got = this.makeWebNotificationInfo(userId);
        got.setId(notifId);
        got.setTitle("new title");
        Thread.sleep(1L);
        this.storage.update(got, true);
        this.restartTransaction();
        got = this.storage.get(got.getId());
        WebNotificationStorageTest.assertEquals((String)"new title", (String)got.getTitle());
        WebNotificationStorageTest.assertFalse((String)(got.getLastModifiedDate() + " should have been modified and not equal anymore to " + lastUpdatedTime), (lastUpdatedTime == got.getLastModifiedDate() ? 1 : 0) != 0);
        lastUpdatedTime = got.getLastModifiedDate();
        got.setTitle("new new title");
        this.storage.update(got, false);
        this.restartTransaction();
        got = this.storage.get(notifId);
        WebNotificationStorageTest.assertEquals((String)"new new title", (String)got.getTitle());
        WebNotificationStorageTest.assertTrue((String)(got.getLastModifiedDate() + " should be equal to " + lastUpdatedTime), (lastUpdatedTime == got.getLastModifiedDate() ? 1 : 0) != 0);
    }

    public void testGetNewMessage() throws Exception {
        String userId = "root16";
        this.userIds.add(userId);
        this.storage.save(this.makeWebNotificationInfo(userId));
        WebNotificationStorageTest.assertEquals((int)1, (int)this.storage.getNumberOnBadge(userId));
        this.storage.save(this.makeWebNotificationInfo(userId));
        WebNotificationStorageTest.assertEquals((int)2, (int)this.storage.getNumberOnBadge(userId));
        for (int i = 0; i < 10; ++i) {
            this.storage.save(this.makeWebNotificationInfo(userId));
        }
        List list = this.storage.get(new WebNotificationFilter(userId), 0, 15);
        WebNotificationStorageTest.assertEquals((int)12, (int)list.size());
        WebNotificationStorageTest.assertEquals((int)12, (int)this.storage.getNumberOnBadge(userId));
        this.storage.resetNumberOnBadge(userId);
        WebNotificationStorageTest.assertEquals((int)0, (int)this.storage.getNumberOnBadge(userId));
    }

    public void testSpecialUserNameToGetMessage() throws Exception {
        String userId = "don't_blink_polarity";
        this.userIds.add(userId);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(cal.getTimeInMillis() - 259200000L);
        NotificationInfo notification = this.makeWebNotificationInfo(userId);
        notification.setDateCreated(cal);
        notification.setLastModifiedDate(cal);
        this.storage.save(notification);
        WebNotificationStorageTest.assertEquals((String)"TestPlugin", (String)this.storage.getUnreadNotification("TestPlugin", "TheActivityId", userId).getKey().getId());
        WebNotificationStorageTest.assertEquals((int)1, (int)this.storage.getNumberOnBadge(userId));
        WebNotificationStorageTest.assertTrue((boolean)this.storage.remove(userId, 172800L));
        WebNotificationStorageTest.assertEquals((int)0, (int)this.storage.getNumberOnBadge(userId));
    }
}

