/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jpa.notifications.email.impl;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.impl.jpa.email.JPAMailNotificationStorage;
import org.exoplatform.commons.notification.impl.jpa.email.dao.MailDigestDAO;
import org.exoplatform.commons.notification.impl.jpa.email.dao.MailNotifDAO;
import org.exoplatform.commons.notification.impl.jpa.email.dao.MailParamDAO;
import org.exoplatform.commons.notification.job.NotificationJob;
import org.exoplatform.commons.persistence.impl.EntityManagerHolder;
import org.exoplatform.jpa.BaseTest;

public class JPANotificationServiceTest
extends BaseTest {
    private NotificationService notificationService;
    private JPAMailNotificationStorage notificationDataStorage;
    private MailNotifDAO mailNotifDAO;
    private MailDigestDAO mailDigestDAO;
    private MailParamDAO mailParamDAO;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.notificationService = this.getService(NotificationService.class);
        this.notificationDataStorage = this.getService(JPAMailNotificationStorage.class);
        this.mailNotifDAO = this.getService(MailNotifDAO.class);
        this.mailDigestDAO = this.getService(MailDigestDAO.class);
        this.mailParamDAO = this.getService(MailParamDAO.class);
    }

    @Override
    public void tearDown() throws Exception {
        this.mailParamDAO.deleteAll();
        this.mailDigestDAO.deleteAll();
        this.mailNotifDAO.deleteAll();
        super.tearDown();
    }

    private NotificationInfo saveNotification(String userDaily, String userWeekly) throws Exception {
        NotificationInfo notification = NotificationInfo.instance();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectId", "idofobject");
        notification.key("TestPlugin").setSendToDaily(userDaily).setSendToWeekly(userWeekly).setOwnerParameter(params).setOrder(1);
        this.notificationDataStorage.save(notification);
        return notification;
    }

    public void testServiceNotNull() throws Exception {
        JPANotificationServiceTest.assertNotNull((Object)this.notificationService);
        JPANotificationServiceTest.assertNotNull((Object)this.notificationDataStorage);
        this.saveNotification("root", "demo");
    }

    public void testSave() throws Exception {
        this.saveNotification("root", "demo");
        NotificationContext context = NotificationContextImpl.cloneInstance();
        context.append(NotificationJob.JOB_DAILY, (Object)true);
        String dayName = String.valueOf(Calendar.getInstance().get(5));
        context.append(NotificationJob.DAY_OF_JOB, (Object)dayName);
        UserSetting userSetting = UserSetting.getInstance();
        userSetting.setUserId("root").addPlugin("TestPlugin", UserSetting.FREQUENCY.DAILY);
        userSetting.setChannelActive("MAIL_CHANNEL");
        EntityManagerHolder.get().clear();
        Map map = this.notificationDataStorage.getByUser(context, userSetting);
        List list = (List)map.get(new PluginKey("TestPlugin"));
        JPANotificationServiceTest.assertEquals((int)1, (int)list.size());
        JPANotificationServiceTest.assertTrue((boolean)((NotificationInfo)list.get(0)).getTo().equals("root"));
    }

    public void testNormalGetByUserAndRemoveMessagesSentByContext() throws Exception {
        NotificationInfo notification = this.saveNotification("test", "demo");
        UserSetting userSetting = UserSetting.getInstance();
        userSetting.setUserId("test").addPlugin("TestPlugin", UserSetting.FREQUENCY.DAILY);
        userSetting.setChannelActive("MAIL_CHANNEL");
        NotificationContext context = NotificationContextImpl.cloneInstance();
        context.append(NotificationJob.JOB_DAILY, (Object)true);
        String dayName = String.valueOf(Calendar.getInstance().get(5));
        context.append(NotificationJob.DAY_OF_JOB, (Object)dayName);
        context.append(NotificationJob.JOB_WEEKLY, (Object)false);
        EntityManagerHolder.get().clear();
        Map map = this.notificationDataStorage.getByUser(context, userSetting);
        List list = (List)map.get(new PluginKey("TestPlugin"));
        JPANotificationServiceTest.assertEquals((int)1, (int)list.size());
        JPANotificationServiceTest.assertTrue((boolean)((NotificationInfo)list.get(0)).getKey().equals((Object)notification.getKey()));
        JPANotificationServiceTest.assertTrue((boolean)((NotificationInfo)list.get(0)).getOwnerParameter().equals(notification.getOwnerParameter()));
        context = NotificationContextImpl.cloneInstance();
        context.append(NotificationJob.JOB_DAILY, (Object)false);
        context.append(NotificationJob.JOB_WEEKLY, (Object)true);
        userSetting.setUserId("demo").addPlugin("TestPlugin", UserSetting.FREQUENCY.WEEKLY);
        map = this.notificationDataStorage.getByUser(context, userSetting);
        list = (List)map.get(new PluginKey("TestPlugin"));
        JPANotificationServiceTest.assertEquals((int)1, (int)list.size());
        notification = this.saveNotification("test", "demo");
        this.notificationDataStorage.removeMessageAfterSent(context);
        context = NotificationContextImpl.cloneInstance();
        context.append(NotificationJob.JOB_DAILY, (Object)false);
        context.append(NotificationJob.JOB_WEEKLY, (Object)true);
        map = this.notificationDataStorage.getByUser(context, userSetting);
        list = (List)map.get(new PluginKey("TestPlugin"));
        JPANotificationServiceTest.assertNotNull((Object)list);
        JPANotificationServiceTest.assertEquals((int)1, (int)list.size());
        JPANotificationServiceTest.assertEquals((String)notification.getId(), (String)((NotificationInfo)list.get(0)).getId());
    }

    public void testNormalGetByUserAndRemoveMessagesSent() throws Exception {
        NotificationInfo notification = this.saveNotification("test", "demo");
        UserSetting userSetting = UserSetting.getInstance();
        userSetting.setUserId("test").addPlugin("TestPlugin", UserSetting.FREQUENCY.DAILY);
        userSetting.setChannelActive("MAIL_CHANNEL");
        NotificationContext context = NotificationContextImpl.cloneInstance();
        context.append(NotificationJob.JOB_DAILY, (Object)true);
        String dayName = String.valueOf(Calendar.getInstance().get(5));
        context.append(NotificationJob.DAY_OF_JOB, (Object)dayName);
        context.append(NotificationJob.JOB_WEEKLY, (Object)false);
        EntityManagerHolder.get().clear();
        Map map = this.notificationDataStorage.getByUser(context, userSetting);
        List list = (List)map.get(new PluginKey("TestPlugin"));
        JPANotificationServiceTest.assertEquals((int)1, (int)list.size());
        JPANotificationServiceTest.assertTrue((boolean)((NotificationInfo)list.get(0)).getKey().equals((Object)notification.getKey()));
        JPANotificationServiceTest.assertTrue((boolean)((NotificationInfo)list.get(0)).getOwnerParameter().equals(notification.getOwnerParameter()));
        context = NotificationContextImpl.cloneInstance();
        context.append(NotificationJob.JOB_DAILY, (Object)false);
        context.append(NotificationJob.JOB_WEEKLY, (Object)true);
        userSetting.setUserId("demo").addPlugin("TestPlugin", UserSetting.FREQUENCY.WEEKLY);
        map = this.notificationDataStorage.getByUser(context, userSetting);
        list = (List)map.get(new PluginKey("TestPlugin"));
        JPANotificationServiceTest.assertEquals((int)1, (int)list.size());
        context.remove(JPAMailNotificationStorage.DAILY_NOTIFS);
        context.remove(JPAMailNotificationStorage.WEEKLY_NOTIFS);
        notification = this.saveNotification("test", "demo");
        this.notificationDataStorage.removeMessageAfterSent(context);
        context = NotificationContextImpl.cloneInstance();
        context.append(NotificationJob.JOB_DAILY, (Object)false);
        context.append(NotificationJob.JOB_WEEKLY, (Object)true);
        map = this.notificationDataStorage.getByUser(context, userSetting);
        list = (List)map.get(new PluginKey("TestPlugin"));
        JPANotificationServiceTest.assertNull((Object)list);
    }

    public void testSpecialGetByUserAndRemoveMessagesSent() throws Exception {
        NotificationInfo notification = NotificationInfo.instance();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectId", "idofobject");
        notification.key("TestPlugin").setSendAll(true).setOwnerParameter(params).setOrder(1);
        this.notificationDataStorage.save(notification);
        UserSetting userSetting = UserSetting.getInstance();
        userSetting.setUserId("root").addPlugin("TestPlugin", UserSetting.FREQUENCY.DAILY);
        userSetting.setChannelActive("MAIL_CHANNEL");
        NotificationContext context = NotificationContextImpl.cloneInstance();
        context.append(NotificationJob.JOB_DAILY, (Object)true);
        String dayName = String.valueOf(Calendar.getInstance().get(5));
        context.append(NotificationJob.DAY_OF_JOB, (Object)dayName);
        context.append(NotificationJob.JOB_WEEKLY, (Object)false);
        EntityManagerHolder.get().clear();
        Map map = this.notificationDataStorage.getByUser(context, userSetting);
        List list = (List)map.get(new PluginKey("TestPlugin"));
        JPANotificationServiceTest.assertEquals((int)1, (int)list.size());
        JPANotificationServiceTest.assertTrue((boolean)((NotificationInfo)list.get(0)).getKey().equals((Object)notification.getKey()));
        JPANotificationServiceTest.assertTrue((boolean)((NotificationInfo)list.get(0)).getOwnerParameter().equals(notification.getOwnerParameter()));
        this.notificationDataStorage.removeMessageAfterSent(context);
        context = NotificationContextImpl.cloneInstance();
        context.append(NotificationJob.JOB_DAILY, (Object)false);
        context.append(NotificationJob.JOB_WEEKLY, (Object)true);
        userSetting.setUserId("demo").addPlugin("TestPlugin", UserSetting.FREQUENCY.WEEKLY);
        map = this.notificationDataStorage.getByUser(context, userSetting);
        list = (List)map.get(new PluginKey("TestPlugin"));
        JPANotificationServiceTest.assertEquals((int)1, (int)list.size());
        context.append(NotificationJob.JOB_DAILY, (Object)true);
        this.notificationDataStorage.removeMessageAfterSent(context);
        context = NotificationContextImpl.cloneInstance();
        context.append(NotificationJob.JOB_DAILY, (Object)false);
        context.append(NotificationJob.JOB_WEEKLY, (Object)true);
        map = this.notificationDataStorage.getByUser(context, userSetting);
        list = (List)map.get(new PluginKey("TestPlugin"));
        JPANotificationServiceTest.assertNull((Object)list);
    }

    public void testWithUserNameContainSpecialCharacter() throws Exception {
        String userNameSpecial = "Rabe'e \"AbdelWahab\u00f4";
        NotificationContext context = NotificationContextImpl.cloneInstance();
        context.append(NotificationJob.JOB_DAILY, (Object)true);
        String dayName = String.valueOf(Calendar.getInstance().get(5));
        context.append(NotificationJob.DAY_OF_JOB, (Object)dayName);
        context.append(NotificationJob.JOB_WEEKLY, (Object)false);
        NotificationInfo notification = this.saveNotification(userNameSpecial, "demo");
        UserSetting userSetting = UserSetting.getInstance();
        userSetting.setUserId(userNameSpecial).addPlugin("TestPlugin", UserSetting.FREQUENCY.DAILY);
        userSetting.setChannelActive("MAIL_CHANNEL");
        EntityManagerHolder.get().clear();
        Map map = this.notificationDataStorage.getByUser(context, userSetting);
        List list = (List)map.get(new PluginKey("TestPlugin"));
        JPANotificationServiceTest.assertEquals((int)1, (int)list.size());
        JPANotificationServiceTest.assertTrue((boolean)((NotificationInfo)list.get(0)).getKey().equals((Object)notification.getKey()));
        JPANotificationServiceTest.assertTrue((boolean)((NotificationInfo)list.get(0)).getOwnerParameter().equals(notification.getOwnerParameter()));
    }
}

