/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification;

import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.PluginTemplateBuilderAdapter;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.service.setting.PluginContainer;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.BaseNotificationTestCase;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.template.TemplateUtils;

public class PluginContainerTest
extends BaseNotificationTestCase {
    private PluginContainer container;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.container = (PluginContainer)this.getService(PluginContainer.class);
        PluginContainerTest.assertNotNull((Object)this.container);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPlugin() {
        PluginKey pluginKey = new PluginKey("TestPlugin");
        BaseNotificationPlugin plugin = this.container.getPlugin(pluginKey);
        PluginContainerTest.assertNotNull((Object)plugin);
        List chikdKeys = this.container.getChildPluginKeys(pluginKey);
        PluginContainerTest.assertEquals((int)1, (int)chikdKeys.size());
        PluginContainerTest.assertEquals((String)"Child_Plugin", (String)((PluginKey)chikdKeys.get(0)).getId());
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        NotificationInfo notificationInfo = plugin.buildNotification(ctx);
        PluginContainerTest.assertNotNull((Object)notificationInfo);
        PluginContainerTest.assertEquals((String)"demo", (String)((String)notificationInfo.getSendToUserIds().get(0)));
        PluginContainerTest.assertEquals((String)"TestPlugin", (String)notificationInfo.getKey().getId());
        ctx.setNotificationInfo(notificationInfo);
        AbstractChannel channel = ctx.getChannelManager().getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        PluginContainerTest.assertNotNull((Object)channel);
        AbstractTemplateBuilder builder = channel.getTemplateBuilder(pluginKey);
        MessageInfo messageInfo = builder.buildMessage(ctx);
        PluginContainerTest.assertEquals((String)"The subject Test plugin notification", (String)messageInfo.getSubject());
        PluginContainerTest.assertTrue((messageInfo.getBody().indexOf("root") > 0 ? 1 : 0) != 0);
        PluginContainerTest.assertTrue((messageInfo.getBody().indexOf("Test value") > 0 ? 1 : 0) != 0);
        PluginContainerTest.assertTrue((messageInfo.getBody().indexOf("The test plugin") > 0 ? 1 : 0) != 0);
        PluginContainerTest.assertTrue((messageInfo.getBody().indexOf("The content of child plugin") > 0 ? 1 : 0) != 0);
        PluginContainerTest.assertTrue((messageInfo.getBody().indexOf("The test child plugin") > 0 ? 1 : 0) != 0);
    }

    public void testPLF41Plugin() {
        PluginKey pluginKey = new PluginKey("PluginPLF41Test");
        BaseNotificationPlugin plugin = this.container.getPlugin(pluginKey);
        PluginContainerTest.assertNotNull((Object)plugin);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        NotificationInfo notificationInfo = plugin.buildNotification(ctx);
        PluginContainerTest.assertNotNull((Object)notificationInfo);
        PluginContainerTest.assertEquals((String)"demo", (String)notificationInfo.getTo());
        PluginContainerTest.assertEquals((String)"PluginPLF41Test", (String)notificationInfo.getKey().getId());
        ctx.setNotificationInfo(notificationInfo);
        AbstractChannel channel = ctx.getChannelManager().getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        PluginContainerTest.assertNotNull((Object)channel);
        AbstractTemplateBuilder templateBuilder = channel.getTemplateBuilder(pluginKey);
        PluginContainerTest.assertTrue((boolean)(templateBuilder instanceof PluginTemplateBuilderAdapter));
        MessageInfo messageInfo = templateBuilder.buildMessage(ctx);
        PluginContainerTest.assertEquals((String)"PluginPLF41Test subject the message", (String)messageInfo.getSubject());
        PluginContainerTest.assertTrue((messageInfo.getBody().indexOf("The test plugin") > 0 ? 1 : 0) != 0);
    }

    public void testRenderPlugin() throws Exception {
        TemplateContext ctx = TemplateContext.newChannelInstance((ChannelKey)ChannelKey.key((String)"MAIL_CHANNEL"), (String)"DigestDailyPlugin", null);
        ctx.put((Object)"FIRSTNAME", (Object)"User ROOT");
        ctx.put((Object)"USER", (Object)"root");
        ctx.put((Object)"ACTIVITY", (Object)"Content of Activity");
        String s = TemplateUtils.processGroovy((TemplateContext)ctx);
        PluginContainerTest.assertEquals((boolean)true, (s.indexOf("Test resource bundle.") > 0 ? 1 : 0) != 0);
        PluginContainerTest.assertEquals((boolean)true, (s.indexOf("Content of Activity") > 0 ? 1 : 0) != 0);
    }
}

