/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.cluster;

import org.exoplatform.commons.cluster.StartableClusterAware;
import org.exoplatform.commons.testing.BaseCommonsTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/standalone/test-cluster-configuration.xml")})
public class StartableClusterAwareTest
extends BaseCommonsTestCase {
    public static int nbRunningA = 0;
    public static int nbRunningB = 0;
    public static int nbRunningC = 0;

    public void testRunningService() {
        StartableClusterAwareTest.assertEquals((int)1, (int)nbRunningA);
        StartableClusterAwareTest.assertEquals((int)1, (int)nbRunningB);
        StartableClusterAwareTest.assertEquals((int)0, (int)nbRunningC);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        StartableClusterAwareTest.assertEquals((int)1, (int)nbRunningA);
        StartableClusterAwareTest.assertEquals((int)1, (int)nbRunningB);
        StartableClusterAwareTest.assertEquals((int)0, (int)nbRunningC);
    }

    public static class ClassC
    implements StartableClusterAware {
        public void start() {
            ++nbRunningB;
        }

        public boolean isDone() {
            return true;
        }
    }

    public static class ClassB
    implements StartableClusterAware {
        private boolean isDone = false;

        public void start() {
            ++nbRunningB;
            this.isDone = true;
        }

        public boolean isDone() {
            return this.isDone;
        }
    }

    public static class ClassA
    implements StartableClusterAware {
        private boolean isDone = false;

        public void start() {
            ++nbRunningA;
            this.isDone = true;
        }

        public boolean isDone() {
            return this.isDone;
        }
    }
}

